/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LoginRedirectServlet
extends HttpServlet {
    public static final String DISPLAY_AFTER_LOGIN_INIT_PARAM = "display-after-login";
    private String displayAfterLoginUri;

    public void init(ServletConfig config) throws ServletException {
        String contextRelativeHostPageUri = config.getInitParameter(DISPLAY_AFTER_LOGIN_INIT_PARAM);
        if (contextRelativeHostPageUri == null) {
            throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " requires that you set the init parameter \"" + DISPLAY_AFTER_LOGIN_INIT_PARAM + "\" to the context-relative URI of the host page.");
        }
        this.displayAfterLoginUri = config.getServletContext().getContextPath() + contextRelativeHostPageUri;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        System.out.println(((Object)((Object)this)).getClass().getSimpleName() + " is redirecting " + req.getUserPrincipal() + " to " + this.displayAfterLoginUri);
        StringBuilder redirectTarget = new StringBuilder(this.displayAfterLoginUri);
        String extraParams = LoginRedirectServlet.extractParameters(req);
        if (extraParams.length() > 0) {
            redirectTarget.append("?").append(extraParams);
        }
        resp.sendRedirect(redirectTarget.toString());
    }

    private static String extractParameters(HttpServletRequest fromRequest) {
        try {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry param : fromRequest.getParameterMap().entrySet()) {
                String paramName = URLEncoder.encode((String)param.getKey(), "UTF-8");
                if (paramName.equals("j_username") || paramName.equals("j_password")) continue;
                for (String value : (String[])param.getValue()) {
                    if (sb.length() != 0) {
                        sb.append("&");
                    }
                    sb.append(paramName).append("=").append(URLEncoder.encode(value, "UTF-8"));
                }
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 not supported on this JVM?");
        }
    }
}

