/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.errai.marshalling.server.MappingContextSingleton;
import org.jboss.errai.security.shared.api.UserCookieEncoder;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.uberfire.ext.security.server.RolesRegistry;

public class SecurityIntegrationFilter
implements Filter {
    @Inject
    private AuthenticationService authenticationService;
    public static final String PROBE_ROLES_INIT_PARAM = "probe-for-roles";
    private static final ThreadLocal<HttpServletRequest> requests = new ThreadLocal();

    public void init(FilterConfig filterConfig) throws ServletException {
        MappingContextSingleton.get();
        String commaSeparatedRoles = filterConfig.getInitParameter(PROBE_ROLES_INIT_PARAM);
        if (commaSeparatedRoles != null) {
            for (String role : Collections.unmodifiableList(Arrays.asList(commaSeparatedRoles.split(",")))) {
                RolesRegistry.get().registerRole(role);
            }
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        requests.set((HttpServletRequest)request);
        User user = this.authenticationService.getUser();
        if (user != null) {
            Cookie erraiUserCacheCookie = new Cookie("errai-active-user", UserCookieEncoder.toCookieValue((User)user));
            ((HttpServletResponse)response).addCookie(erraiUserCacheCookie);
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            requests.remove();
        }
    }

    public static HttpServletRequest getRequest() {
        return requests.get();
    }
}

