/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.security.server;

import java.io.IOException;
import java.util.Calendar;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheHeadersFilter
implements Filter {
    static final String EXPIRES_HEADER = "Expires";
    static final String CACHE_CONTROL_HEADER = "Cache-Control";
    static final String PRAGMA_HEADER = "Pragma";
    static final int YEAR_IN_SECONDS = 31536000;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String requestURI = httpServletRequest.getRequestURI();
        if (requestURI.contains(".cache.")) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(13, 31536000);
            httpServletResponse.setHeader(CACHE_CONTROL_HEADER, "max-age=31536000, must-revalidate");
            httpServletResponse.setDateHeader(EXPIRES_HEADER, calendar.getTime().getTime());
        } else if (requestURI.endsWith(".nocache.js") || requestURI.endsWith(".html")) {
            httpServletResponse.setHeader(CACHE_CONTROL_HEADER, "no-cache, no-store, must-revalidate");
            httpServletResponse.setHeader(PRAGMA_HEADER, "no-cache");
            httpServletResponse.setDateHeader(EXPIRES_HEADER, 0L);
        }
        chain.doFilter(request, response);
    }
}

