/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.items;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.constants.ButtonType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.client.docks.view.items.AbstractDockItem;
import org.uberfire.client.resources.WebAppResource;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.mvp.ParameterizedCommand;

public class SouthDockItem
extends AbstractDockItem {
    private final ParameterizedCommand<String> selectCommand;
    private final ParameterizedCommand<String> deselectCommand;
    private boolean selected;
    private static WebAppResource CSS = (WebAppResource)GWT.create(WebAppResource.class);
    @UiField
    Button itemButton;
    private ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);

    SouthDockItem(UberfireDock dock, final ParameterizedCommand<String> selectCommand, final ParameterizedCommand<String> deselectCommand) {
        super(dock);
        this.selectCommand = selectCommand;
        this.deselectCommand = deselectCommand;
        this.initWidget((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.itemButton.setIcon(this.getIcon());
        this.itemButton.setText(dock.getLabel());
        this.itemButton.setSize(ButtonSize.SMALL);
        this.itemButton.getElement().addClassName(CSS.CSS().southDockItem());
        this.itemButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!SouthDockItem.this.selected) {
                    SouthDockItem.this.select();
                    selectCommand.execute((Object)SouthDockItem.this.getIdentifier());
                } else {
                    SouthDockItem.this.deselect();
                    deselectCommand.execute((Object)SouthDockItem.this.getIdentifier());
                }
            }
        });
    }

    @Override
    public void selectAndExecuteExpandCommand() {
        this.select();
        this.selectCommand.execute((Object)this.getIdentifier());
    }

    @Override
    public void select() {
        this.selected = true;
        this.itemButton.setType(ButtonType.INFO);
    }

    @Override
    public void deselect() {
        this.selected = false;
        this.itemButton.setType(ButtonType.DEFAULT);
    }

    static interface ViewBinder
    extends UiBinder<Widget, SouthDockItem> {
    }
}

