/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.items;

import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.user.client.ui.Composite;
import org.uberfire.client.docks.view.items.SideDockItem;
import org.uberfire.client.docks.view.items.SouthDockItem;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.ParameterizedCommand;

public abstract class AbstractDockItem
extends Composite {
    private final boolean selected;
    private final UberfireDock dock;

    AbstractDockItem(UberfireDock dock) {
        this.dock = dock;
        this.selected = false;
    }

    public static AbstractDockItem create(UberfireDock dock, ParameterizedCommand<String> selectCommand, ParameterizedCommand<String> deselectCommand) {
        if (dock.getDockPosition() == UberfireDockPosition.SOUTH) {
            return new SouthDockItem(dock, selectCommand, deselectCommand);
        }
        return new SideDockItem(dock, selectCommand, deselectCommand);
    }

    protected IconType getIcon() {
        try {
            return IconType.valueOf((String)this.dock.getIconType());
        }
        catch (Exception e) {
            return IconType.FOLDER_OPEN;
        }
    }

    public UberfireDock getDock() {
        return this.dock;
    }

    public String getIdentifier() {
        return this.dock.getIdentifier();
    }

    public String getLabel() {
        return this.dock.getLabel();
    }

    public abstract void selectAndExecuteExpandCommand();

    public abstract void select();

    public abstract void deselect();

    public void setupDnD() {
    }
}

