/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view;

import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.uberfire.client.docks.view.DocksBar;
import org.uberfire.client.docks.view.bars.DocksCollapsedBar;
import org.uberfire.client.docks.view.bars.DocksExpandedBar;
import org.uberfire.client.docks.view.menu.MenuBuilder;
import org.uberfire.client.mvp.AbstractWorkbenchScreenActivity;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.ActivityManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@Dependent
public class DocksBars {
    @Inject
    private PlaceManager placeManager;
    @Inject
    private ActivityManager activityManager;
    @Inject
    private MenuBuilder menuBuilder;
    private List<DocksBar> docks = new ArrayList<DocksBar>();
    DockLayoutPanel rootContainer;

    public void setup(DockLayoutPanel rootContainer) {
        this.rootContainer = rootContainer;
        for (UberfireDockPosition uberfireDockPosition : UberfireDockPosition.values()) {
            this.createDock(uberfireDockPosition);
        }
    }

    private void createDock(UberfireDockPosition position) {
        DocksBar docksBar = this.createDockBar(position);
        if (position == UberfireDockPosition.SOUTH) {
            this.rootContainer.addSouth((Widget)docksBar.getCollapsedBar(), docksBar.getCollapsedBarSize().doubleValue());
            this.rootContainer.addSouth((Widget)docksBar.getExpandedBar(), docksBar.getExpandedBarSize());
            this.rootContainer.addSouth((Widget)docksBar.getDockResizeBar(), docksBar.getDockResizeBarDefaultSize().doubleValue());
        } else if (position == UberfireDockPosition.EAST) {
            this.rootContainer.addEast((Widget)docksBar.getCollapsedBar(), docksBar.getCollapsedBarSize().doubleValue());
            this.rootContainer.addEast((Widget)docksBar.getExpandedBar(), docksBar.getExpandedBarSize());
            this.rootContainer.addEast((Widget)docksBar.getDockResizeBar(), docksBar.getDockResizeBarDefaultSize().doubleValue());
        } else if (position == UberfireDockPosition.WEST) {
            this.rootContainer.addWest((Widget)docksBar.getCollapsedBar(), docksBar.getCollapsedBarSize().doubleValue());
            this.rootContainer.addWest((Widget)docksBar.getExpandedBar(), docksBar.getExpandedBarSize());
            this.rootContainer.addWest((Widget)docksBar.getDockResizeBar(), docksBar.getDockResizeBarDefaultSize().doubleValue());
        }
        docksBar.configureResizeBar(this.createResizeCommand(docksBar));
        this.docks.add(docksBar);
    }

    private DocksBar createDockBar(UberfireDockPosition position) {
        DocksBar docksBar = new DocksBar(position);
        return docksBar;
    }

    public void addDock(UberfireDock dock) {
        DocksBar docksBar = this.getDockBar(dock);
        docksBar.addDock(dock, this.createDockSelectCommand(dock, docksBar), this.createDockDeselectCommand(dock, docksBar));
    }

    DocksBar getDockBar(UberfireDock dock) {
        for (DocksBar candidate : this.docks) {
            if (!candidate.getPosition().equals((Object)dock.getDockPosition())) continue;
            return candidate;
        }
        return null;
    }

    DocksBar getDockBar(UberfireDockPosition position) {
        for (DocksBar candidate : this.docks) {
            if (!candidate.getPosition().equals((Object)position)) continue;
            return candidate;
        }
        return null;
    }

    ParameterizedCommand<Double> createResizeCommand(final DocksBar docksBar) {
        return new ParameterizedCommand<Double>(){

            public void execute(Double size) {
                if (DocksBars.this.sizeIsValid(size, docksBar)) {
                    docksBar.setExpandedSize(size);
                    DocksBars.this.rootContainer.setWidgetSize((Widget)docksBar.getExpandedBar(), docksBar.getExpandedBarSize());
                    docksBar.getExpandedBar().setupDockContentSize();
                }
            }
        };
    }

    private boolean sizeIsValid(Double size, DocksBar docksBar) {
        int max = this.calculateMaxSize(docksBar);
        boolean minVisibleSize = true;
        return size > (double)minVisibleSize && size < (double)max;
    }

    private int calculateMaxSize(DocksBar docksBar) {
        UberfireDockPosition position = docksBar.getPosition();
        int collapsedSize = new Double(docksBar.getCollapsedBarSize()).intValue();
        int max = 0;
        max = position == UberfireDockPosition.SOUTH ? this.rootContainer.getOffsetHeight() - collapsedSize : this.rootContainer.getOffsetWidth() - 2 * collapsedSize;
        return max;
    }

    public void clearAndCollapseAllDocks() {
        this.collapseAll();
        this.clearAll();
    }

    private void clearAll() {
        for (DocksBar docksBar : this.getDocksBars()) {
            docksBar.clearAll();
        }
    }

    private void collapseAll() {
        for (DocksBar docksBar : this.getDocksBars()) {
            this.collapse(docksBar);
        }
    }

    private void collapse(DocksBar docksBar) {
        this.rootContainer.setWidgetHidden((Widget)docksBar.getCollapsedBar(), true);
        this.rootContainer.setWidgetHidden((Widget)docksBar.getExpandedBar(), true);
        this.rootContainer.setWidgetHidden((Widget)docksBar.getDockResizeBar(), true);
    }

    private void collapse(Widget bar) {
        this.rootContainer.setWidgetHidden(bar, true);
    }

    public void clearAndCollapse(UberfireDockPosition position) {
        DocksBar dockBar = this.getDockBar(position);
        dockBar.clearAll();
        this.collapse(dockBar);
    }

    private ParameterizedCommand<String> createDockSelectCommand(final UberfireDock targetDock, final DocksBar docksBar) {
        return new ParameterizedCommand<String>(){

            public void execute(String clickDockName) {
                if (targetDock != null) {
                    DocksBars.this.selectDock(targetDock, docksBar);
                    if (docksBar.isCollapsedBarInSingleMode()) {
                        DocksBars.this.collapse((Widget)docksBar.getCollapsedBar());
                    }
                }
            }
        };
    }

    private void selectDock(UberfireDock targetDock, DocksBar docksBar) {
        DocksCollapsedBar collapsedBar = docksBar.getCollapsedBar();
        DocksExpandedBar expandedBar = docksBar.getExpandedBar();
        PlaceRequest placeRequest = targetDock.getPlaceRequest();
        this.setupCollapsedBar(targetDock, collapsedBar);
        this.setupExpandedBar(targetDock, docksBar, expandedBar);
        this.expand((Widget)docksBar.getDockResizeBar());
        this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(placeRequest.getIdentifier()), (HasWidgets)expandedBar.targetPanel());
        this.lookUpContextMenus(placeRequest, docksBar.getExpandedBar());
    }

    private void lookUpContextMenus(PlaceRequest placeRequest, DocksExpandedBar expandedBar) {
        AbstractWorkbenchScreenActivity screen;
        Activity activity = this.placeManager.getActivity(placeRequest);
        if (activity instanceof AbstractWorkbenchScreenActivity && (screen = (AbstractWorkbenchScreenActivity)activity).getMenus() != null) {
            expandedBar.addMenus(screen.getMenus(), this.menuBuilder);
        }
    }

    private void setupCollapsedBar(UberfireDock targetDock, DocksCollapsedBar collapsedBar) {
        collapsedBar.setDockSelected(targetDock);
    }

    private void setupExpandedBar(UberfireDock targetDock, DocksBar docksBar, DocksExpandedBar expandedBar) {
        expandedBar.clear();
        this.expand((Widget)expandedBar);
        this.setupExpandedBarSize(targetDock, docksBar);
        expandedBar.setup(targetDock.getLabel(), this.createDockDeselectCommand(targetDock, docksBar));
    }

    private ParameterizedCommand<String> createDockDeselectCommand(final UberfireDock targetDock, final DocksBar docksBar) {
        return new ParameterizedCommand<String>(){

            public void execute(String clickDockName) {
                if (targetDock != null) {
                    DocksBars.this.deselectDock(docksBar);
                    if (docksBar.isCollapsedBarInSingleMode()) {
                        DocksBars.this.expand((Widget)docksBar.getCollapsedBar());
                    }
                }
            }
        };
    }

    private void deselectDock(DocksBar docksBar) {
        DocksCollapsedBar collapsedBar = docksBar.getCollapsedBar();
        DocksExpandedBar dockExpandedBar = docksBar.getExpandedBar();
        collapsedBar.deselectAllDocks();
        dockExpandedBar.clear();
        this.collapse(dockExpandedBar);
        this.collapse((Widget)docksBar.getDockResizeBar());
    }

    private void setupExpandedBarSize(UberfireDock targetDock, DocksBar docksBar) {
        DocksExpandedBar expandedBar = docksBar.getExpandedBar();
        if (this.thereIsASpecificSize(targetDock)) {
            expandedBar.setPanelSize(targetDock.getSize().intValue(), targetDock.getSize().intValue());
            this.rootContainer.setWidgetSize((Widget)expandedBar, targetDock.getSize().doubleValue());
        } else {
            int width = this.rootContainer.getElement().getClientWidth();
            Double height = new Double(docksBar.getExpandedBarSize());
            expandedBar.setPanelSize(width, height.intValue());
            this.rootContainer.setWidgetSize((Widget)expandedBar, docksBar.getExpandedBarSize());
        }
    }

    private boolean thereIsASpecificSize(UberfireDock targetDock) {
        return targetDock.getSize() != null;
    }

    public void expand(DocksBar docksBar) {
        if (docksBar.hasDocksItems()) {
            this.expand((Widget)docksBar.getCollapsedBar());
        }
    }

    public void expand(UberfireDockPosition position) {
        DocksBar dockBar = this.getDockBar(position);
        if (dockBar.hasDocksItems()) {
            this.expand((Widget)dockBar.getCollapsedBar());
        }
    }

    public boolean isReady() {
        return this.rootContainer != null;
    }

    private void expand(Widget dock) {
        this.rootContainer.setWidgetHidden(dock, false);
    }

    private void collapse(DocksExpandedBar dock) {
        dock.clear();
        this.rootContainer.setWidgetHidden((Widget)dock, true);
    }

    public List<DocksBar> getDocksBars() {
        return this.docks;
    }

    public void setIDEdock(Boolean IDEdock) {
        for (DocksBar dock : this.getDocksBars()) {
            dock.setupDnD();
        }
    }

    public void expand(UberfireDock dock) {
        DocksBar dockBar = this.getDockBar(dock);
        if (dockBar != null) {
            dockBar.expand(dock);
        }
    }
}

