/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.items;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.uberfire.client.docks.view.items.AbstractDockItem;
import org.uberfire.client.resources.WebAppResource;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.mvp.ParameterizedCommand;

public class SouthDockItem
extends AbstractDockItem {
    private final ParameterizedCommand<String> selectCommand;
    private final ParameterizedCommand<String> deselectCommand;
    private boolean selected;
    private static WebAppResource CSS = (WebAppResource)GWT.create(WebAppResource.class);
    @UiField
    Button itemButton;
    private ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);

    SouthDockItem(UberfireDock dock, ParameterizedCommand<String> selectCommand, ParameterizedCommand<String> deselectCommand) {
        super(dock);
        this.selectCommand = selectCommand;
        this.deselectCommand = deselectCommand;
        this.initWidget((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.createButton();
    }

    void createButton() {
        this.itemButton.setSize(ButtonSize.SMALL);
        this.itemButton.setType(ButtonType.LINK);
        this.configureText(this.itemButton, this.getDock().getLabel());
        this.configureIcon(this.itemButton, this.getDock().getImageIcon());
        this.itemButton.getElement().addClassName(CSS.CSS().southDockItem());
        this.itemButton.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!SouthDockItem.this.selected) {
                    SouthDockItem.this.select();
                    SouthDockItem.this.selectCommand.execute((Object)SouthDockItem.this.getIdentifier());
                } else {
                    SouthDockItem.this.deselect();
                    SouthDockItem.this.deselectCommand.execute((Object)SouthDockItem.this.getIdentifier());
                }
            }
        });
    }

    @Override
    public void selectAndExecuteExpandCommand() {
        this.select();
        this.selectCommand.execute((Object)this.getIdentifier());
    }

    @Override
    public void select() {
        this.selected = true;
        this.itemButton.setType(ButtonType.INFO);
        if (this.getDock().getImageIconFocused() != null) {
            this.itemButton.remove(0);
            this.configureImageIcon(this.itemButton, this.getDock().getImageIconFocused());
        }
    }

    @Override
    public void deselect() {
        this.selected = false;
        this.itemButton.setType(ButtonType.LINK);
        if (this.getDock().getImageIcon() != null) {
            this.itemButton.remove(0);
            this.configureImageIcon(this.itemButton, this.getDock().getImageIcon());
        }
    }

    static interface ViewBinder
    extends UiBinder<Widget, SouthDockItem> {
    }
}

