/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.items;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.IconPosition;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.html.Span;
import org.uberfire.client.docks.view.items.SideDockItem;
import org.uberfire.client.docks.view.items.SouthDockItem;
import org.uberfire.client.util.CSSLocatorsUtils;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.ParameterizedCommand;

public abstract class AbstractDockItem
extends Composite {
    private final boolean selected;
    private final UberfireDock dock;

    AbstractDockItem(UberfireDock dock) {
        this.dock = dock;
        this.selected = false;
    }

    public static AbstractDockItem create(UberfireDock dock, ParameterizedCommand<String> selectCommand, ParameterizedCommand<String> deselectCommand) {
        if (dock.getDockPosition() == UberfireDockPosition.SOUTH) {
            return new SouthDockItem(dock, selectCommand, deselectCommand);
        }
        return new SideDockItem(dock, selectCommand, deselectCommand);
    }

    void configureText(Button itemButton, String text) {
        Span itemButtonText = (Span)GWT.create(Span.class);
        itemButtonText.setText(text);
        itemButton.insert((Widget)itemButtonText, 0);
    }

    void configureIcon(Button itemButton, ImageResource imageResource) {
        if (this.getDock().getIconType() != null) {
            itemButton.setIcon(this.getIcon());
            itemButton.setIconFixedWidth(true);
            itemButton.setIconPosition(IconPosition.LEFT);
        } else {
            this.configureImageIcon(itemButton, imageResource);
        }
    }

    void configureImageIcon(Button itemButton, ImageResource imageResource) {
        if (imageResource != null) {
            Image imageIcon = new Image(imageResource);
            imageIcon.getElement().getStyle().setWidth(14.0, Style.Unit.PX);
            imageIcon.getElement().getStyle().setHeight(14.0, Style.Unit.PX);
            if (itemButton.getWidgetCount() > 1) {
                imageIcon.getElement().getStyle().setPosition(Style.Position.ABSOLUTE);
                imageIcon.getElement().getStyle().setTop(3.0, Style.Unit.PX);
                imageIcon.getElement().getStyle().setLeft(3.0, Style.Unit.PX);
                itemButton.getElement().getStyle().setPaddingLeft(20.0, Style.Unit.PX);
                itemButton.getElement().getStyle().setPosition(Style.Position.RELATIVE);
            }
            itemButton.insert((Widget)imageIcon, 0);
        }
    }

    private IconType getIcon() {
        if (this.dock.getIconType() == null) {
            return null;
        }
        try {
            return IconType.valueOf((String)this.dock.getIconType());
        }
        catch (Exception e) {
            return IconType.FOLDER_OPEN;
        }
    }

    public UberfireDock getDock() {
        return this.dock;
    }

    public String getIdentifier() {
        return this.dock.getIdentifier();
    }

    public String getLabel() {
        return this.dock.getLabel();
    }

    public abstract void selectAndExecuteExpandCommand();

    public abstract void select();

    public abstract void deselect();

    public void setupDnD() {
    }

    void setupCSSLocators(UberfireDock dock) {
        this.getElement().addClassName(CSSLocatorsUtils.buildLocator((String[])new String[]{"qe-docks-item", dock.getDockPosition().getShortName(), dock.getIdentifier()}));
    }
}

