/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.docks.view.DocksBar;
import org.uberfire.client.docks.view.bars.DocksCollapsedBar;
import org.uberfire.client.docks.view.bars.DocksExpandedBar;
import org.uberfire.client.docks.view.menu.MenuBuilder;
import org.uberfire.client.menu.AuthFilterMenuVisitor;
import org.uberfire.client.mvp.AbstractWorkbenchScreenActivity;
import org.uberfire.client.mvp.Activity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.client.workbench.docks.UberfireDocksContainer;
import org.uberfire.client.workbench.docks.UberfireDocksInteractionEvent;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuItemPerspective;
import org.uberfire.workbench.model.menu.MenuItemPlain;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.impl.BaseMenuVisitor;

@Dependent
public class DocksBars {
    private PlaceManager placeManager;
    private MenuBuilder menuBuilder;
    private Event<UberfireDocksInteractionEvent> dockInteractionEvent;
    private UberfireDocksContainer uberfireDocksContainer;
    private List<DocksBar> docks = new ArrayList<DocksBar>();
    private AuthorizationManager authorizationManager;
    private User identity;

    @Inject
    public DocksBars(PlaceManager placeManager, MenuBuilder menuBuilder, Event<UberfireDocksInteractionEvent> dockInteractionEvent, UberfireDocksContainer uberfireDocksContainer, AuthorizationManager authorizationManager, User identity) {
        this.placeManager = placeManager;
        this.menuBuilder = menuBuilder;
        this.dockInteractionEvent = dockInteractionEvent;
        this.uberfireDocksContainer = uberfireDocksContainer;
        this.authorizationManager = authorizationManager;
        this.identity = identity;
    }

    public void setup() {
        for (UberfireDockPosition uberfireDockPosition : UberfireDockPosition.values()) {
            this.createDock(uberfireDockPosition);
        }
    }

    private void createDock(UberfireDockPosition position) {
        DocksBar docksBar = this.createDockBar(position);
        this.uberfireDocksContainer.add(position, (Widget)docksBar.getCollapsedBar(), docksBar.getCollapsedBarSize());
        this.uberfireDocksContainer.add(position, (Widget)docksBar.getExpandedBar(), Double.valueOf(docksBar.getExpandedBarSize()));
        this.uberfireDocksContainer.add(position, (Widget)docksBar.getDockResizeBar(), docksBar.getDockResizeBarDefaultSize());
        docksBar.configureResizeBar(this.createResizeCommand(docksBar));
        this.docks.add(docksBar);
    }

    private DocksBar createDockBar(UberfireDockPosition position) {
        DocksBar docksBar = new DocksBar(position);
        return docksBar;
    }

    public void addDock(UberfireDock dock) {
        DocksBar docksBar = this.getDockBar(dock);
        docksBar.addDock(dock, this.createDockOpenCommand(dock, docksBar), this.createDockCloseCommand(dock, docksBar));
    }

    DocksBar getDockBar(UberfireDock dock) {
        for (DocksBar candidate : this.docks) {
            if (!candidate.getPosition().equals((Object)dock.getDockPosition())) continue;
            return candidate;
        }
        return null;
    }

    DocksBar getDockBar(UberfireDockPosition position) {
        for (DocksBar candidate : this.docks) {
            if (!candidate.getPosition().equals((Object)position)) continue;
            return candidate;
        }
        return null;
    }

    ParameterizedCommand<Double> createResizeCommand(final DocksBar docksBar) {
        return new ParameterizedCommand<Double>(){

            public void execute(Double size) {
                if (DocksBars.this.sizeIsValid(size, docksBar)) {
                    docksBar.setExpandedSize(size);
                    DocksBars.this.uberfireDocksContainer.setWidgetSize((Widget)docksBar.getExpandedBar(), docksBar.getExpandedBarSize());
                    docksBar.getExpandedBar().setupDockContentSize();
                    DocksBars.this.uberfireDocksContainer.resize();
                    DocksBars.this.dockInteractionEvent.fire((Object)new UberfireDocksInteractionEvent(docksBar.getPosition(), UberfireDocksInteractionEvent.InteractionType.RESIZED));
                }
            }
        };
    }

    boolean sizeIsValid(Double size, DocksBar docksBar) {
        int max = this.calculateMaxSize(docksBar);
        boolean minVisibleSize = true;
        return size > (double)minVisibleSize && size < (double)max;
    }

    private int calculateMaxSize(DocksBar docksBar) {
        UberfireDockPosition position = docksBar.getPosition();
        int collapsedSize = new Double(docksBar.getCollapsedBarSize()).intValue();
        int max = 0;
        max = position == UberfireDockPosition.SOUTH ? this.uberfireDocksContainer.getOffsetHeight() - collapsedSize : this.uberfireDocksContainer.getOffsetWidth() - 2 * collapsedSize;
        return max;
    }

    public void clearAndCollapseDocks(UberfireDockPosition position) {
        this.collapsePosition(position);
        this.clearPosition(position);
    }

    public void clearAndHideAllDocks() {
        this.clearAndCollapseDocks(null);
    }

    private void clearPosition(UberfireDockPosition position) {
        this.getDocksBars().forEach(docksBar -> {
            if (position == null || docksBar.getPosition().equals((Object)position)) {
                docksBar.clearAll();
            }
        });
    }

    private void collapsePosition(UberfireDockPosition position) {
        this.getDocksBars().forEach(docksBar -> {
            if (position == null || docksBar.getPosition().equals((Object)position)) {
                this.hide((DocksBar)docksBar);
            }
        });
    }

    private void hide(DocksBar docksBar) {
        this.uberfireDocksContainer.hide((Widget)docksBar.getCollapsedBar());
        this.uberfireDocksContainer.hide((Widget)docksBar.getExpandedBar());
        this.uberfireDocksContainer.hide((Widget)docksBar.getDockResizeBar());
    }

    void hide(Widget bar) {
        this.uberfireDocksContainer.hide(bar);
    }

    public void clearAndHide(UberfireDockPosition position) {
        DocksBar dockBar = this.getDockBar(position);
        dockBar.clearAll();
        this.hide(dockBar);
        this.resizeDeferred();
    }

    void resizeDeferred() {
        Scheduler.get().scheduleDeferred(() -> this.uberfireDocksContainer.resize());
    }

    ParameterizedCommand<String> createDockOpenCommand(UberfireDock targetDock, DocksBar docksBar) {
        return clickDockName -> {
            if (targetDock != null) {
                this.openDock(targetDock, docksBar);
                if (docksBar.isCollapsedBarInSingleMode()) {
                    this.hide((Widget)docksBar.getCollapsedBar());
                }
                this.uberfireDocksContainer.resize();
                this.dockInteractionEvent.fire((Object)new UberfireDocksInteractionEvent(targetDock, UberfireDocksInteractionEvent.InteractionType.OPENED));
            }
        };
    }

    void openDock(UberfireDock targetDock, DocksBar docksBar) {
        docksBar.setOpenDock(targetDock);
        DocksCollapsedBar collapsedBar = docksBar.getCollapsedBar();
        DocksExpandedBar expandedBar = docksBar.getExpandedBar();
        PlaceRequest placeRequest = targetDock.getPlaceRequest();
        this.setupCollapsedBar(targetDock, collapsedBar);
        this.setupExpandedBar(targetDock, docksBar, expandedBar);
        this.show((Widget)docksBar.getDockResizeBar());
        this.goToPlace(expandedBar, placeRequest);
        this.lookUpContextMenus(placeRequest, docksBar.getExpandedBar());
    }

    private void goToPlace(DocksExpandedBar expandedBar, PlaceRequest placeRequest) {
        placeRequest.setUpdateLocationBar(false);
        this.placeManager.goTo(placeRequest, (HasWidgets)expandedBar.targetPanel());
    }

    private void lookUpContextMenus(PlaceRequest placeRequest, final DocksExpandedBar expandedBar) {
        AbstractWorkbenchScreenActivity screen;
        Activity activity = this.placeManager.getActivity(placeRequest);
        if (activity instanceof AbstractWorkbenchScreenActivity && (screen = (AbstractWorkbenchScreenActivity)activity).getMenus() != null) {
            screen.getMenus().accept((MenuVisitor)new AuthFilterMenuVisitor(this.authorizationManager, this.identity, (MenuVisitor)new BaseMenuVisitor(){

                public void visit(MenuItemPlain menuItemPlain) {
                    expandedBar.addContextMenuItem(DocksBars.this.menuBuilder.makeItem((MenuItem)menuItemPlain, true));
                }

                public void visit(MenuItemCommand menuItemCommand) {
                    expandedBar.addContextMenuItem(DocksBars.this.menuBuilder.makeItem((MenuItem)menuItemCommand, true));
                }

                public void visit(MenuItemPerspective menuItemPerspective) {
                    expandedBar.addContextMenuItem(DocksBars.this.menuBuilder.makeItem((MenuItem)menuItemPerspective, true));
                }

                public void visit(MenuCustom<?> menuCustom) {
                    expandedBar.addContextMenuItem(DocksBars.this.menuBuilder.makeItem((MenuItem)menuCustom, true));
                }
            }));
        }
    }

    private void setupCollapsedBar(UberfireDock targetDock, DocksCollapsedBar collapsedBar) {
        collapsedBar.setDockClosed(targetDock);
    }

    private void setupExpandedBar(UberfireDock targetDock, DocksBar docksBar, DocksExpandedBar expandedBar) {
        expandedBar.clear();
        this.show((Widget)expandedBar);
        this.setupExpandedBarSize(targetDock, docksBar);
        expandedBar.setup(targetDock.getLabel(), this.createDockCloseCommand(targetDock, docksBar));
    }

    public void open(UberfireDock dock) {
        DocksBar dockBar = this.getDockBar(dock);
        if (dockBar != null) {
            dockBar.open(dock);
        }
    }

    public void close(UberfireDock dock) {
        DocksBar dockBar = this.getDockBar(dock);
        if (dockBar != null && this.isOpenWith(dock, dockBar)) {
            this.closeDockProcess(dock, dockBar);
        }
    }

    public void toggle(UberfireDock dock) {
        DocksBar dockBar = this.getDockBar(dock);
        if (dockBar != null) {
            if (this.isOpenWith(dock, dockBar)) {
                this.closeDockProcess(dock, dockBar);
            } else {
                dockBar.open(dock);
            }
        }
    }

    boolean isOpenWith(UberfireDock dock, DocksBar dockBar) {
        return dockBar.isOpenWith(dock.getPlaceRequest());
    }

    ParameterizedCommand<String> createDockCloseCommand(UberfireDock targetDock, DocksBar docksBar) {
        return clickedDockName -> this.closeDockProcess(targetDock, docksBar);
    }

    void closeDockProcess(UberfireDock targetDock, DocksBar docksBar) {
        if (targetDock != null) {
            this.closeDock(targetDock, docksBar);
            if (docksBar.isCollapsedBarInSingleMode()) {
                this.show((Widget)docksBar.getCollapsedBar());
            }
            this.uberfireDocksContainer.resize();
            this.dockInteractionEvent.fire((Object)new UberfireDocksInteractionEvent(targetDock, UberfireDocksInteractionEvent.InteractionType.CLOSED));
        }
    }

    void closeDock(UberfireDock dock, DocksBar docksBar) {
        DocksCollapsedBar collapsedBar = docksBar.getCollapsedBar();
        DocksExpandedBar dockExpandedBar = docksBar.getExpandedBar();
        docksBar.clearExpandedDock(dock);
        collapsedBar.closeAllDocks();
        dockExpandedBar.clear();
        this.hide(dockExpandedBar);
        this.hide((Widget)docksBar.getDockResizeBar());
    }

    private void setupExpandedBarSize(UberfireDock targetDock, DocksBar docksBar) {
        DocksExpandedBar expandedBar = docksBar.getExpandedBar();
        if (this.thereIsASpecificSize(targetDock)) {
            expandedBar.setPanelSize(targetDock.getSize().intValue(), targetDock.getSize().intValue());
            this.uberfireDocksContainer.setWidgetSize((Widget)expandedBar, targetDock.getSize().doubleValue());
        } else {
            int width = this.uberfireDocksContainer.getClientWidth();
            Double height = new Double(docksBar.getExpandedBarSize());
            expandedBar.setPanelSize(width, height.intValue());
            this.uberfireDocksContainer.setWidgetSize((Widget)expandedBar, docksBar.getExpandedBarSize());
        }
    }

    private boolean thereIsASpecificSize(UberfireDock targetDock) {
        return targetDock.getSize() != null;
    }

    public void show(DocksBar docksBar) {
        if (docksBar.hasDocksItems()) {
            this.show((Widget)docksBar.getCollapsedBar());
        }
    }

    public void show(UberfireDockPosition position) {
        DocksBar dockBar = this.getDockBar(position);
        if (dockBar.hasDocksItems()) {
            this.show((Widget)dockBar.getCollapsedBar());
        }
    }

    public boolean isReady(UberfireDockPosition dockPosition) {
        return this.uberfireDocksContainer.isReady() && this.docksBarIsReady(dockPosition);
    }

    private boolean docksBarIsReady(UberfireDockPosition dockPosition) {
        DocksBar dockBar = this.getDockBar(dockPosition);
        return dockBar != null;
    }

    void show(Widget widget) {
        this.uberfireDocksContainer.show(widget);
    }

    private void hide(DocksExpandedBar dock) {
        dock.clear();
        this.uberfireDocksContainer.hide((Widget)dock);
    }

    public List<DocksBar> getDocksBars() {
        return this.docks;
    }
}

