/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.docks.view.bars;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.HeadingSize;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.uberfire.client.resources.WebAppResource;
import org.uberfire.client.util.CSSLocatorsUtils;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.ParameterizedCommand;

public class DocksExpandedBar
extends Composite
implements ProvidesResize,
RequiresResize {
    private static WebAppResource CSS = (WebAppResource)GWT.create(WebAppResource.class);
    @UiField
    FlowPanel titlePanel;
    @UiField
    FlowPanel targetPanel;
    Button collapse;
    Heading title;
    private UberfireDockPosition position;
    private ViewBinder uiBinder = (ViewBinder)GWT.create(ViewBinder.class);

    public DocksExpandedBar(UberfireDockPosition position) {
        this.initWidget((Widget)this.uiBinder.createAndBindUi((Object)this));
        this.position = position;
        this.setupCSSLocators(position);
    }

    private void setupCSSLocators(UberfireDockPosition position) {
        this.getElement().addClassName(CSSLocatorsUtils.buildLocator((String[])new String[]{"qe-docks-bar-expanded", position.getShortName()}));
    }

    public void onResize() {
        this.resizeTargetPanel();
    }

    public void setup(String titleString, ParameterizedCommand<String> closeCommand) {
        this.clear();
        this.createTitle(titleString);
        this.createButtons(titleString, closeCommand);
        this.setupComponents();
        this.setupCSS();
    }

    private void setupComponents() {
        if (this.position == UberfireDockPosition.SOUTH) {
            this.titlePanel.add((Widget)this.collapse);
            this.titlePanel.add((Widget)this.title);
        } else if (this.position == UberfireDockPosition.WEST) {
            this.titlePanel.add((Widget)this.title);
            this.titlePanel.add((Widget)this.collapse);
        } else if (this.position == UberfireDockPosition.EAST) {
            this.titlePanel.add((Widget)this.collapse);
            this.titlePanel.add((Widget)this.title);
        }
    }

    public void addContextMenuItem(Widget menuItem) {
        if (menuItem != null) {
            ButtonGroup bg = new ButtonGroup();
            bg.addStyleName(CSS.CSS().dockExpandedContentButton());
            bg.add(menuItem);
            this.titlePanel.add((Widget)bg);
        }
    }

    private void createTitle(String titleString) {
        this.title = new Heading(HeadingSize.H3, titleString);
    }

    private void createButtons(String identifier, ParameterizedCommand<String> closeCommand) {
        this.collapse = (Button)GWT.create(Button.class);
        this.collapse.setSize(ButtonSize.SMALL);
        this.collapse.addClickHandler(even -> closeCommand.execute((Object)identifier));
    }

    private void setupCSS() {
        if (this.position == UberfireDockPosition.SOUTH) {
            this.titlePanel.addStyleName(CSS.CSS().dockExpandedContentPanelSouth());
            this.title.addStyleName(CSS.CSS().dockExpandedLabelSouth());
            this.collapse.addStyleName(CSS.CSS().dockExpandedButtonSouth());
            this.collapse.setIcon(IconType.CHEVRON_DOWN);
        } else if (this.position == UberfireDockPosition.WEST) {
            this.title.addStyleName(CSS.CSS().dockExpandedLabelWest());
            this.collapse.addStyleName(CSS.CSS().dockExpandedButtonWest());
            this.collapse.setIcon(IconType.CHEVRON_LEFT);
        } else if (this.position == UberfireDockPosition.EAST) {
            this.title.addStyleName(CSS.CSS().dockExpandedLabelEast());
            this.collapse.addStyleName(CSS.CSS().dockExpandedButtonEast());
            this.collapse.setIcon(IconType.CHEVRON_RIGHT);
        }
        this.setupDockContentSize();
    }

    public void setupDockContentSize() {
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                DocksExpandedBar.this.resizeTargetPanel();
            }
        });
    }

    protected void resizeTargetPanel() {
        int width = this.calculateDockWidth();
        int height = this.calculateDockHeight();
        this.setPanelSize(width, height);
    }

    int calculateDockWidth() {
        return this.getOffsetWidth();
    }

    int calculateDockHeight() {
        return this.getOffsetHeight() - this.titlePanel.getOffsetHeight();
    }

    public void setPanelSize(int width, int height) {
        if (this.isValidHeightWidth(width, height)) {
            this.targetPanel.setPixelSize(width, height);
        }
    }

    private boolean isValidHeightWidth(int height, int width) {
        return height > 0 && width > 0;
    }

    public FlowPanel targetPanel() {
        return this.targetPanel;
    }

    public void clear() {
        this.targetPanel.clear();
        this.titlePanel.clear();
    }

    public UberfireDockPosition getPosition() {
        return this.position;
    }

    static interface ViewBinder
    extends UiBinder<Widget, DocksExpandedBar> {
    }
}

