/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.service.backend.editor;

import java.io.IOException;
import java.util.Collection;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.jboss.errai.security.shared.api.identity.UserImpl;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.ssh.service.backend.editor.SSHKeyEditorServiceImpl;
import org.uberfire.ssh.service.backend.keystore.SSHKeyStoreService;
import org.uberfire.ssh.service.backend.test.AbstractSSHKeyStoreServiceImplTest;
import org.uberfire.ssh.service.backend.test.SSHKeyStoreTestUtils;
import org.uberfire.ssh.service.shared.editor.PortableSSHPublicKey;

@RunWith(value=MockitoJUnitRunner.class)
public class SSHKeyEditorServiceImplTest
extends AbstractSSHKeyStoreServiceImplTest {
    private String userName;
    @Mock
    private SessionInfo sessionInfo;
    private SSHKeyEditorServiceImpl service;

    @BeforeClass
    public static void init() {
        SSHKeyStoreTestUtils.setupUserDir();
    }

    @Override
    @Before
    public void initTest() {
        super.initTest();
        this.initService();
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenAnswer(invocationOnMock -> new UserImpl(this.userName));
        this.service = new SSHKeyEditorServiceImpl(this.sessionInfo, (SSHKeyStoreService)this.keyStoreService);
    }

    @Test
    public void testKatyUser() {
        this.userName = "katy";
        ((IterableAssert)Assertions.assertThat((Iterable)this.service.getUserKeys()).isNotNull()).hasSize(2);
    }

    @Test
    public void testJohnUser() {
        this.userName = "john";
        ((IterableAssert)Assertions.assertThat((Iterable)this.service.getUserKeys()).isNotNull()).hasSize(1);
    }

    @Test
    public void testAdmin() throws IOException {
        this.userName = "admin";
        ((IterableAssert)Assertions.assertThat((Iterable)this.service.getUserKeys()).isNotNull()).hasSize(0);
        String keyContent = SSHKeyStoreTestUtils.readSampleSSHKey();
        this.service.addKey("key name 1", keyContent);
        Collection keys = this.service.getUserKeys();
        ((IterableAssert)Assertions.assertThat((Iterable)keys).isNotNull()).hasSize(1);
        PortableSSHPublicKey key = (PortableSSHPublicKey)keys.iterator().next();
        this.service.deleteKey(key);
        ((IterableAssert)Assertions.assertThat((Iterable)this.service.getUserKeys()).isNotNull()).hasSize(0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.service.addKey("key name 1", "wrong content")).isNotNull()).isInstanceOf(RuntimeException.class);
    }

    @AfterClass
    public static void clean() {
        SSHKeyStoreTestUtils.clearAdminKeysFolder();
        SSHKeyStoreTestUtils.resetUserDir();
    }
}

