/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.service.backend.keystore.impl.storage;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import org.uberfire.ssh.service.backend.keystore.SSHKeyStore;
import org.uberfire.ssh.service.backend.keystore.impl.storage.UserSSHKeyStore;
import org.uberfire.ssh.service.backend.keystore.model.SSHPublicKey;

@Dependent
@Default
public class DefaultSSHKeyStore
implements SSHKeyStore {
    public static final String USER_DIR = "user.dir";
    public static final String SSH_KEYS_PATH_PARAM = "appformer.ssh.keys.storage.folder";
    public static final String SSH_KEYS_FOLDER = ".security/pkeys";
    private final Map<String, UserSSHKeyStore> userKeyStores = new HashMap<String, UserSSHKeyStore>();
    private final Path sshStoragePath;

    public DefaultSSHKeyStore() {
        String customStorage = System.getProperty(SSH_KEYS_PATH_PARAM, null);
        this.sshStoragePath = customStorage != null ? Paths.get(customStorage, new String[0]) : Paths.get(System.getProperty(USER_DIR), new String[0]).resolve(SSH_KEYS_FOLDER);
    }

    @PostConstruct
    public void init() {
        File keysFolder = this.sshStoragePath.toFile();
        if (keysFolder.exists()) {
            Stream.of(keysFolder.list()).map(this::getUserKeyStore).forEach(userSSHKeyStore -> this.userKeyStores.put(userSSHKeyStore.getUser(), (UserSSHKeyStore)userSSHKeyStore));
        } else {
            keysFolder.mkdirs();
        }
    }

    public UserSSHKeyStore getUserKeyStore(String userName) {
        UserSSHKeyStore userStore = this.userKeyStores.get(userName);
        if (userStore == null) {
            userStore = new UserSSHKeyStore(userName, this.sshStoragePath);
            this.userKeyStores.put(userName, userStore);
        }
        return userStore;
    }

    public void addUserKey(String userName, SSHPublicKey key) {
        this.getUserKeyStore(userName).addUserKey(key);
    }

    public void removeUserKey(String userName, SSHPublicKey key) {
        this.getUserKeyStore(userName).removeUserKey(key);
    }

    public void updateUserKey(String userName, SSHPublicKey key) {
        this.addUserKey(userName, key);
    }

    public Collection<SSHPublicKey> getUserKeys(String userName) {
        return this.getUserKeyStore(userName).getUserKeys();
    }
}

