/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.client.editor.component.keys.key;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;
import org.uberfire.ssh.client.editor.component.keys.key.SSHKeyEditor;
import org.uberfire.ssh.client.editor.component.keys.key.SSHKeyEditorView;
import org.uberfire.ssh.service.shared.editor.PortableSSHPublicKey;

@RunWith(value=MockitoJUnitRunner.class)
public class SSHKeyEditorTest {
    @Mock
    private SSHKeyEditorView view;
    @Mock
    private PortableSSHPublicKey key;
    @Mock
    private Command onDelete;
    private SSHKeyEditor editor;

    @Before
    public void init() {
        this.editor = new SSHKeyEditor(this.view);
    }

    @Test
    public void testFunctionality() {
        ((SSHKeyEditorView)Mockito.verify((Object)this.view)).init((Object)this.editor);
        this.editor.getElement();
        ((SSHKeyEditorView)Mockito.verify((Object)this.view)).getElement();
        this.editor.render(this.key, this.onDelete);
        ((SSHKeyEditorView)Mockito.verify((Object)this.view)).clear();
        ((SSHKeyEditorView)Mockito.verify((Object)this.view)).render(this.key);
        this.editor.notifyDelete();
        ((Command)Mockito.verify((Object)this.onDelete)).execute();
        this.editor.clear();
        ((SSHKeyEditorView)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)2))).clear();
    }

    @Test
    public void testInitFailures() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.editor.render(null, this.onDelete)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'key' should be not null!");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.editor.render(this.key, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Parameter named 'onDelete' should be not null!");
    }
}

