/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.client.editor.component.keys;

import elemental2.dom.HTMLElement;
import java.util.Collection;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.ssh.client.editor.component.keys.SSHKeysDisplayerView;
import org.uberfire.ssh.client.editor.component.keys.key.SSHKeyEditor;
import org.uberfire.ssh.service.shared.editor.PortableSSHPublicKey;

@Dependent
public class SSHKeysDisplayer
implements SSHKeysDisplayerView.Presenter,
IsElement {
    private final SSHKeysDisplayerView view;
    private final ManagedInstance<SSHKeyEditor> editors;
    private Command addCommand;
    private ParameterizedCommand<PortableSSHPublicKey> deleteCommand;

    @Inject
    public SSHKeysDisplayer(SSHKeysDisplayerView view, ManagedInstance<SSHKeyEditor> editors) {
        this.view = view;
        this.editors = editors;
        view.init(this);
    }

    public void init(Command addCommand, ParameterizedCommand<PortableSSHPublicKey> deleteCommand) {
        PortablePreconditions.checkNotNull((String)"addCommand", (Object)addCommand);
        PortablePreconditions.checkNotNull((String)"deleteCommand", deleteCommand);
        this.addCommand = addCommand;
        this.deleteCommand = deleteCommand;
    }

    public void render(Collection<PortableSSHPublicKey> keys) {
        this.clear();
        keys.forEach(this::addKeyEditor);
    }

    private void addKeyEditor(PortableSSHPublicKey key) {
        SSHKeyEditor editor = (SSHKeyEditor)this.editors.get();
        editor.render(key, () -> this.onDelete(key));
        this.view.add(editor);
    }

    protected void onDelete(PortableSSHPublicKey key) {
        this.deleteCommand.execute((Object)key);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @PreDestroy
    public void clear() {
        this.view.clear();
        this.editors.destroyAll();
    }

    @Override
    public void notifyAdd() {
        if (this.addCommand != null) {
            this.addCommand.execute();
        }
    }
}

