/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.client.editor.component;

import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.elemental2.IsElement;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.ssh.client.editor.component.SSHKeysEditorView;
import org.uberfire.ssh.client.editor.component.creation.NewSSHKeyModal;
import org.uberfire.ssh.client.editor.component.creation.NewSSHKeyModalHandler;
import org.uberfire.ssh.client.editor.component.empty.SSHKeysEditorEmptyStateDisplayer;
import org.uberfire.ssh.client.editor.component.keys.SSHKeysDisplayer;
import org.uberfire.ssh.service.shared.editor.PortableSSHPublicKey;
import org.uberfire.ssh.service.shared.editor.SSHKeyEditorService;

@Dependent
public class SSHKeysEditor
implements SSHKeysEditorView.Presenter,
NewSSHKeyModalHandler,
IsElement {
    private final SSHKeysEditorView view;
    private final SSHKeysDisplayer keysDisplayer;
    private final SSHKeysEditorEmptyStateDisplayer emptyStateDisplayer;
    private final NewSSHKeyModal newSSHKeyModal;
    private final Caller<SSHKeyEditorService> serviceCaller;
    private List<PortableSSHPublicKey> currentKeys = new ArrayList<PortableSSHPublicKey>();

    @Inject
    public SSHKeysEditor(SSHKeysEditorView view, SSHKeysDisplayer keysDisplayer, SSHKeysEditorEmptyStateDisplayer emptyStateDisplayer, NewSSHKeyModal newSSHKeyModal, Caller<SSHKeyEditorService> serviceCaller) {
        this.view = view;
        this.keysDisplayer = keysDisplayer;
        this.emptyStateDisplayer = emptyStateDisplayer;
        this.newSSHKeyModal = newSSHKeyModal;
        this.serviceCaller = serviceCaller;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.keysDisplayer.init(this::showNewKeyModal, (ParameterizedCommand<PortableSSHPublicKey>)((ParameterizedCommand)this::delete));
        this.emptyStateDisplayer.init(this::showNewKeyModal);
        this.newSSHKeyModal.init(this);
    }

    public void load() {
        ((SSHKeyEditorService)this.serviceCaller.call(this::loadKeys)).getUserKeys();
    }

    private void loadKeys(Collection<PortableSSHPublicKey> keys) {
        this.clear();
        if (keys.isEmpty()) {
            this.view.show(this.emptyStateDisplayer.getElement());
        } else {
            this.currentKeys.addAll(keys);
            this.keysDisplayer.render(keys);
            this.view.show(this.keysDisplayer.getElement());
        }
    }

    protected void delete(PortableSSHPublicKey key) {
        ((SSHKeyEditorService)this.serviceCaller.call(response -> this.load())).deleteKey(key);
    }

    protected void showNewKeyModal() {
        this.newSSHKeyModal.show();
    }

    @Override
    public boolean existsKeyName(String name) {
        return this.findKey(key -> key.getName().equals(name));
    }

    @Override
    public boolean existsKey(String keyContent) {
        return this.findKey(key -> key.getKeyContent().equals(keyContent));
    }

    private boolean findKey(Predicate<PortableSSHPublicKey> predicate) {
        return this.currentKeys.stream().anyMatch(predicate);
    }

    @Override
    public void onAddKey() {
        this.newSSHKeyModal.hide();
        this.load();
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @PreDestroy
    public void clear() {
        this.view.clear();
        this.currentKeys.clear();
    }
}

