/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.client.editor.component.creation;

import java.util.Optional;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.uberfire.ssh.client.editor.component.creation.NewSSHKeyModalHandler;
import org.uberfire.ssh.client.editor.component.creation.NewSSHKeyModalView;
import org.uberfire.ssh.service.shared.editor.SSHKeyEditorService;

@Dependent
public class NewSSHKeyModal
implements NewSSHKeyModalView.Presenter {
    private static final String[] SUPPORTED_FORMATS = new String[]{"ssh-rsa", "ssh-dss", "ecdsa-sha2-nistp256", "ecdsa-sha2-nistp384", "ecdsa-sha2-nistp521"};
    private final NewSSHKeyModalView view;
    private final Caller<SSHKeyEditorService> serviceCaller;
    private final TranslationService translationService;
    private NewSSHKeyModalHandler handler;

    @Inject
    public NewSSHKeyModal(NewSSHKeyModalView view, Caller<SSHKeyEditorService> serviceCaller, TranslationService translationService) {
        this.view = view;
        this.serviceCaller = serviceCaller;
        this.translationService = translationService;
        view.init(this);
    }

    public void init(NewSSHKeyModalHandler handler) {
        PortablePreconditions.checkNotNull((String)"handler", (Object)handler);
        this.handler = handler;
    }

    public void show() {
        this.view.show();
    }

    @Override
    public void notifyCancel() {
        this.view.hide();
    }

    @Override
    public void notifyAdd(String name, String key) {
        this.view.resetValidation();
        boolean nameValid = this.validateName(name);
        boolean keyValid = this.validateKey(key);
        if (nameValid && keyValid) {
            ((SSHKeyEditorService)this.serviceCaller.call(response -> this.handler.onAddKey(), (message, throwable) -> {
                this.view.setKeyValidationError(this.translationService.getTranslation("Validation.keyFormatError"));
                return false;
            })).addKey(name, key);
        }
    }

    private boolean validateKey(String keyContent) {
        Optional<String> optional = Optional.ofNullable(this.validateEmptyString(keyContent, "NewSSHKeyModalViewImpl.key"));
        if (optional.isPresent()) {
            this.view.setKeyValidationError(optional.get());
            return false;
        }
        Optional<String> encoding = Stream.of(SUPPORTED_FORMATS).filter(keyContent::startsWith).findAny();
        if (!encoding.isPresent()) {
            this.view.setKeyValidationError(this.translationService.getTranslation("Validation.keyFormatError"));
            return false;
        }
        if (this.handler.existsKey(keyContent)) {
            this.view.setKeyValidationError(this.translationService.getTranslation("Validation.keyAlreadyExists"));
            return false;
        }
        return true;
    }

    private boolean validateName(String name) {
        Optional<String> optional = Optional.ofNullable(this.validateEmptyString(name, "NewSSHKeyModalViewImpl.name"));
        if (optional.isPresent()) {
            this.view.setNameValidationError(optional.get());
            return false;
        }
        if (this.handler.existsKeyName(name)) {
            this.view.setNameValidationError(this.translationService.format("Validation.keyNameAlreadyExists", new Object[]{name}));
            return false;
        }
        return true;
    }

    private String validateEmptyString(String str, String fieldNameKey) {
        if (str == null || str.isEmpty()) {
            String fieldName = this.translationService.getTranslation(fieldNameKey);
            return this.translationService.format("Validation.cannotBeEmpty", new Object[]{fieldName});
        }
        return null;
    }

    public void hide() {
        this.view.hide();
    }
}

