/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.client.editor.component.keys.key;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import elemental2.dom.HTMLButtonElement;
import elemental2.dom.HTMLLabelElement;
import java.util.Date;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.ModalSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.widgets.common.client.common.popups.YesNoCancelPopup;
import org.uberfire.ssh.client.editor.component.keys.key.SSHKeyEditorView;
import org.uberfire.ssh.service.shared.editor.PortableSSHPublicKey;

@Templated
public class SSHKeyEditorViewImpl
implements SSHKeyEditorView,
IsElement {
    private static final DateTimeFormat format = DateTimeFormat.getFormat((String)"MMMM dd, yyyy");
    @Inject
    @DataField
    private HTMLLabelElement name;
    @Inject
    @DataField
    private HTMLLabelElement added;
    @Inject
    @DataField
    private HTMLLabelElement lastUsed;
    @Inject
    @DataField
    private HTMLButtonElement delete;
    @Inject
    private TranslationService translationService;
    private SSHKeyEditorView.Presenter presenter;

    @Override
    public void clear() {
        this.name.textContent = "";
        this.added.textContent = "";
        this.lastUsed.textContent = "";
    }

    @Override
    public void render(PortableSSHPublicKey key) {
        this.name.textContent = key.getName();
        this.added.textContent = this.format(key.getCreationDate(), "SSHKeyEditorViewImpl.addedOn");
        this.lastUsed.textContent = this.format(key.getLastTimeUsed(), "SSHKeyEditorViewImpl.lastUsed");
    }

    private String format(Date date, String key) {
        if (date == null) {
            return "";
        }
        return this.translationService.format(key, new Object[]{format.format(date)});
    }

    public void init(SSHKeyEditorView.Presenter presenter) {
        this.presenter = presenter;
    }

    @EventHandler(value={"delete"})
    public void onDelete(ClickEvent event) {
        YesNoCancelPopup popupup = YesNoCancelPopup.newYesNoCancelPopup((String)this.translationService.getTranslation("SSHKeyEditorViewImpl.sshKeysDelete"), (String)this.translationService.getTranslation("SSHKeyEditorViewImpl.sshKeysDeleteMessage"), null, null, null, () -> {}, (String)this.translationService.getTranslation("SSHKeyEditorViewImpl.sshKeysCancel"), (ButtonType)ButtonType.DEFAULT, () -> this.presenter.notifyDelete(), (String)this.translationService.getTranslation("SSHKeyEditorViewImpl.sshKeysDelete"), (ButtonType)ButtonType.DANGER);
        popupup.setSize(ModalSize.SMALL);
        popupup.clearScrollHeight();
        popupup.show();
    }
}

