/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ssh.client.editor.component.keys;

import java.util.ArrayList;
import java.util.List;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.ssh.client.editor.component.keys.SSHKeysDisplayer;
import org.uberfire.ssh.client.editor.component.keys.SSHKeysDisplayerView;
import org.uberfire.ssh.client.editor.component.keys.key.SSHKeyEditor;
import org.uberfire.ssh.service.shared.editor.PortableSSHPublicKey;

@RunWith(value=MockitoJUnitRunner.class)
public class SSHKeysDisplayerTest {
    @Mock
    private SSHKeysDisplayerView view;
    @Mock
    private ManagedInstance<SSHKeyEditor> editors;
    @Mock
    private Command addCommand;
    @Mock
    private ParameterizedCommand<PortableSSHPublicKey> deleteCommand;
    @Mock
    private PortableSSHPublicKey key;
    private List<SSHKeyEditor> createdEditors = new ArrayList<SSHKeyEditor>();
    private SSHKeysDisplayer displayer;

    @Before
    public void init() {
        Mockito.when((Object)((SSHKeyEditor)this.editors.get())).thenAnswer(invocationOnMock -> {
            SSHKeyEditor editor = (SSHKeyEditor)Mockito.mock(SSHKeyEditor.class);
            this.createdEditors.add(editor);
            return editor;
        });
        this.displayer = new SSHKeysDisplayer(this.view, this.editors);
    }

    @Test
    public void testFunctionality() {
        ((SSHKeysDisplayerView)Mockito.verify((Object)this.view)).init((Object)this.displayer);
        this.displayer.init(this.addCommand, this.deleteCommand);
        this.displayer.getElement();
        ((SSHKeysDisplayerView)Mockito.verify((Object)this.view)).getElement();
        this.displayer.clear();
        ((SSHKeysDisplayerView)Mockito.verify((Object)this.view)).clear();
        ((ManagedInstance)Mockito.verify(this.editors)).destroyAll();
        this.displayer.notifyAdd();
        ((Command)Mockito.verify((Object)this.addCommand)).execute();
        this.displayer.onDelete(this.key);
        ((ParameterizedCommand)Mockito.verify(this.deleteCommand)).execute((Object)this.key);
    }

    @Test
    public void testRenderKeys() {
        ArrayList<PortableSSHPublicKey> keys = new ArrayList<PortableSSHPublicKey>();
        keys.add(this.key);
        keys.add((PortableSSHPublicKey)Mockito.mock(PortableSSHPublicKey.class));
        keys.add((PortableSSHPublicKey)Mockito.mock(PortableSSHPublicKey.class));
        this.displayer.render(keys);
        Assert.assertEquals((long)keys.size(), (long)this.createdEditors.size());
        ((ManagedInstance)Mockito.verify(this.editors, (VerificationMode)Mockito.times((int)keys.size()))).get();
        this.createdEditors.forEach(editor -> ((SSHKeyEditor)Mockito.verify((Object)editor)).render((PortableSSHPublicKey)ArgumentMatchers.any(), (Command)ArgumentMatchers.any()));
    }
}

