/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories.impl.git;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.PublicURI;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.backend.vfs.Path;
import org.uberfire.security.ResourceType;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@Portable
public class GitRepository
implements Repository {
    public static final SpacesAPI.Scheme SCHEME = SpacesAPI.Scheme.GIT;
    private final Map<String, Object> environment = new HashMap<String, Object>();
    private final List<PublicURI> publicURIs = new ArrayList<PublicURI>();
    private final Map<String, Branch> branches = new HashMap<String, Branch>();
    private String alias = null;
    private Space space;
    private Collection<String> groups = new ArrayList<String>();
    private Collection<Contributor> contributors = new ArrayList<Contributor>();
    private boolean requiresRefresh = true;

    public GitRepository() {
    }

    public GitRepository(String alias, Space space) {
        this.alias = alias;
        this.space = space;
    }

    public GitRepository(String alias, Space space, List<PublicURI> publicURIs) {
        this(alias, space);
        if (publicURIs != null && !publicURIs.isEmpty()) {
            this.publicURIs.addAll(publicURIs);
        }
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public Space getSpace() {
        return this.space;
    }

    @Override
    public SpacesAPI.Scheme getScheme() {
        return SCHEME;
    }

    @Override
    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    @Override
    public void addEnvironmentParameter(String key, Object value) {
        this.environment.put(key, value);
    }

    public void setBranches(Map<String, Branch> branches) {
        this.branches.clear();
        this.branches.putAll(branches);
    }

    @Override
    public Collection<Branch> getBranches() {
        return Collections.unmodifiableCollection(this.branches.values());
    }

    @Override
    public Optional<Branch> getBranch(String branchName) {
        return Optional.ofNullable(this.branches.get(branchName));
    }

    @Override
    public Optional<Branch> getBranch(Path branchRoot) {
        for (Branch branch : this.getBranches()) {
            if (!branch.getPath().equals(branchRoot)) continue;
            return Optional.of(branch);
        }
        return Optional.empty();
    }

    @Override
    public boolean isValid() {
        return this.alias != null;
    }

    @Override
    public String getUri() {
        String fsName = SpacesAPI.sanitizeFileSystemName((String)this.getAlias());
        return SpacesAPI.resolveFileSystemPath((SpacesAPI.Scheme)this.getScheme(), (Space)this.getSpace(), (String)fsName).toString();
    }

    @Override
    public List<PublicURI> getPublicURIs() {
        return this.publicURIs;
    }

    public void setPublicURIs(List<PublicURI> publicURIs) {
        if (publicURIs != null && !publicURIs.isEmpty()) {
            this.publicURIs.clear();
            this.publicURIs.addAll(publicURIs);
        }
    }

    public String getIdentifier() {
        return this.getUri();
    }

    public ResourceType getResourceType() {
        return RESOURCE_TYPE;
    }

    @Override
    public Collection<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        this.groups = new ArrayList<String>(groups);
    }

    @Override
    public Collection<Contributor> getContributors() {
        return this.contributors;
    }

    @Override
    public Optional<Branch> getDefaultBranch() {
        if (this.branches.containsKey("master")) {
            return this.getBranch("master");
        }
        if (!this.branches.isEmpty()) {
            return Optional.of(this.branches.values().iterator().next());
        }
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GitRepository)) {
            return false;
        }
        GitRepository that = (GitRepository)o;
        if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) {
            return false;
        }
        if (!this.environment.equals(that.environment)) {
            return false;
        }
        if (!this.publicURIs.equals(that.publicURIs)) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        return !(this.branches != null ? !this.branches.equals(that.branches) : that.branches != null);
    }

    public int hashCode() {
        int result = this.environment.hashCode();
        result = ~(~result);
        result = 31 * result + this.publicURIs.hashCode();
        result = ~(~result);
        result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.branches != null ? this.branches.hashCode() : 0);
        result = ~(~result);
        return result;
    }

    public String toString() {
        return "GitRepository [alias=" + this.alias + ", environment=" + this.environment + ", groups=" + this.groups + ", publicURI=" + this.publicURIs + ", branches=" + this.branches + "]";
    }

    public void markAsCached() {
        this.requiresRefresh = false;
    }

    public boolean requiresRefresh() {
        return this.requiresRefresh;
    }

    public void addBranch(Branch branch) {
        this.branches.put(branch.getName(), branch);
    }
}

