/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories.impl.git;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.guvnor.structure.repositories.PublicURI;
import org.guvnor.structure.repositories.Repository;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.uberfire.backend.vfs.Path;
import org.uberfire.security.ResourceType;

@Portable
public class GitRepository
implements Repository {
    public static final String SCHEME = "git";
    private final Map<String, Object> environment = new HashMap<String, Object>();
    private final List<PublicURI> publicURIs = new ArrayList<PublicURI>();
    private String alias = null;
    private Path root;
    private Collection<String> groups = new ArrayList<String>();
    private boolean requiresRefresh = true;
    private final Map<String, Path> branches = new HashMap<String, Path>();

    public GitRepository() {
    }

    public GitRepository(String alias) {
        this.alias = alias;
    }

    public GitRepository(String alias, List<PublicURI> publicURIs) {
        this(alias);
        if (publicURIs != null && !publicURIs.isEmpty()) {
            this.publicURIs.addAll(publicURIs);
        }
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    @Override
    public String getScheme() {
        return SCHEME;
    }

    @Override
    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    @Override
    public void addEnvironmentParameter(String key, Object value) {
        this.environment.put(key, value);
    }

    @Override
    public void setRoot(Path root) {
        this.root = root;
    }

    public void setBranches(Map<String, Path> branches) {
        this.branches.clear();
        this.branches.putAll(branches);
    }

    @Override
    public Collection<String> getBranches() {
        return Collections.unmodifiableSet(this.branches.keySet());
    }

    @Override
    public Path getRoot() {
        return this.root;
    }

    @Override
    public Path getBranchRoot(String branch) {
        return this.branches.get(branch);
    }

    @Override
    public boolean isValid() {
        return this.alias != null;
    }

    @Override
    public String getUri() {
        return this.getScheme() + "://" + this.getAlias();
    }

    @Override
    public List<PublicURI> getPublicURIs() {
        return this.publicURIs;
    }

    public void setPublicURIs(List<PublicURI> publicURIs) {
        if (publicURIs != null && !publicURIs.isEmpty()) {
            this.publicURIs.clear();
            this.publicURIs.addAll(publicURIs);
        }
    }

    public String getIdentifier() {
        return this.getUri();
    }

    public ResourceType getResourceType() {
        return RESOURCE_TYPE;
    }

    @Override
    public Collection<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Collection<String> groups) {
        this.groups = new ArrayList<String>(groups);
    }

    @Override
    public String getDefaultBranch() {
        if (this.branches.containsKey("master")) {
            return "master";
        }
        if (!this.branches.isEmpty()) {
            return this.branches.keySet().iterator().next();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GitRepository)) {
            return false;
        }
        GitRepository that = (GitRepository)o;
        if (this.alias != null ? !this.alias.equals(that.alias) : that.alias != null) {
            return false;
        }
        if (!this.environment.equals(that.environment)) {
            return false;
        }
        if (!this.publicURIs.equals(that.publicURIs)) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.root != null ? !this.root.equals(that.root) : that.root != null) {
            return false;
        }
        return !(this.branches != null ? !this.branches.equals(that.branches) : that.branches != null);
    }

    public int hashCode() {
        int result = this.environment.hashCode();
        result = ~(~result);
        result = 31 * result + this.publicURIs.hashCode();
        result = ~(~result);
        result = 31 * result + (this.alias != null ? this.alias.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.root != null ? this.root.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
        result = ~(~result);
        result = 31 * result + (this.branches != null ? this.branches.hashCode() : 0);
        result = ~(~result);
        return result;
    }

    public String toString() {
        return "GitRepository [alias=" + this.alias + ", environment=" + this.environment + ", root=" + this.root + ", groups=" + this.groups + ", publicURI=" + this.publicURIs + ", branches=" + this.branches + "]";
    }

    public void markAsCached() {
        this.requiresRefresh = false;
    }

    public boolean requiresRefresh() {
        return this.requiresRefresh;
    }

    public void addBranch(String branchName, Path path) {
        this.branches.put(branchName, path);
    }
}

