/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories.impl;

import org.guvnor.structure.repositories.PullRequest;
import org.guvnor.structure.repositories.PullRequestStatus;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;

@Portable
public class PullRequestImpl
implements PullRequest {
    private long id;
    private String targetBranch;
    private String targetRepository;
    private String sourceBranch;
    private String sourceRepository;
    private PullRequestStatus status;

    public PullRequestImpl() {
    }

    public PullRequestImpl(String sourceRepository, String sourceBranch, String targetRepository, String targetBranch) {
        this(0L, sourceRepository, sourceBranch, targetRepository, targetBranch, PullRequestStatus.OPEN);
    }

    public PullRequestImpl(@MapsTo(value="id") long id, @MapsTo(value="sourceRepository") String sourceRepository, @MapsTo(value="sourceBranch") String sourceBranch, @MapsTo(value="targetRepository") String targetRepository, @MapsTo(value="targetBranch") String targetBranch, @MapsTo(value="status") PullRequestStatus status) {
        this.id = id;
        this.sourceRepository = PortablePreconditions.checkNotEmpty((String)"sourceRepository", (String)sourceRepository);
        this.sourceBranch = PortablePreconditions.checkNotEmpty((String)"sourceBranch", (String)sourceBranch);
        this.targetRepository = PortablePreconditions.checkNotEmpty((String)"targetRepository", (String)targetRepository);
        this.targetBranch = PortablePreconditions.checkNotEmpty((String)"targetBranch", (String)targetBranch);
        this.status = (PullRequestStatus)((Object)PortablePreconditions.checkNotNull((String)"status", (Object)((Object)status)));
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getTargetRepository() {
        return this.targetRepository;
    }

    @Override
    public String getTargetBranch() {
        return this.targetBranch;
    }

    @Override
    public String getSourceRepository() {
        return this.sourceRepository;
    }

    @Override
    public String getSourceBranch() {
        return this.sourceBranch;
    }

    @Override
    public PullRequestStatus getStatus() {
        return this.status;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PullRequest) {
            return ((PullRequest)obj).getId() == this.getId();
        }
        return super.equals(obj);
    }

    public int hashCode() {
        int result = Long.hashCode(this.id);
        result = ~(~result);
        result = 31 * result + this.targetRepository.hashCode();
        result = ~(~result);
        result = 31 * result + this.targetBranch.hashCode();
        result = ~(~result);
        result = 31 * result + this.sourceRepository.hashCode();
        result = ~(~result);
        result = 31 * result + this.sourceBranch.hashCode();
        result = ~(~result);
        result = 31 * result + this.status.hashCode();
        result = ~(~result);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" <" + this.getId() + "," + (Object)((Object)this.getStatus()) + "> ");
        builder.append(" { ");
        builder.append(" source:( " + this.getSourceRepository() + "," + this.getSourceBranch() + " ) ");
        builder.append(" -> ");
        builder.append(" target:( " + this.getTargetRepository() + "," + this.getTargetBranch() + " ) ");
        builder.append(" } ");
        return builder.toString();
    }
}

