/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.repositories.changerequest;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.guvnor.structure.repositories.changerequest.ChangeRequestPredicates;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequest;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestStatus;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ChangeRequestPredicatesTest {
    @Test
    public void matchAllTest() {
        List<ChangeRequest> changeRequests = Collections.nCopies(10, (ChangeRequest)Mockito.mock(ChangeRequest.class));
        List filteredList = changeRequests.stream().filter(ChangeRequestPredicates.matchAll()).collect(Collectors.toList());
        Assertions.assertThat(filteredList).hasSize(10);
    }

    @Test
    public void matchIdTest() {
        ChangeRequest crOne = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)1L).when((Object)crOne)).getId();
        ChangeRequest crTwo = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)2L).when((Object)crTwo)).getId();
        List changeRequests = Stream.of(crOne, crTwo).collect(Collectors.toList());
        List filteredList = changeRequests.stream().filter(ChangeRequestPredicates.matchId((Long)2L)).collect(Collectors.toList());
        Assertions.assertThat(filteredList).hasSize(1);
    }

    @Test
    public void matchSearchFilterTest() {
        ChangeRequest crOne = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"CR 1").when((Object)crOne)).toString();
        ChangeRequest crTwo = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"CR 2").when((Object)crTwo)).toString();
        ChangeRequest crThree = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"3").when((Object)crThree)).toString();
        List changeRequests = Stream.of(crOne, crTwo, crThree).collect(Collectors.toList());
        List filteredList = changeRequests.stream().filter(ChangeRequestPredicates.matchSearchFilter((String)"CR", elem -> elem.toString().toLowerCase())).collect(Collectors.toList());
        Assertions.assertThat(filteredList).hasSize(2);
    }

    @Test
    public void matchStatusTest() {
        ChangeRequest crOne = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)ChangeRequestStatus.OPEN).when((Object)crOne)).getStatus();
        ChangeRequest crTwo = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)ChangeRequestStatus.ACCEPTED).when((Object)crTwo)).getStatus();
        List changeRequests = Stream.of(crOne, crTwo).collect(Collectors.toList());
        List filteredList = changeRequests.stream().filter(ChangeRequestPredicates.matchStatus((ChangeRequestStatus)ChangeRequestStatus.OPEN)).collect(Collectors.toList());
        Assertions.assertThat(filteredList).hasSize(1);
    }

    @Test
    public void matchInStatusListTest() {
        ChangeRequest crOne = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)ChangeRequestStatus.OPEN).when((Object)crOne)).getStatus();
        ChangeRequest crTwo = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)ChangeRequestStatus.ACCEPTED).when((Object)crTwo)).getStatus();
        ChangeRequest crThree = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)ChangeRequestStatus.REJECTED).when((Object)crThree)).getStatus();
        List changeRequests = Stream.of(crOne, crTwo, crThree).collect(Collectors.toList());
        List statusList = Stream.of(ChangeRequestStatus.OPEN, ChangeRequestStatus.ACCEPTED).collect(Collectors.toList());
        List filteredList = changeRequests.stream().filter(ChangeRequestPredicates.matchInStatusList(statusList)).collect(Collectors.toList());
        Assertions.assertThat(filteredList).hasSize(2);
    }

    @Test
    public void matchInTargetBranchListTest() {
        ChangeRequest crOne = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"branch1").when((Object)crOne)).getTargetBranch();
        ChangeRequest crTwo = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"branch2").when((Object)crTwo)).getTargetBranch();
        ChangeRequest crThree = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"branch3").when((Object)crThree)).getTargetBranch();
        List changeRequests = Stream.of(crOne, crTwo, crThree).collect(Collectors.toList());
        List branchList = Stream.of("branch1", "branch2").collect(Collectors.toList());
        List filteredList = changeRequests.stream().filter(ChangeRequestPredicates.matchInTargetBranchList(branchList)).collect(Collectors.toList());
        Assertions.assertThat(filteredList).hasSize(2);
    }

    @Test
    public void matchSourceBranchTest() {
        ChangeRequest crOne = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"branch1").when((Object)crOne)).getSourceBranch();
        ChangeRequest crTwo = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"branch2").when((Object)crTwo)).getSourceBranch();
        List changeRequests = Stream.of(crOne, crTwo).collect(Collectors.toList());
        List filteredList = changeRequests.stream().filter(ChangeRequestPredicates.matchSourceBranch((String)"branch1")).collect(Collectors.toList());
        Assertions.assertThat(filteredList).hasSize(1);
    }

    @Test
    public void matchTargetBranchTest() {
        ChangeRequest crOne = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"branch1").when((Object)crOne)).getTargetBranch();
        ChangeRequest crTwo = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"branch2").when((Object)crTwo)).getTargetBranch();
        List changeRequests = Stream.of(crOne, crTwo).collect(Collectors.toList());
        List filteredList = changeRequests.stream().filter(ChangeRequestPredicates.matchTargetBranch((String)"branch1")).collect(Collectors.toList());
        Assertions.assertThat(filteredList).hasSize(1);
    }

    @Test
    public void matchSearchFilterAndStatusListTest() {
        ChangeRequest crOne = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)ChangeRequestStatus.OPEN).when((Object)crOne)).getStatus();
        ((ChangeRequest)Mockito.doReturn((Object)"CR 1").when((Object)crOne)).toString();
        ChangeRequest crTwo = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)ChangeRequestStatus.ACCEPTED).when((Object)crTwo)).getStatus();
        ((ChangeRequest)Mockito.doReturn((Object)"CR 2").when((Object)crTwo)).toString();
        ChangeRequest crThree = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)ChangeRequestStatus.REJECTED).when((Object)crThree)).getStatus();
        ((ChangeRequest)Mockito.doReturn((Object)"CR 3").when((Object)crThree)).toString();
        List changeRequests = Stream.of(crOne, crTwo, crThree).collect(Collectors.toList());
        List statusList = Stream.of(ChangeRequestStatus.OPEN, ChangeRequestStatus.ACCEPTED).collect(Collectors.toList());
        List filteredList = changeRequests.stream().filter(ChangeRequestPredicates.matchSearchFilterAndStatusList((String)"CR", elem -> elem.toString().toLowerCase(), statusList)).collect(Collectors.toList());
        Assertions.assertThat(filteredList).hasSize(2);
    }

    @Test
    public void matchSourceOrTargetBranchTest() {
        ChangeRequest crOne = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"branch").when((Object)crOne)).getSourceBranch();
        ChangeRequest crTwo = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"sourceBranch2").when((Object)crTwo)).getSourceBranch();
        ((ChangeRequest)Mockito.doReturn((Object)"targetBranch2").when((Object)crTwo)).getTargetBranch();
        ChangeRequest crThree = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"sourceBranch3").when((Object)crThree)).getSourceBranch();
        ((ChangeRequest)Mockito.doReturn((Object)"branch").when((Object)crThree)).getTargetBranch();
        List changeRequests = Stream.of(crOne, crTwo, crThree).collect(Collectors.toList());
        List filteredList = changeRequests.stream().filter(ChangeRequestPredicates.matchSourceOrTargetBranch((String)"branch")).collect(Collectors.toList());
        Assertions.assertThat(filteredList).hasSize(2);
    }

    @Test
    public void matchSourceAndTargetAndStatusTest() {
        ChangeRequest crOne = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"sourceBranch").when((Object)crOne)).getSourceBranch();
        ((ChangeRequest)Mockito.doReturn((Object)"targetBranch").when((Object)crOne)).getTargetBranch();
        ((ChangeRequest)Mockito.doReturn((Object)ChangeRequestStatus.OPEN).when((Object)crOne)).getStatus();
        ChangeRequest crTwo = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"sourceBranch").when((Object)crTwo)).getSourceBranch();
        ((ChangeRequest)Mockito.doReturn((Object)"targetBranch").when((Object)crTwo)).getTargetBranch();
        ((ChangeRequest)Mockito.doReturn((Object)ChangeRequestStatus.REJECTED).when((Object)crTwo)).getStatus();
        ChangeRequest crThree = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"sourceBranch3").when((Object)crThree)).getSourceBranch();
        List changeRequests = Stream.of(crOne, crTwo, crThree).collect(Collectors.toList());
        List filteredList = changeRequests.stream().filter(ChangeRequestPredicates.matchSourceAndTargetAndStatus((String)"sourceBranch", (String)"targetBranch", (ChangeRequestStatus)ChangeRequestStatus.OPEN)).collect(Collectors.toList());
        Assertions.assertThat(filteredList).hasSize(1);
    }

    @Test
    public void matchTargetBranchListAndOtherPredicateTest() {
        ChangeRequest crOne = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"targetBranch1").when((Object)crOne)).getTargetBranch();
        ((ChangeRequest)Mockito.doReturn((Object)ChangeRequestStatus.OPEN).when((Object)crOne)).getStatus();
        ChangeRequest crTwo = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"targetBranch2").when((Object)crTwo)).getTargetBranch();
        ((ChangeRequest)Mockito.doReturn((Object)ChangeRequestStatus.OPEN).when((Object)crTwo)).getStatus();
        ChangeRequest crThree = (ChangeRequest)Mockito.mock(ChangeRequest.class);
        ((ChangeRequest)Mockito.doReturn((Object)"targetBranch3").when((Object)crThree)).getTargetBranch();
        ((ChangeRequest)Mockito.doReturn((Object)ChangeRequestStatus.REJECTED).when((Object)crThree)).getStatus();
        List changeRequests = Stream.of(crOne, crTwo, crThree).collect(Collectors.toList());
        List targetBranches = Stream.of("targetBranch1", "targetBranch2", "targetBranch3").collect(Collectors.toList());
        List filteredList = changeRequests.stream().filter(ChangeRequestPredicates.matchTargetBranchListAndOtherPredicate(targetBranches, (Predicate)ChangeRequestPredicates.matchStatus((ChangeRequestStatus)ChangeRequestStatus.OPEN))).collect(Collectors.toList());
        Assertions.assertThat(filteredList).hasSize(2);
    }
}

