/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.Optional;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.NewBranchEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryCopier;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileVisitResult;
import org.uberfire.java.nio.file.FileVisitor;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.StandardCopyOption;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.Space;

public class RepositoryCopierImpl
implements RepositoryCopier {
    private IOService ioService;
    private Event<NewBranchEvent> newBranchEventEvent;
    private ConfiguredRepositories configuredRepositories;
    private RepositoryService repositoryService;
    private SessionInfo sessionInfo;

    public RepositoryCopierImpl() {
    }

    @Inject
    public RepositoryCopierImpl(@Named(value="ioStrategy") IOService ioService, Event<NewBranchEvent> newBranchEventEvent, ConfiguredRepositories configuredRepositories, RepositoryService repositoryService, SessionInfo sessionInfo) {
        this.ioService = ioService;
        this.newBranchEventEvent = newBranchEventEvent;
        this.configuredRepositories = configuredRepositories;
        this.repositoryService = repositoryService;
        this.sessionInfo = sessionInfo;
    }

    public Repository copy(OrganizationalUnit targetOU, String newRepositoryName, org.uberfire.backend.vfs.Path originRoot) {
        Repository targetRepository = this.getRepository(targetOU, newRepositoryName);
        if (targetRepository.getDefaultBranch().isPresent()) {
            this.copy(originRoot, ((Branch)targetRepository.getDefaultBranch().get()).getPath());
        }
        return targetRepository;
    }

    private Repository getRepository(OrganizationalUnit targetOU, String newRepositoryName) {
        return this.repositoryService.createRepository(targetOU, GitRepository.SCHEME.toString(), this.makeSafeRepositoryName(newRepositoryName), new RepositoryEnvironmentConfigurations());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(org.uberfire.backend.vfs.Path originRoot, org.uberfire.backend.vfs.Path targetRoot) {
        boolean branchExisted = this.repositoryService.getRepository(targetRoot) != null;
        Path nioTargetRepositoryRoot = Paths.convert((org.uberfire.backend.vfs.Path)targetRoot);
        Path originRepositoryRoot = Paths.convert((org.uberfire.backend.vfs.Path)originRoot);
        this.ioService.startBatch(nioTargetRepositoryRoot.getFileSystem());
        try {
            this.copyFolders(nioTargetRepositoryRoot, originRepositoryRoot);
            this.copyRootFiles(targetRoot, originRepositoryRoot);
        }
        finally {
            this.ioService.endBatch();
        }
        if (!branchExisted) {
            this.fireNewBranchEvent(targetRoot, nioTargetRepositoryRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(Space space, org.uberfire.backend.vfs.Path originRoot, org.uberfire.backend.vfs.Path targetRoot) {
        boolean branchExisted = this.repositoryService.getRepository(space, targetRoot) != null;
        Path nioTargetRepositoryRoot = Paths.convert((org.uberfire.backend.vfs.Path)targetRoot);
        Path originRepositoryRoot = Paths.convert((org.uberfire.backend.vfs.Path)originRoot);
        this.ioService.startBatch(nioTargetRepositoryRoot.getFileSystem());
        try {
            this.copyFolders(nioTargetRepositoryRoot, originRepositoryRoot);
            this.copyRootFiles(targetRoot, originRepositoryRoot);
        }
        finally {
            this.ioService.endBatch();
        }
        if (!branchExisted) {
            this.fireNewBranchEvent(space, targetRoot, nioTargetRepositoryRoot);
        }
    }

    private void fireNewBranchEvent(org.uberfire.backend.vfs.Path targetRoot, Path nioTargetRepositoryRoot) {
        this.configuredRepositories.reloadRepositories();
        Repository repository = this.repositoryService.getRepository(targetRoot);
        Optional branch = repository.getBranch(Paths.convert((Path)nioTargetRepositoryRoot.getRoot()));
        if (!branch.isPresent()) {
            throw new IllegalStateException("Could not find a branch that was just created. The Path used was " + nioTargetRepositoryRoot.getRoot());
        }
        this.newBranchEventEvent.fire((Object)new NewBranchEvent(repository, ((Branch)branch.get()).getName(), this.sessionInfo.getIdentity()));
    }

    private void fireNewBranchEvent(Space space, org.uberfire.backend.vfs.Path targetRoot, Path nioTargetRepositoryRoot) {
        this.configuredRepositories.reloadRepositories();
        Repository repository = this.repositoryService.getRepository(space, targetRoot);
        Optional branch = repository.getBranch(Paths.convert((Path)nioTargetRepositoryRoot.getRoot()));
        if (!branch.isPresent()) {
            throw new IllegalStateException("Could not find a branch that was just created. The Path used was " + nioTargetRepositoryRoot.getRoot());
        }
        this.newBranchEventEvent.fire((Object)new NewBranchEvent(repository, ((Branch)branch.get()).getName(), this.sessionInfo.getIdentity()));
    }

    private void copyFolders(Path nioTargetRepositoryRoot, Path originRepositoryRoot) {
        RecursiveCopier copier = new RecursiveCopier(originRepositoryRoot, nioTargetRepositoryRoot);
        Files.walkFileTree((Path)originRepositoryRoot, (FileVisitor)copier);
    }

    private void copyRootFiles(org.uberfire.backend.vfs.Path targetRoot, Path originRepositoryRoot) {
        for (Path path : Files.newDirectoryStream((Path)originRepositoryRoot)) {
            if (Files.isDirectory((Path)path, (LinkOption[])new LinkOption[0])) continue;
            try {
                Path fileName = path.getFileName();
                Path resolve = Paths.convert((org.uberfire.backend.vfs.Path)targetRoot).resolve(fileName);
                Files.copy((Path)path, (Path)resolve, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            }
            catch (FileAlreadyExistsException x) {
                x.printStackTrace();
            }
        }
    }

    public String makeSafeRepositoryName(String oldName) {
        return oldName.replace(' ', '-');
    }

    static class RecursiveCopier
    implements FileVisitor<Path> {
        private final Path source;
        private final Path target;

        RecursiveCopier(Path source, Path target) {
            this.source = source;
            this.target = target;
        }

        public FileVisitResult preVisitDirectory(Path src, BasicFileAttributes attrs) {
            Path tgt = this.target.resolve(this.source.relativize(src));
            try {
                Files.copy((Path)src, (Path)tgt, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            return FileVisitResult.CONTINUE;
        }

        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            return FileVisitResult.CONTINUE;
        }

        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            return FileVisitResult.CONTINUE;
        }

        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            return FileVisitResult.CONTINUE;
        }
    }
}

