/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.GitMetadataStore;
import org.guvnor.structure.repositories.NewRepositoryEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryAlreadyExistsException;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfiguration;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryInfo;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.server.util.TextUtil;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.version.impl.PortableVersionRecord;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@Service
@ApplicationScoped
public class RepositoryServiceImpl
implements RepositoryService {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryServiceImpl.class);
    private static final int HISTORY_PAGE_SIZE = 10;
    private IOService ioService;
    private GitMetadataStore metadataStore;
    private ConfigurationService configurationService;
    private OrganizationalUnitService organizationalUnitService;
    private ConfigurationFactory configurationFactory;
    private RepositoryFactory repositoryFactory;
    private Event<NewRepositoryEvent> event;
    private Event<RepositoryRemovedEvent> repositoryRemovedEvent;
    private BackwardCompatibleUtil backward;
    private ConfiguredRepositories configuredRepositories;
    private AuthorizationManager authorizationManager;
    private SessionInfo sessionInfo;
    private SpacesAPI spacesAPI;

    public RepositoryServiceImpl() {
    }

    @Inject
    public RepositoryServiceImpl(@Named(value="ioStrategy") IOService ioService, GitMetadataStore metadataStore, ConfigurationService configurationService, OrganizationalUnitService organizationalUnitService, ConfigurationFactory configurationFactory, RepositoryFactory repositoryFactory, Event<NewRepositoryEvent> event, Event<RepositoryRemovedEvent> repositoryRemovedEvent, BackwardCompatibleUtil backward, ConfiguredRepositories configuredRepositories, AuthorizationManager authorizationManager, SessionInfo sessionInfo, SpacesAPI spacesAPI) {
        this.ioService = ioService;
        this.metadataStore = metadataStore;
        this.configurationService = configurationService;
        this.organizationalUnitService = organizationalUnitService;
        this.configurationFactory = configurationFactory;
        this.repositoryFactory = repositoryFactory;
        this.event = event;
        this.repositoryRemovedEvent = repositoryRemovedEvent;
        this.backward = backward;
        this.configuredRepositories = configuredRepositories;
        this.authorizationManager = authorizationManager;
        this.sessionInfo = sessionInfo;
        this.spacesAPI = spacesAPI;
    }

    public RepositoryInfo getRepositoryInfo(Space space, String alias) {
        Repository repo = this.getRepositoryFromSpace(space, alias);
        return new RepositoryInfo(repo.getIdentifier(), alias, repo.getSpace().getName(), this.getRepositoryRootPath(repo), repo.getPublicURIs(), this.getRepositoryHistory(repo.getSpace(), alias, 0, 10));
    }

    private Path getRepositoryRootPath(Repository repo) {
        if (repo.getDefaultBranch().isPresent()) {
            return ((Branch)repo.getDefaultBranch().get()).getPath();
        }
        return null;
    }

    public List<VersionRecord> getRepositoryHistory(Space space, String alias, int startIndex) {
        return this.getRepositoryHistory(space, alias, startIndex, startIndex + 10);
    }

    public List<VersionRecord> getRepositoryHistory(Space space, String alias, int startIndex, int endIndex) {
        Repository repo = this.getRepositoryFromSpace(space, alias);
        if (repo == null) {
            return Collections.EMPTY_LIST;
        }
        if (repo.getDefaultBranch().isPresent()) {
            throw new IllegalStateException("Repository should have at least one branch.");
        }
        VersionAttributeView versionAttributeView = (VersionAttributeView)this.ioService.getFileAttributeView(Paths.convert((Path)((Branch)repo.getDefaultBranch().get()).getPath()), VersionAttributeView.class);
        List records = versionAttributeView.readAttributes().history().records();
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex < 0 || endIndex > records.size()) {
            endIndex = records.size();
        }
        if (startIndex >= records.size() || startIndex >= endIndex) {
            return Collections.emptyList();
        }
        Collections.reverse(records);
        ArrayList<VersionRecord> result = new ArrayList<VersionRecord>(endIndex - startIndex);
        for (VersionRecord record : records.subList(startIndex, endIndex)) {
            result.add((VersionRecord)new PortableVersionRecord(record.id(), record.author(), record.email(), record.comment(), record.date(), record.uri()));
        }
        return result;
    }

    public Repository getRepositoryFromSpace(Space space, String alias) {
        return this.configuredRepositories.getRepositoryByRepositoryAlias(space, alias);
    }

    public Repository getRepository(Path root) {
        Space space = (Space)this.spacesAPI.resolveSpace(root.toURI()).orElseThrow(() -> new IllegalArgumentException("Cannot resolve space from given path: " + root));
        return this.configuredRepositories.getRepositoryByRootPath(space, root);
    }

    public Repository getRepository(Space space, Path root) {
        return this.configuredRepositories.getRepositoryByRootPath(space, root);
    }

    public String normalizeRepositoryName(String name) {
        return TextUtil.normalizeRepositoryName((String)name);
    }

    public boolean validateRepositoryName(String name) {
        return name != null && !"".equals(name) && name.equals(this.normalizeRepositoryName(name));
    }

    public Collection<Repository> getAllRepositories(Space space) {
        return this.configuredRepositories.getAllConfiguredRepositories(space);
    }

    public Collection<Repository> getAllRepositoriesFromAllUserSpaces() {
        ArrayList<Repository> allRepos = new ArrayList<Repository>();
        for (Space space : this.organizationalUnitService.getAllUserSpaces()) {
            allRepos.addAll(this.configuredRepositories.getAllConfiguredRepositories(space));
        }
        return allRepos;
    }

    public Collection<Repository> getRepositories(Space space) {
        ArrayList<Repository> result = new ArrayList<Repository>();
        for (Repository repository : this.configuredRepositories.getAllConfiguredRepositories(space)) {
            if (!this.authorizationManager.authorize((Resource)repository, this.sessionInfo.getIdentity())) continue;
            result.add(repository);
        }
        return result;
    }

    public Repository createRepository(OrganizationalUnit organizationalUnit, String scheme, String alias, RepositoryEnvironmentConfigurations repositoryEnvironmentConfigurations) throws RepositoryAlreadyExistsException {
        try {
            repositoryEnvironmentConfigurations.setSpace(organizationalUnit.getName());
            Space space = this.spacesAPI.getSpace(organizationalUnit.getName());
            String newAlias = this.createFreshRepositoryAlias(alias, space);
            Repository repository = this.createRepository(scheme, newAlias, new Space(organizationalUnit.getName()), repositoryEnvironmentConfigurations);
            if (organizationalUnit != null && repository != null) {
                this.organizationalUnitService.addRepository(organizationalUnit, repository);
            }
            this.metadataStore.write(newAlias, (String)repositoryEnvironmentConfigurations.getOrigin());
            return repository;
        }
        catch (Exception e) {
            logger.error("Error during create repository", (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected String createFreshRepositoryAlias(String alias, Space space) {
        int index = 0;
        String suffix = "";
        while (this.getRepositoryFromSpace(space, alias + suffix) != null) {
            suffix = "-" + ++index;
        }
        return alias + suffix;
    }

    protected ConfigGroup findRepositoryConfig(String alias, String spaceName) {
        List groups = this.configurationService.getConfiguration(ConfigType.REPOSITORY, spaceName);
        if (groups != null) {
            for (ConfigGroup groupConfig : groups) {
                if (!groupConfig.getName().equals(alias)) continue;
                return groupConfig;
            }
        }
        return null;
    }

    public void removeRepository(Space space, String alias) {
        ConfigGroup thisRepositoryConfig = this.findRepositoryConfig(alias, space.getName());
        try {
            this.configurationService.startBatch();
            OrganizationalUnit orgUnit = Optional.ofNullable(this.organizationalUnitService.getOrganizationalUnit(space.getName())).orElseThrow(() -> new IllegalArgumentException(String.format("The given space [%s] does not exist.", space.getName())));
            this.doRemoveRepository(orgUnit, alias, thisRepositoryConfig, repo -> this.repositoryRemovedEvent.fire((Object)new RepositoryRemovedEvent(repo)));
        }
        catch (Exception e) {
            logger.error("Error during remove repository", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.configurationService.endBatch();
        }
    }

    public void removeRepositories(Space space, Set<String> aliases) {
        try {
            this.configurationService.startBatch();
            OrganizationalUnit orgUnit = Optional.ofNullable(this.organizationalUnitService.getOrganizationalUnit(space.getName())).orElseThrow(() -> new IllegalArgumentException(String.format("The given space [%s] does not exist.", space.getName())));
            for (String alias : aliases) {
                this.doRemoveRepository(orgUnit, alias, this.findRepositoryConfig(alias, space.getName()), repo -> {});
            }
        }
        catch (Exception e) {
            logger.error("Error while removing repositories", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            this.configurationService.endBatch();
        }
    }

    private void doRemoveRepository(OrganizationalUnit orgUnit, String alias, ConfigGroup thisRepositoryConfig, Consumer<Repository> notification) throws Exception {
        Repository repo;
        if (thisRepositoryConfig != null) {
            this.configurationService.removeConfiguration(thisRepositoryConfig);
        }
        if ((repo = this.configuredRepositories.remove(orgUnit.getSpace(), alias)) != null) {
            notification.accept(repo);
            Branch defaultBranch = (Branch)repo.getDefaultBranch().orElseThrow(() -> new IllegalStateException("Repository should have at least one branch."));
            this.ioService.delete(Paths.convert((Path)defaultBranch.getPath()).getFileSystem().getPath(null, new String[0]), new DeleteOption[0]);
        }
        for (Repository repository : orgUnit.getRepositories()) {
            if (!repository.getAlias().equals(alias)) continue;
            this.organizationalUnitService.removeRepository(orgUnit, repository);
            this.metadataStore.delete(alias);
        }
    }

    public void addGroup(Repository repository, String group) {
        ConfigGroup thisRepositoryConfig = this.findRepositoryConfig(repository.getAlias(), repository.getSpace().getName());
        if (thisRepositoryConfig == null) {
            throw new IllegalArgumentException("Repository " + repository.getAlias() + " not found");
        }
        ConfigItem groups = this.backward.compat(thisRepositoryConfig).getConfigItem("security:groups");
        ((List)groups.getValue()).add(group);
        this.configurationService.updateConfiguration(thisRepositoryConfig);
        this.configuredRepositories.update(repository.getSpace(), this.repositoryFactory.newRepository(thisRepositoryConfig));
    }

    public void removeGroup(Repository repository, String group) {
        ConfigGroup thisRepositoryConfig = this.findRepositoryConfig(repository.getAlias(), repository.getSpace().getName());
        if (thisRepositoryConfig == null) {
            throw new IllegalArgumentException("Repository " + repository.getAlias() + " not found");
        }
        ConfigItem groups = this.backward.compat(thisRepositoryConfig).getConfigItem("security:groups");
        ((List)groups.getValue()).remove(group);
        this.configurationService.updateConfiguration(thisRepositoryConfig);
        this.configuredRepositories.update(repository.getSpace(), this.repositoryFactory.newRepository(thisRepositoryConfig));
    }

    public List<VersionRecord> getRepositoryHistoryAll(Space space, String alias) {
        return this.getRepositoryHistory(space, alias, 0, -1);
    }

    private Repository createRepository(String scheme, String alias, Space space, RepositoryEnvironmentConfigurations repositoryEnvironmentConfigurations) {
        Repository repository;
        if (this.configuredRepositories.containsAlias(space, alias)) {
            throw new RepositoryAlreadyExistsException(alias);
        }
        Repository repo = null;
        try {
            this.configurationService.startBatch();
            ConfigGroup repositoryConfig = this.configurationFactory.newConfigGroup(ConfigType.REPOSITORY, space.getName(), alias, "");
            repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("security:groups", new ArrayList()));
            if (!repositoryEnvironmentConfigurations.containsConfiguration("scheme")) {
                repositoryConfig.addConfigItem(this.configurationFactory.newConfigItem("scheme", scheme));
            }
            for (RepositoryEnvironmentConfiguration configuration : repositoryEnvironmentConfigurations.getConfigurationList()) {
                repositoryConfig.addConfigItem(this.getRepositoryConfigItem(configuration));
            }
            repository = repo = this.createRepository(repositoryConfig, space);
        }
        catch (Exception e) {
            try {
                logger.error("Error during create repository", (Throwable)e);
                throw ExceptionUtilities.handleException((Exception)e);
            }
            catch (Throwable throwable) {
                this.configurationService.endBatch();
                if (repo != null) {
                    this.event.fire((Object)new NewRepositoryEvent(repo));
                }
                throw throwable;
            }
        }
        this.configurationService.endBatch();
        if (repo != null) {
            this.event.fire((Object)new NewRepositoryEvent(repo));
        }
        return repository;
    }

    private Repository createRepository(ConfigGroup repositoryConfig, Space space) {
        Repository repository = this.repositoryFactory.newRepository(repositoryConfig);
        this.configurationService.addConfiguration(repositoryConfig);
        this.configuredRepositories.add(space, repository);
        return repository;
    }

    private ConfigItem getRepositoryConfigItem(RepositoryEnvironmentConfiguration configuration) {
        if (configuration.isSecuredConfigurationItem()) {
            return this.configurationFactory.newSecuredConfigItem(configuration.getName(), configuration.getValue().toString());
        }
        return this.configurationFactory.newConfigItem(configuration.getName(), configuration.getValue());
    }

    public class NoActiveSpaceInTheContext
    extends RuntimeException {
    }
}

