/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.organizationalunit.config;

import java.net.URI;
import java.util.LinkedHashMap;
import javax.inject.Inject;
import org.guvnor.structure.contributors.ContributorType;
import org.guvnor.structure.organizationalunit.config.BranchPermissions;
import org.guvnor.structure.organizationalunit.config.RolePermissions;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.uberfire.backend.server.io.object.ObjectStorage;
import org.uberfire.spaces.SpacesAPI;
import org.uberfire.util.URIUtil;

public class SpaceConfigStorageImpl
implements SpaceConfigStorage {
    public static final String FILE_FORMAT = ".json";
    public static final String BRANCH_PERMISSIONS = "BranchPermissions";
    private ObjectStorage objectStorage;

    public SpaceConfigStorageImpl() {
    }

    @Inject
    public SpaceConfigStorageImpl(ObjectStorage objectStorage) {
        this.objectStorage = objectStorage;
    }

    public void setup(String spaceName) {
        this.objectStorage.init(URI.create(SpacesAPI.resolveConfigFileSystemPath((SpacesAPI.Scheme)SpacesAPI.Scheme.DEFAULT, (String)spaceName)));
    }

    public BranchPermissions loadBranchPermissions(String branchName, String projectIdentifier) {
        BranchPermissions branchPermissions = (BranchPermissions)this.objectStorage.read(this.buildBranchConfigFilePath(branchName, projectIdentifier, BRANCH_PERMISSIONS));
        if (branchPermissions == null) {
            return this.getDefaultBranchPermissions(branchName);
        }
        return branchPermissions;
    }

    public void saveBranchPermissions(String branchName, String projectIdentifier, BranchPermissions branchPermissions) {
        this.objectStorage.write(this.buildBranchConfigFilePath(branchName, projectIdentifier, BRANCH_PERMISSIONS), (Object)branchPermissions);
    }

    public void deleteBranchPermissions(String branchName, String projectIdentifier) {
        this.objectStorage.delete(this.buildBranchConfigFilePath(branchName, projectIdentifier, BRANCH_PERMISSIONS));
    }

    BranchPermissions getDefaultBranchPermissions(String branchName) {
        LinkedHashMap<String, RolePermissions> defaultPermissions = new LinkedHashMap<String, RolePermissions>();
        defaultPermissions.put(ContributorType.OWNER.name(), new RolePermissions(ContributorType.OWNER.name(), true, true, true, true));
        defaultPermissions.put(ContributorType.ADMIN.name(), new RolePermissions(ContributorType.ADMIN.name(), true, true, false, true));
        defaultPermissions.put(ContributorType.CONTRIBUTOR.name(), new RolePermissions(ContributorType.CONTRIBUTOR.name(), true, true, false, false));
        return new BranchPermissions(branchName, defaultPermissions);
    }

    String buildSpaceConfigFilePath(String configName) {
        return "/config/" + configName + FILE_FORMAT;
    }

    String buildProjectConfigFilePath(String projectIdentifier, String configName) {
        return "/config/" + this.encode(projectIdentifier) + "/" + configName + FILE_FORMAT;
    }

    String buildBranchConfigFilePath(String branchName, String projectIdentifier, String configName) {
        return "/config/" + this.encode(projectIdentifier) + "/" + this.encode(branchName) + "/" + configName + FILE_FORMAT;
    }

    private String encode(String text) {
        return URIUtil.encodeQueryString((String)text);
    }
}

