/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories.git;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.UploadPack;
import org.guvnor.structure.backend.repositories.BranchAccessAuthorizer;
import org.guvnor.structure.backend.repositories.git.GitPathUtil;
import org.guvnor.structure.backend.repositories.git.hooks.PostCommitNotificationService;
import org.guvnor.structure.backend.repositories.git.hooks.exception.BranchOperationNotAllowedException;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.PublicURI;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryExternalUpdateEvent;
import org.guvnor.structure.repositories.impl.DefaultPublicURI;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.PasswordService;
import org.guvnor.structure.server.config.SecureConfigItem;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.extensions.FileSystemHooks;
import org.uberfire.java.nio.fs.jgit.daemon.filters.HiddenBranchRefFilter;
import org.uberfire.java.nio.security.FileSystemUser;
import org.uberfire.spaces.SpacesAPI;

public class GitRepositoryBuilder {
    private final IOService ioService;
    private final PasswordService secureService;
    private SpacesAPI spacesAPI;
    private Event<RepositoryExternalUpdateEvent> repositoryExternalUpdate;
    private PostCommitNotificationService postCommitNotificationService;
    private GitRepository repo;
    private BranchAccessAuthorizer branchAccessAuthorizer;

    public GitRepositoryBuilder(IOService ioService, PasswordService secureService, SpacesAPI spacesAPI, Event<RepositoryExternalUpdateEvent> repositoryExternalUpdate, PostCommitNotificationService postCommitNotificationService, BranchAccessAuthorizer branchAccessAuthorizer) {
        this.ioService = ioService;
        this.secureService = secureService;
        this.spacesAPI = spacesAPI;
        this.repositoryExternalUpdate = repositoryExternalUpdate;
        this.postCommitNotificationService = postCommitNotificationService;
        this.branchAccessAuthorizer = branchAccessAuthorizer;
    }

    public Repository build(ConfigGroup repoConfig) {
        ConfigItem space = repoConfig.getConfigItem("space");
        if (space == null) {
            throw new IllegalStateException("Repository " + repoConfig.getName() + " space is not valid");
        }
        this.repo = new GitRepository(repoConfig.getName(), this.spacesAPI.getSpace(space.getValue().toString()));
        if (!this.repo.isValid()) {
            throw new IllegalStateException("Repository " + repoConfig.getName() + " not valid");
        }
        this.addEnvironmentParameters(repoConfig.getItems());
        FileSystem fileSystem = this.createFileSystem(this.repo);
        this.setBranches(fileSystem);
        this.setPublicURIs(fileSystem);
        return this.repo;
    }

    private void setPublicURIs(FileSystem fileSystem) {
        String[] uris = fileSystem.toString().split("\\r?\\n");
        ArrayList<PublicURI> publicURIs = new ArrayList<PublicURI>(uris.length);
        for (String s : uris) {
            int protocolStart = s.indexOf("://");
            publicURIs.add(this.getPublicURI(s, protocolStart));
        }
        this.repo.setPublicURIs(publicURIs);
    }

    private PublicURI getPublicURI(String s, int protocolStart) {
        if (protocolStart > 0) {
            return new DefaultPublicURI(s.substring(0, protocolStart), s);
        }
        return new DefaultPublicURI(s);
    }

    private void setBranches(FileSystem fileSystem) {
        Map<String, Branch> branches = this.getBranches(fileSystem);
        this.repo.setBranches(branches);
    }

    private void addEnvironmentParameters(Collection<ConfigItem> items) {
        for (ConfigItem item : items) {
            if (item instanceof SecureConfigItem) {
                this.repo.addEnvironmentParameter(item.getName(), (Object)this.secureService.decrypt(item.getValue().toString()));
                continue;
            }
            this.repo.addEnvironmentParameter(item.getName(), item.getValue());
        }
    }

    private FileSystem createFileSystem(GitRepository repo) {
        FileSystem fs;
        URI uri = null;
        try {
            uri = URI.create(repo.getUri());
            fs = this.newFileSystem(uri);
        }
        catch (FileSystemAlreadyExistsException e) {
            fs = this.ioService.getFileSystem(uri);
            Object replaceIfExists = repo.getEnvironment().get("replaceIfExists");
            if (replaceIfExists != null && Boolean.valueOf(replaceIfExists.toString()).booleanValue()) {
                Path root = fs.getPath(null, new String[0]);
                this.ioService.delete(root, new DeleteOption[0]);
                fs = this.newFileSystem(uri);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        return fs;
    }

    private FileSystem newFileSystem(URI uri) {
        return this.ioService.newFileSystem(uri, (Map)new HashMap<String, Object>(this.repo.getEnvironment()){
            {
                if (!GitRepositoryBuilder.this.repo.getEnvironment().containsKey("origin")) {
                    this.put("init", true);
                }
                this.put(FileSystemHooks.ExternalUpdate.name(), GitRepositoryBuilder.this.externalUpdatedCallBack());
                this.put(FileSystemHooks.PostCommit.name(), GitRepositoryBuilder.this.postCommitCallback());
                this.put(FileSystemHooks.BranchAccessCheck.name(), GitRepositoryBuilder.this.checkBranchAccessCallback());
                this.put(FileSystemHooks.BranchAccessFilter.name(), GitRepositoryBuilder.this.filterBranchAccessCallback());
            }
        });
    }

    private FileSystemHooks.FileSystemHook externalUpdatedCallBack() {
        return ctx -> this.repositoryExternalUpdate.fire((Object)new RepositoryExternalUpdateEvent((Repository)this.repo));
    }

    private FileSystemHooks.FileSystemHook postCommitCallback() {
        return ctx -> this.postCommitNotificationService.notifyUser(this.repo, (Integer)ctx.getParamValue("POST_COMMIT_EXIT_CODE"));
    }

    private FileSystemHooks.FileSystemHook checkBranchAccessCallback() {
        return ctx -> {
            ReceiveCommand command = (ReceiveCommand)ctx.getParamValue("RECEIVE_COMMAND");
            FileSystemUser user = (FileSystemUser)ctx.getParamValue("USER");
            Optional<String> branchName = GitPathUtil.extractBranchFromRef(command.getRefName());
            branchName.ifPresent(branch -> {
                if (!this.branchAccessAuthorizer.authorize(user.getName(), this.repo.getSpace().getName(), this.repo.getIdentifier(), this.repo.getAlias(), (String)branch, BranchAccessAuthorizer.AccessType.valueOf(command.getType()))) {
                    throw new BranchOperationNotAllowedException();
                }
            });
        };
    }

    private FileSystemHooks.FileSystemHook filterBranchAccessCallback() {
        return ctx -> {
            UploadPack uploadPack = (UploadPack)ctx.getParamValue("UPLOAD_PACK");
            FileSystemUser user = (FileSystemUser)ctx.getParamValue("USER");
            uploadPack.setRefFilter(refs -> refs.entrySet().stream().filter(ref -> !HiddenBranchRefFilter.isHidden((String)((String)ref.getKey()))).filter(ref -> {
                Optional<String> branchName = GitPathUtil.extractBranchFromRef(((Ref)ref.getValue()).getName());
                if (branchName.isPresent()) {
                    return this.branchAccessAuthorizer.authorize(user.getName(), this.repo.getSpace().getName(), this.repo.getIdentifier(), this.repo.getAlias(), branchName.get(), BranchAccessAuthorizer.AccessType.READ);
                }
                return true;
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        };
    }

    private Map<String, Branch> getBranches(FileSystem fs) {
        HashMap<String, Branch> branches = new HashMap<String, Branch>();
        for (Path path : fs.getRootDirectories()) {
            String branchName = this.getBranchName(path);
            branches.put(branchName, new Branch(branchName, Paths.convert((Path)path)));
        }
        return branches;
    }

    protected String getBranchName(Path path) {
        URI uri = path.toUri();
        return GitPathUtil.extractBranch(uri.toString()).get();
    }
}

