/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.project.events.RepositoryContributorsUpdatedEvent;
import org.guvnor.structure.backend.backcompat.BackwardCompatibleUtil;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.contributors.Contributor;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.organizationalunit.config.RepositoryConfiguration;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorage;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.organizationalunit.config.SpaceInfo;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.GitMetadataStore;
import org.guvnor.structure.repositories.NewRepositoryEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryAlreadyExistsException;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfiguration;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryInfo;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.ConfigurationService;
import org.guvnor.structure.server.repositories.RepositoryFactory;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.server.util.TextUtil;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.version.impl.PortableVersionRecord;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.version.VersionAttributeView;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.spaces.Space;
import org.uberfire.spaces.SpacesAPI;

@Service
@ApplicationScoped
public class RepositoryServiceImpl
implements RepositoryService {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryServiceImpl.class);
    private static final int HISTORY_PAGE_SIZE = 10;
    private IOService ioService;
    private GitMetadataStore metadataStore;
    private ConfigurationService configurationService;
    private OrganizationalUnitService organizationalUnitService;
    private ConfigurationFactory configurationFactory;
    private RepositoryFactory repositoryFactory;
    private Event<NewRepositoryEvent> event;
    private Event<RepositoryRemovedEvent> repositoryRemovedEvent;
    private BackwardCompatibleUtil backward;
    private ConfiguredRepositories configuredRepositories;
    private AuthorizationManager authorizationManager;
    private User user;
    private SpacesAPI spacesAPI;
    private SpaceConfigStorageRegistry spaceConfigStorage;
    private Event<RepositoryContributorsUpdatedEvent> repositoryContributorsUpdatedEvent;

    public RepositoryServiceImpl() {
    }

    @Inject
    public RepositoryServiceImpl(@Named(value="ioStrategy") IOService ioService, GitMetadataStore metadataStore, ConfigurationService configurationService, OrganizationalUnitService organizationalUnitService, ConfigurationFactory configurationFactory, RepositoryFactory repositoryFactory, Event<NewRepositoryEvent> event, Event<RepositoryRemovedEvent> repositoryRemovedEvent, BackwardCompatibleUtil backward, ConfiguredRepositories configuredRepositories, AuthorizationManager authorizationManager, User user, SpacesAPI spacesAPI, SpaceConfigStorageRegistry spaceConfigStorage, Event<RepositoryContributorsUpdatedEvent> repositoryContributorsUpdatedEvent) {
        this.ioService = ioService;
        this.metadataStore = metadataStore;
        this.configurationService = configurationService;
        this.organizationalUnitService = organizationalUnitService;
        this.configurationFactory = configurationFactory;
        this.repositoryFactory = repositoryFactory;
        this.event = event;
        this.repositoryRemovedEvent = repositoryRemovedEvent;
        this.backward = backward;
        this.configuredRepositories = configuredRepositories;
        this.authorizationManager = authorizationManager;
        this.user = user;
        this.spacesAPI = spacesAPI;
        this.spaceConfigStorage = spaceConfigStorage;
        this.repositoryContributorsUpdatedEvent = repositoryContributorsUpdatedEvent;
    }

    public RepositoryInfo getRepositoryInfo(Space space, String alias) {
        Repository repo = this.getRepositoryFromSpace(space, alias);
        return new RepositoryInfo(repo.getIdentifier(), alias, repo.getSpace().getName(), this.getRepositoryRootPath(repo), repo.getPublicURIs(), this.getRepositoryHistory(repo.getSpace(), alias, 0, 10));
    }

    private Path getRepositoryRootPath(Repository repo) {
        if (repo.getDefaultBranch().isPresent()) {
            return ((Branch)repo.getDefaultBranch().get()).getPath();
        }
        return null;
    }

    public List<VersionRecord> getRepositoryHistory(Space space, String alias, int startIndex) {
        return this.getRepositoryHistory(space, alias, startIndex, startIndex + 10);
    }

    public List<VersionRecord> getRepositoryHistory(Space space, String alias, int startIndex, int endIndex) {
        Repository repo = this.getRepositoryFromSpace(space, alias);
        if (repo == null) {
            return Collections.EMPTY_LIST;
        }
        if (repo.getDefaultBranch().isPresent()) {
            throw new IllegalStateException("Repository should have at least one branch.");
        }
        VersionAttributeView versionAttributeView = (VersionAttributeView)this.ioService.getFileAttributeView(Paths.convert((Path)((Branch)repo.getDefaultBranch().get()).getPath()), VersionAttributeView.class);
        List records = versionAttributeView.readAttributes().history().records();
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex < 0 || endIndex > records.size()) {
            endIndex = records.size();
        }
        if (startIndex >= records.size() || startIndex >= endIndex) {
            return Collections.emptyList();
        }
        Collections.reverse(records);
        ArrayList<VersionRecord> result = new ArrayList<VersionRecord>(endIndex - startIndex);
        for (VersionRecord record : records.subList(startIndex, endIndex)) {
            result.add((VersionRecord)new PortableVersionRecord(record.id(), record.author(), record.email(), record.comment(), record.date(), record.uri()));
        }
        return result;
    }

    public Repository getRepositoryFromSpace(Space space, String alias) {
        return this.configuredRepositories.getRepositoryByRepositoryAlias(space, alias);
    }

    public Repository getRepository(Path root) {
        Space space = (Space)this.spacesAPI.resolveSpace(root.toURI()).orElseThrow(() -> new IllegalArgumentException("Cannot resolve space from given path: " + root));
        return this.configuredRepositories.getRepositoryByRootPath(space, root);
    }

    public Repository getRepository(Space space, Path root) {
        return this.configuredRepositories.getRepositoryByRootPath(space, root);
    }

    public String normalizeRepositoryName(String name) {
        return TextUtil.normalizeRepositoryName((String)name);
    }

    public boolean validateRepositoryName(String name) {
        return name != null && !"".equals(name) && name.equals(this.normalizeRepositoryName(name));
    }

    public Collection<Repository> getAllRepositories(Space space) {
        return this.getAllRepositories(space, false);
    }

    public Collection<Repository> getAllDeletedRepositories(Space space) {
        return this.configuredRepositories.getAllDeletedConfiguredRepositories(space);
    }

    public Collection<Repository> getAllRepositories(Space space, boolean includeDeleted) {
        return this.configuredRepositories.getAllConfiguredRepositories(space, includeDeleted);
    }

    public Collection<Repository> getAllRepositoriesFromAllUserSpaces() {
        ArrayList<Repository> allRepos = new ArrayList<Repository>();
        for (Space space : this.organizationalUnitService.getAllUserSpaces()) {
            allRepos.addAll(this.configuredRepositories.getAllConfiguredRepositories(space));
        }
        return allRepos;
    }

    public Collection<Repository> getRepositories(Space space) {
        ArrayList<Repository> result = new ArrayList<Repository>();
        for (Repository repository : this.configuredRepositories.getAllConfiguredRepositories(space)) {
            if (!this.authorizationManager.authorize((Resource)repository, this.user)) continue;
            result.add(repository);
        }
        return result;
    }

    public Repository createRepository(OrganizationalUnit organizationalUnit, String scheme, String alias, RepositoryEnvironmentConfigurations repositoryEnvironmentConfigurations) throws RepositoryAlreadyExistsException {
        return this.createRepository(organizationalUnit, scheme, alias, repositoryEnvironmentConfigurations, (Collection<Contributor>)organizationalUnit.getContributors());
    }

    public Repository createRepository(OrganizationalUnit organizationalUnit, String scheme, String alias, RepositoryEnvironmentConfigurations repositoryEnvironmentConfigurations, Collection<Contributor> contributors) throws RepositoryAlreadyExistsException {
        try {
            repositoryEnvironmentConfigurations.setSpace(organizationalUnit.getName());
            Space space = this.spacesAPI.getSpace(organizationalUnit.getName());
            String newAlias = this.createFreshRepositoryAlias(alias, space);
            Repository repository = this.createRepository(scheme, newAlias, new Space(organizationalUnit.getName()), repositoryEnvironmentConfigurations, contributors);
            if (organizationalUnit != null && repository != null) {
                this.organizationalUnitService.addRepository(organizationalUnit, repository);
            }
            this.metadataStore.write(newAlias, (String)repositoryEnvironmentConfigurations.getOrigin());
            return repository;
        }
        catch (Exception e) {
            logger.error("Error during create repository", (Throwable)e);
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    protected String createFreshRepositoryAlias(String alias, Space space) {
        int index = 0;
        String suffix = "";
        while (this.configuredRepositories.getRepositoryByRepositoryAlias(space, alias + suffix, true) != null) {
            suffix = "-" + ++index;
        }
        return alias + suffix;
    }

    protected Optional<org.guvnor.structure.organizationalunit.config.RepositoryInfo> findRepositoryConfig(String spaceName, String alias) {
        List found = this.spaceConfigStorage.get(spaceName).loadSpaceInfo().getRepositories(repo -> repo.getName().equals(alias));
        if (!found.isEmpty()) {
            return Optional.of(found.get(0));
        }
        return Optional.ofNullable(null);
    }

    public void removeRepository(Space space, String alias) {
        Optional<org.guvnor.structure.organizationalunit.config.RepositoryInfo> config = this.findRepositoryConfig(space.getName(), alias);
        try {
            OrganizationalUnit orgUnit = Optional.ofNullable(this.organizationalUnitService.getOrganizationalUnit(space.getName())).orElseThrow(() -> new IllegalArgumentException(String.format("The given space [%s] does not exist.", space.getName())));
            this.doRemoveRepository(orgUnit, alias, config, repo -> this.repositoryRemovedEvent.fire((Object)new RepositoryRemovedEvent(repo)), true);
        }
        catch (Exception e) {
            logger.error("Error during remove repository", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void removeRepositories(Space space, Set<String> aliases) {
        SpaceConfigStorage configStorage = this.spaceConfigStorage.get(space.getName());
        try {
            configStorage.startBatch();
            OrganizationalUnit orgUnit = Optional.ofNullable(this.organizationalUnitService.getOrganizationalUnit(space.getName())).orElseThrow(() -> new IllegalArgumentException(String.format("The given space [%s] does not exist.", space.getName())));
            for (String alias : aliases) {
                this.doRemoveRepository(orgUnit, alias, this.findRepositoryConfig(space.getName(), alias), repo -> {}, false);
            }
        }
        catch (Exception e) {
            logger.error("Error while removing repositories", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            configStorage.endBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveRepository(OrganizationalUnit orgUnit, String alias, Optional<org.guvnor.structure.organizationalunit.config.RepositoryInfo> thisRepositoryConfig, Consumer<Repository> notification, boolean lock) {
        SpaceConfigStorage configStorage = this.spaceConfigStorage.get(orgUnit.getName());
        try {
            Repository repo;
            if (lock) {
                configStorage.startBatch();
            }
            if ((repo = this.configuredRepositories.getRepositoryByRepositoryAlias(orgUnit.getSpace(), alias)) != null) {
                this.close(repo.getDefaultBranch());
                notification.accept(repo);
            }
            for (Repository repository : orgUnit.getRepositories()) {
                if (!repository.getAlias().equals(alias)) continue;
                this.organizationalUnitService.removeRepository(orgUnit, repository);
                this.metadataStore.delete(alias);
            }
        }
        finally {
            if (lock) {
                configStorage.endBatch();
            }
        }
    }

    private void close(Optional<Branch> defaultBranch) {
        defaultBranch.ifPresent(branch -> {
            FileSystem fs = Paths.convert((Path)branch.getPath()).getFileSystem();
            fs.close();
            fs.dispose();
        });
    }

    public void addGroup(Repository repository, String group) {
        Optional<org.guvnor.structure.organizationalunit.config.RepositoryInfo> thisRepositoryConfig = this.findRepositoryConfig(repository.getSpace().getName(), repository.getAlias());
        if (!thisRepositoryConfig.isPresent()) {
            throw new IllegalArgumentException("Repository " + repository.getAlias() + " not found");
        }
        thisRepositoryConfig.ifPresent(config -> {
            config.getSecurityGroups().add(group);
            this.saveRepositoryConfig(repository.getSpace().getName(), (org.guvnor.structure.organizationalunit.config.RepositoryInfo)config);
        });
    }

    public void removeGroup(Repository repository, String group) {
        Optional<org.guvnor.structure.organizationalunit.config.RepositoryInfo> thisRepositoryConfig = this.findRepositoryConfig(repository.getSpace().getName(), repository.getAlias());
        if (!thisRepositoryConfig.isPresent()) {
            throw new IllegalArgumentException("Repository " + repository.getAlias() + " not found");
        }
        thisRepositoryConfig.ifPresent(config -> {
            config.getSecurityGroups().remove(group);
            this.saveRepositoryConfig(repository.getSpace().getName(), (org.guvnor.structure.organizationalunit.config.RepositoryInfo)config);
        });
    }

    protected void saveRepositoryConfig(String space, org.guvnor.structure.organizationalunit.config.RepositoryInfo config) {
        this.spaceConfigStorage.getBatch(space).run(context -> {
            SpaceInfo spaceInfo = context.getSpaceInfo();
            spaceInfo.removeRepository(config.getName());
            spaceInfo.getRepositories().add(config);
            context.saveSpaceInfo();
            return null;
        });
    }

    public void updateContributors(Repository repository, List<Contributor> contributors) {
        Optional<org.guvnor.structure.organizationalunit.config.RepositoryInfo> thisRepositoryConfig = this.findRepositoryConfig(repository.getSpace().getName(), repository.getAlias());
        if (!thisRepositoryConfig.isPresent()) {
            throw new IllegalArgumentException("Repository " + repository.getAlias() + " not found");
        }
        thisRepositoryConfig.ifPresent(config -> {
            config.getConfiguration().add("contributors", (Object)contributors);
            this.saveRepositoryConfig(repository.getSpace().getName(), (org.guvnor.structure.organizationalunit.config.RepositoryInfo)config);
            this.repositoryContributorsUpdatedEvent.fire((Object)new RepositoryContributorsUpdatedEvent(this.getRepositoryFromSpace(repository.getSpace(), repository.getAlias())));
        });
    }

    public List<VersionRecord> getRepositoryHistoryAll(Space space, String alias) {
        return this.getRepositoryHistory(space, alias, 0, -1);
    }

    private Repository createRepository(String scheme, String alias, Space space, RepositoryEnvironmentConfigurations repositoryEnvironmentConfigurations, Collection<Contributor> contributors) {
        Repository repository;
        if (this.configuredRepositories.containsAlias(space, alias)) {
            throw new RepositoryAlreadyExistsException(alias);
        }
        Repository repo = null;
        SpaceConfigStorage configStorage = this.spaceConfigStorage.get(space.getName());
        try {
            configStorage.startBatch();
            RepositoryConfiguration configuration = new RepositoryConfiguration();
            configuration.add("security:groups", new ArrayList());
            configuration.add("contributors", contributors);
            if (!repositoryEnvironmentConfigurations.containsConfiguration("scheme")) {
                configuration.add("scheme", (Object)scheme);
            }
            for (RepositoryEnvironmentConfiguration configEntry : repositoryEnvironmentConfigurations.getConfigurationList()) {
                this.addConfiguration(configuration, configEntry);
            }
            org.guvnor.structure.organizationalunit.config.RepositoryInfo repositoryInfo = new org.guvnor.structure.organizationalunit.config.RepositoryInfo(alias, false, configuration);
            repository = repo = this.createRepository(repositoryInfo);
        }
        catch (Exception e) {
            try {
                logger.error("Error during create repository", (Throwable)e);
                throw ExceptionUtilities.handleException((Exception)e);
            }
            catch (Throwable throwable) {
                configStorage.endBatch();
                if (repo != null) {
                    this.event.fire((Object)new NewRepositoryEvent(repo));
                }
                throw throwable;
            }
        }
        configStorage.endBatch();
        if (repo != null) {
            this.event.fire((Object)new NewRepositoryEvent(repo));
        }
        return repository;
    }

    private Repository createRepository(org.guvnor.structure.organizationalunit.config.RepositoryInfo repositoryConfiguration) {
        Repository repository = this.repositoryFactory.newRepository(repositoryConfiguration);
        return repository;
    }

    private void addConfiguration(RepositoryConfiguration repositoryConfiguration, RepositoryEnvironmentConfiguration configuration) {
        String key = configuration.getName();
        if (configuration.isSecuredConfigurationItem()) {
            key = "secure:" + key;
        }
        repositoryConfiguration.add(key, configuration.getValue());
    }

    public class NoActiveSpaceInTheContext
    extends RuntimeException {
    }
}

