/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.config;

import java.util.List;
import javax.inject.Inject;
import org.guvnor.structure.server.config.ConfigGroup;
import org.guvnor.structure.server.config.ConfigItem;
import org.guvnor.structure.server.config.ConfigType;
import org.guvnor.structure.server.config.ConfigurationFactory;
import org.guvnor.structure.server.config.PasswordService;
import org.guvnor.structure.server.config.SecureConfigItem;

public class ConfigurationFactoryImpl
implements ConfigurationFactory {
    private PasswordService secureService;

    public ConfigurationFactoryImpl() {
    }

    @Inject
    public ConfigurationFactoryImpl(PasswordService secureService) {
        this.secureService = secureService;
    }

    public ConfigGroup newConfigGroup(ConfigType type, String name, String description) {
        ConfigGroup configGroup = new ConfigGroup();
        configGroup.setDescription(description);
        configGroup.setName(name);
        configGroup.setType(type);
        configGroup.setEnabled(true);
        return configGroup;
    }

    public ConfigItem<String> newConfigItem(String name, String valueType) {
        ConfigItem stringConfigItem = new ConfigItem();
        stringConfigItem.setName(name);
        stringConfigItem.setValue((Object)valueType);
        return stringConfigItem;
    }

    public ConfigItem<Boolean> newConfigItem(String name, boolean valueType) {
        ConfigItem booleanConfigItem = new ConfigItem();
        booleanConfigItem.setName(name);
        booleanConfigItem.setValue((Object)valueType);
        return booleanConfigItem;
    }

    public SecureConfigItem newSecuredConfigItem(String name, String valueType) {
        SecureConfigItem stringConfigItem = new SecureConfigItem();
        if (name.startsWith("crypt:")) {
            stringConfigItem.setName(name.substring("crypt:".length()));
        } else {
            stringConfigItem.setName(name);
        }
        stringConfigItem.setValue((Object)this.secureService.encrypt(valueType));
        return stringConfigItem;
    }

    public ConfigItem<List> newConfigItem(String name, List valueType) {
        ConfigItem listConfigItem = new ConfigItem();
        listConfigItem.setName(name);
        listConfigItem.setValue((Object)valueType);
        return listConfigItem;
    }

    public ConfigItem<Object> newConfigItem(String name, Object valueType) {
        ConfigItem listConfigItem = new ConfigItem();
        listConfigItem.setName(name);
        listConfigItem.setValue(valueType);
        return listConfigItem;
    }
}

