/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.inject.Named;
import org.guvnor.structure.backend.repositories.ConfiguredRepositories;
import org.guvnor.structure.repositories.GitMetadata;
import org.guvnor.structure.repositories.GitMetadataStore;
import org.guvnor.structure.repositories.PullRequest;
import org.guvnor.structure.repositories.PullRequestAlreadyExistsException;
import org.guvnor.structure.repositories.PullRequestService;
import org.guvnor.structure.repositories.PullRequestStatus;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryNotFoundException;
import org.guvnor.structure.repositories.impl.GitMetadataImpl;
import org.guvnor.structure.repositories.impl.PullRequestImpl;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.FileDiff;
import org.uberfire.java.nio.base.options.MergeCopyOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.Path;

public class PullRequestServiceImpl
implements PullRequestService {
    private final GitMetadataStore metadataStore;
    private final IOService ioService;
    private final ConfiguredRepositories configuredRepositories;
    private Logger logger = LoggerFactory.getLogger(PullRequestServiceImpl.class);

    @Inject
    public PullRequestServiceImpl(GitMetadataStore metadataStore, @Named(value="ioStrategy") IOService ioService, ConfiguredRepositories configuredRepositories) {
        this.metadataStore = metadataStore;
        this.ioService = ioService;
        this.configuredRepositories = configuredRepositories;
    }

    public PullRequest createPullRequest(String sourceRepository, String sourceBranch, String targetRepository, String targetBranch) {
        PullRequestImpl storablePullRequest;
        PortablePreconditions.checkNotEmpty((String)"sourceRepository", (String)sourceRepository);
        PortablePreconditions.checkNotEmpty((String)"sourceBranch", (String)sourceBranch);
        PortablePreconditions.checkNotEmpty((String)"targetRepository", (String)targetRepository);
        PortablePreconditions.checkNotEmpty((String)"targetBranch", (String)targetBranch);
        Optional targetRepositoryMetadata = this.metadataStore.read(targetRepository);
        if (targetRepositoryMetadata.isPresent()) {
            GitMetadata metadata = (GitMetadata)targetRepositoryMetadata.get();
            long generatedId = this.generatePullRequestId(metadata);
            ArrayList<PullRequestImpl> pullRequests = metadata.getPullRequests();
            if (pullRequests == null) {
                pullRequests = new ArrayList<PullRequestImpl>();
            }
            if (metadata.exists((PullRequest)(storablePullRequest = new PullRequestImpl(generatedId, sourceRepository, sourceBranch, targetRepository, targetBranch, PullRequestStatus.OPEN)))) {
                throw new PullRequestAlreadyExistsException((PullRequest)storablePullRequest);
            }
            pullRequests.add(storablePullRequest);
            GitMetadataImpl newMetadata = new GitMetadataImpl(metadata.getName(), metadata.getOrigin(), metadata.getForks(), pullRequests);
            this.metadataStore.write(metadata.getName(), (GitMetadata)newMetadata);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Pull request PR-{} created. Target repository: {} / {}", new Object[]{storablePullRequest.getId(), storablePullRequest.getTargetRepository(), storablePullRequest.getTargetBranch()});
            }
        } else {
            throw new RepositoryNotFoundException(String.format("The repository or branch does not exists %s/%s", targetRepository, targetBranch));
        }
        return storablePullRequest;
    }

    public PullRequest acceptPullRequest(PullRequest pullRequest) {
        PortablePreconditions.checkNotNull((String)"pullRequest", (Object)pullRequest);
        PortablePreconditions.checkNotNull((String)"id", (Object)pullRequest.getId());
        PortablePreconditions.checkNotEmpty((String)"targetRepository", (String)pullRequest.getTargetRepository());
        String repository = pullRequest.getTargetRepository();
        long id = pullRequest.getId();
        GitMetadata metadata = this.getRepositoryMetadata(repository);
        PullRequest acceptPullRequest = metadata.getPullRequest(id);
        this.createHiddenBranch(acceptPullRequest);
        this.mergePullRequest(acceptPullRequest);
        this.changePullRequestStatus(repository, id, PullRequestStatus.MERGED);
        return this.getRepositoryMetadata(repository).getPullRequest(id);
    }

    public PullRequest rejectPullRequest(PullRequest pullRequest) {
        PortablePreconditions.checkNotNull((String)"pullRequest", (Object)pullRequest);
        PortablePreconditions.checkNotNull((String)"id", (Object)pullRequest.getId());
        PortablePreconditions.checkNotEmpty((String)"targetRepository", (String)pullRequest.getTargetRepository());
        String repository = pullRequest.getTargetRepository();
        long id = pullRequest.getId();
        this.changePullRequestStatus(repository, id, PullRequestStatus.REJECTED);
        return this.getRepositoryMetadata(repository).getPullRequest(id);
    }

    public PullRequest closePullRequest(PullRequest pullRequest) {
        PortablePreconditions.checkNotNull((String)"pullRequest", (Object)pullRequest);
        PortablePreconditions.checkNotNull((String)"id", (Object)pullRequest.getId());
        PortablePreconditions.checkNotEmpty((String)"targetRepository", (String)pullRequest.getTargetRepository());
        String repository = pullRequest.getTargetRepository();
        long id = pullRequest.getId();
        this.changePullRequestStatus(repository, id, PullRequestStatus.CLOSED);
        return this.getRepositoryMetadata(repository).getPullRequest(id);
    }

    public List<PullRequest> getPullRequestsByBranch(Integer page, Integer pageSize, String repository, String branch) {
        GitMetadata metadata = this.getRepositoryMetadata(repository);
        List pullRequests = metadata.getPullRequests(elem -> elem.getTargetBranch().equals(branch));
        return this.paginate(page, pageSize, pullRequests);
    }

    public List<PullRequest> getPullRequestsByRepository(Integer page, Integer pageSize, String repository) {
        GitMetadata metadata = this.getRepositoryMetadata(repository);
        List pullRequests = metadata.getPullRequests();
        return this.paginate(page, pageSize, pullRequests);
    }

    public List<PullRequest> getPullRequestsByStatus(Integer page, Integer pageSize, String repository, PullRequestStatus status) {
        List<PullRequest> pullRequests = this.getPullRequestsByRepository(page, pageSize, repository);
        List<PullRequest> finalPullRequests = pullRequests.stream().filter(elem -> elem.getStatus().equals((Object)status)).collect(Collectors.toList());
        return this.paginate(page, pageSize, finalPullRequests);
    }

    public void deletePullRequest(PullRequest pullRequest) {
        PortablePreconditions.checkNotNull((String)"pullRequest", (Object)pullRequest);
        PortablePreconditions.checkNotNull((String)"id", (Object)pullRequest.getId());
        PortablePreconditions.checkNotEmpty((String)"targetRepository", (String)pullRequest.getTargetRepository());
        String repository = pullRequest.getTargetRepository();
        long id = pullRequest.getId();
        GitMetadata metadata = this.getRepositoryMetadata(repository);
        PullRequest removablePullRequest = metadata.getPullRequest(id);
        List finalPullRequests = metadata.getPullRequests();
        finalPullRequests.remove(removablePullRequest);
        GitMetadataImpl storableMetadata = new GitMetadataImpl(metadata.getName(), metadata.getOrigin(), metadata.getForks(), finalPullRequests);
        this.metadataStore.write(storableMetadata.getName(), (GitMetadata)storableMetadata);
        this.deleteHiddenBranch(removablePullRequest);
    }

    protected List<PullRequest> paginate(Integer page, Integer pageSize, List<PullRequest> pullRequests) {
        if (page == 0 && pageSize == 0) {
            return pullRequests;
        }
        Integer finalPageSize = pageSize == 0 ? 10 : pageSize;
        Map<Integer, List> map = IntStream.iterate(0, i -> i + finalPageSize).limit((pullRequests.size() + finalPageSize - 1) / finalPageSize).boxed().collect(Collectors.toMap(i -> i / finalPageSize, i -> pullRequests.subList((int)i, Integer.min(i + finalPageSize, pullRequests.size()))));
        return map.getOrDefault(page, new ArrayList());
    }

    public List<FileDiff> diff(PullRequest pullRequest) {
        Repository repository = this.configuredRepositories.getRepositoryByRepositoryAlias(pullRequest.getTargetRepository());
        this.createHiddenBranch(pullRequest);
        String diff = String.format("diff:%s,%s", pullRequest.getTargetBranch(), this.buildHiddenBranchName(pullRequest));
        List diffs = (List)((Object)this.ioService.readAttributes(Paths.convert((org.uberfire.backend.vfs.Path)repository.getRoot()), diff));
        this.deleteHiddenBranch(pullRequest);
        return diffs;
    }

    protected void changePullRequestStatus(String repository, long id, PullRequestStatus status) {
        PortablePreconditions.checkNotEmpty((String)"repository", (String)repository);
        PortablePreconditions.checkNotNull((String)"status", (Object)status);
        GitMetadata metadata = this.getRepositoryMetadata(repository);
        PullRequest pullRequest = metadata.getPullRequest(id);
        PullRequestImpl finalPullRequest = new PullRequestImpl(pullRequest.getId(), pullRequest.getSourceRepository(), pullRequest.getSourceBranch(), pullRequest.getTargetRepository(), pullRequest.getTargetBranch(), status);
        List finalPullRequests = metadata.getPullRequests(elem -> elem.getId() != id);
        finalPullRequests.add(finalPullRequest);
        GitMetadataImpl storableMetadata = new GitMetadataImpl(metadata.getName(), metadata.getOrigin(), metadata.getForks(), finalPullRequests);
        this.metadataStore.write(storableMetadata.getName(), (GitMetadata)storableMetadata);
    }

    private GitMetadata getRepositoryMetadata(String repository) {
        Optional optional = this.metadataStore.read(repository);
        if (!optional.isPresent()) {
            throw new RepositoryNotFoundException(String.format("The repository does not exists <<%s>>", repository));
        }
        return (GitMetadata)optional.get();
    }

    private synchronized long generatePullRequestId(GitMetadata metadata) {
        List pullRequests = metadata.getPullRequests();
        Optional last = pullRequests.stream().max((first, second) -> Long.compare(first.getId(), second.getId()));
        return last.map(pr -> pr.getId() + 1L).orElse(1L);
    }

    protected void createHiddenBranch(PullRequest pullRequest) {
        Path source = this.buildPath(pullRequest.getSourceRepository(), pullRequest.getSourceBranch());
        Path target = this.buildHiddenPath(pullRequest);
        this.ioService.copy(source, target, new CopyOption[0]);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Hidden branch {} created.", (Object)target.toString());
        }
    }

    private void mergePullRequest(PullRequest pullRequest) {
        Path source = this.buildHiddenPath(pullRequest);
        Path target = this.buildPath(pullRequest.getTargetRepository(), pullRequest.getTargetBranch());
        this.ioService.copy(source, target, new CopyOption[]{new MergeCopyOption()});
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Merged from <{}> to <{}>", (Object)source.toString(), (Object)target.toString());
        }
    }

    private void deleteHiddenBranch(PullRequest pullRequest) {
        Path path = this.buildHiddenPath(pullRequest);
        this.ioService.delete(path, new DeleteOption[0]);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Hidden branch {} deleted", (Object)pullRequest.toString());
        }
    }

    protected Path buildHiddenPath(PullRequest pullRequest) {
        String branchName = this.buildHiddenBranchName(pullRequest);
        return this.buildPath(pullRequest.getTargetRepository(), branchName);
    }

    private String buildHiddenBranchName(PullRequest pullRequest) {
        return String.format("PR-%s-%s/%s-%s", pullRequest.getId(), pullRequest.getSourceRepository(), pullRequest.getSourceBranch(), pullRequest.getTargetBranch());
    }

    protected Path buildPath(String repository, String branch) {
        return this.ioService.get(URI.create(String.format("git://%s@%s", branch, repository)));
    }
}

