/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.Path;

public class ConfiguredRepositoriesBySpace {
    private Map<String, Repository> repositoriesByAlias = Collections.synchronizedMap(new HashMap());
    private Map<Path, Repository> repositoriesByBranchRoot = Collections.synchronizedMap(new HashMap());

    public void clear() {
        this.repositoriesByAlias.clear();
        this.repositoriesByBranchRoot.clear();
    }

    public void add(Repository repository) {
        this.repositoriesByAlias.put(repository.getAlias(), repository);
        if (repository.getBranches() != null) {
            for (Branch branch : repository.getBranches()) {
                this.repositoriesByBranchRoot.put(Paths.normalizePath((Path)branch.getPath()), repository);
            }
        }
    }

    public Repository get(String alias) {
        return this.repositoriesByAlias.get(alias);
    }

    public Map<String, Repository> getRepositoriesByAlias() {
        return this.repositoriesByAlias;
    }

    public Repository get(Path root) {
        return this.repositoriesByBranchRoot.get(Paths.normalizePath((Path)root));
    }

    public boolean containsRepository(String alias) {
        return this.repositoriesByAlias.containsKey(alias);
    }

    Repository remove(String alias) {
        Repository removed = this.repositoriesByAlias.remove(alias);
        this.removeFromRootByAlias(alias);
        return removed;
    }

    void removeFromRootByAlias(String alias) {
        for (Path path : this.findFromRootMapByAlias(alias)) {
            this.repositoriesByBranchRoot.remove(path);
        }
    }

    private List<Path> findFromRootMapByAlias(String alias) {
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path path : this.repositoriesByBranchRoot.keySet()) {
            if (!this.repositoriesByBranchRoot.get(path).getAlias().equals(alias)) continue;
            result.add(path);
        }
        return result;
    }

    public Collection<Repository> getAllConfiguredRepositories() {
        return this.repositoriesByAlias.values();
    }
}

