/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.backend.repositories;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.guvnor.structure.backend.repositories.BranchAccessAuthorizer;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.changerequest.ChangeRequestPredicates;
import org.guvnor.structure.repositories.changerequest.ChangeRequestService;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequest;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestAlreadyOpenException;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestComment;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestCountSummary;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestDiff;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestListUpdatedEvent;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestStatus;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestStatusUpdatedEvent;
import org.guvnor.structure.repositories.changerequest.portable.ChangeRequestUpdatedEvent;
import org.guvnor.structure.repositories.changerequest.portable.ChangeType;
import org.guvnor.structure.repositories.changerequest.portable.NothingToMergeException;
import org.guvnor.structure.repositories.changerequest.portable.PaginatedChangeRequestCommentList;
import org.guvnor.structure.repositories.changerequest.portable.PaginatedChangeRequestList;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.java.nio.base.TextualDiff;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.fs.jgit.JGitFileSystem;
import org.uberfire.java.nio.fs.jgit.JGitPathImpl;
import org.uberfire.java.nio.fs.jgit.util.Git;
import org.uberfire.java.nio.fs.jgit.util.exceptions.GitException;
import org.uberfire.java.nio.fs.jgit.util.model.PathInfo;
import org.uberfire.java.nio.fs.jgit.ws.JGitWatchEvent;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.spaces.SpacesAPI;

@Service
@ApplicationScoped
public class ChangeRequestServiceImpl
implements ChangeRequestService {
    private static final String SPACE_NAME_PARAM = "spaceName";
    private static final String REPOSITORY_ALIAS_PARAM = "repositoryAlias";
    private static final String STATUS_LIST_PARAM = "statusList";
    private static final String CHANGE_REQUEST_ID_PARAM = "changeRequestId";
    private static final String PAGE_PARAM = "page";
    private static final String PAGE_SIZE_PARAM = "pageSize";
    private static final String SOURCE_BRANCH_PARAM = "sourceBranch";
    private static final String TARGET_BRANCH_PARAM = "targetBranch";
    private static final String SUMMARY_PARAM = "summary";
    private static final String DESCRIPTION_PARAM = "description";
    private static final String ASSOCIATED_BRANCH_NAME_PARAM = "associatedBranchName";
    private static final String TEXT_PARAM = "text";
    private static final String COMMENT_ID_PARAM = "commentId";
    private static final String UPDATED_SUMMARY_PARAM = "updatedSummary";
    private static final String UPDATED_DESCRIPTION_PARAM = "updatedDescription";
    private final SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    private final RepositoryService repositoryService;
    private final SpacesAPI spaces;
    private final Event<ChangeRequestListUpdatedEvent> changeRequestListUpdatedEvent;
    private final Event<ChangeRequestUpdatedEvent> changeRequestUpdatedEvent;
    private final Event<ChangeRequestStatusUpdatedEvent> changeRequestStatusUpdatedEventEvent;
    private final BranchAccessAuthorizer branchAccessAuthorizer;
    private final SessionInfo sessionInfo;
    private Logger logger = LoggerFactory.getLogger(ChangeRequestServiceImpl.class);

    @Inject
    public ChangeRequestServiceImpl(SpaceConfigStorageRegistry spaceConfigStorageRegistry, RepositoryService repositoryService, SpacesAPI spaces, Event<ChangeRequestListUpdatedEvent> changeRequestListUpdatedEvent, Event<ChangeRequestUpdatedEvent> changeRequestUpdatedEvent, Event<ChangeRequestStatusUpdatedEvent> changeRequestStatusUpdatedEventEvent, BranchAccessAuthorizer branchAccessAuthorizer, SessionInfo sessionInfo) {
        this.spaceConfigStorageRegistry = spaceConfigStorageRegistry;
        this.repositoryService = repositoryService;
        this.spaces = spaces;
        this.changeRequestListUpdatedEvent = changeRequestListUpdatedEvent;
        this.changeRequestUpdatedEvent = changeRequestUpdatedEvent;
        this.changeRequestStatusUpdatedEventEvent = changeRequestStatusUpdatedEventEvent;
        this.branchAccessAuthorizer = branchAccessAuthorizer;
        this.sessionInfo = sessionInfo;
    }

    public ChangeRequest createChangeRequest(String spaceName, String repositoryAlias, String sourceBranch, String targetBranch, String summary, String description) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotEmpty((String)SOURCE_BRANCH_PARAM, (String)sourceBranch);
        PortablePreconditions.checkNotEmpty((String)TARGET_BRANCH_PARAM, (String)targetBranch);
        PortablePreconditions.checkNotEmpty((String)SUMMARY_PARAM, (String)summary);
        PortablePreconditions.checkNotEmpty((String)DESCRIPTION_PARAM, (String)description);
        this.checkChangeRequestAlreadyOpen(spaceName, repositoryAlias, sourceBranch, targetBranch);
        Repository repository = this.resolveRepository(spaceName, repositoryAlias);
        long changeRequestId = this.generateChangeRequestId(spaceName, repositoryAlias);
        String startCommitId = this.getCommonCommitId(repository, sourceBranch, targetBranch);
        ChangeRequest newChangeRequest = new ChangeRequest(changeRequestId, spaceName, repositoryAlias, sourceBranch, targetBranch, this.sessionInfo.getIdentity().getIdentifier(), summary, description, startCommitId);
        this.spaceConfigStorageRegistry.get(spaceName).saveChangeRequest(repositoryAlias, newChangeRequest);
        this.changeRequestListUpdatedEvent.fire((Object)new ChangeRequestListUpdatedEvent(repository.getIdentifier()));
        return newChangeRequest;
    }

    public List<ChangeRequest> getChangeRequests(String spaceName, String repositoryAlias) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        List<ChangeRequest> changeRequests = this.getFilteredChangeRequestsFromStorage(spaceName, repositoryAlias, true, ChangeRequestPredicates.matchAll());
        return this.computeFullContent(spaceName, repositoryAlias, changeRequests);
    }

    public List<ChangeRequest> getChangeRequests(String spaceName, String repositoryAlias, String filter) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        List<ChangeRequest> changeRequests = this.getFilteredChangeRequestsFromStorage(spaceName, repositoryAlias, true, ChangeRequestPredicates.matchSearchFilter((String)filter, ChangeRequestServiceImpl::composeSearchableElement));
        return this.computeFullContent(spaceName, repositoryAlias, changeRequests);
    }

    public List<ChangeRequest> getChangeRequests(String spaceName, String repositoryAlias, List<ChangeRequestStatus> statusList) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotEmpty((String)STATUS_LIST_PARAM, statusList);
        List<ChangeRequest> changeRequests = this.getFilteredChangeRequestsFromStorage(spaceName, repositoryAlias, true, ChangeRequestPredicates.matchInStatusList(statusList));
        return this.computeFullContent(spaceName, repositoryAlias, changeRequests);
    }

    public List<ChangeRequest> getChangeRequests(String spaceName, String repositoryAlias, List<ChangeRequestStatus> statusList, String filter) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotEmpty((String)STATUS_LIST_PARAM, statusList);
        List<ChangeRequest> changeRequests = this.getFilteredChangeRequestsFromStorage(spaceName, repositoryAlias, true, ChangeRequestPredicates.matchSearchFilterAndStatusList((String)filter, ChangeRequestServiceImpl::composeSearchableElement, statusList));
        return this.computeFullContent(spaceName, repositoryAlias, changeRequests);
    }

    public PaginatedChangeRequestList getChangeRequests(String spaceName, String repositoryAlias, Integer page, Integer pageSize, String filter) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)PAGE_PARAM, (Object)page);
        PortablePreconditions.checkNotNull((String)PAGE_SIZE_PARAM, (Object)pageSize);
        List<ChangeRequest> changeRequests = this.getFilteredChangeRequestsFromStorage(spaceName, repositoryAlias, true, ChangeRequestPredicates.matchSearchFilter((String)filter, ChangeRequestServiceImpl::composeSearchableElement));
        List<ChangeRequest> paginatedChangeRequests = this.paginateChangeRequests(changeRequests, page, pageSize);
        return new PaginatedChangeRequestList(this.computeFullContent(spaceName, repositoryAlias, paginatedChangeRequests), page, pageSize, Integer.valueOf(changeRequests.size()));
    }

    public PaginatedChangeRequestList getChangeRequests(String spaceName, String repositoryAlias, Integer page, Integer pageSize, List<ChangeRequestStatus> statusList, String filter) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)PAGE_PARAM, (Object)page);
        PortablePreconditions.checkNotNull((String)PAGE_SIZE_PARAM, (Object)pageSize);
        PortablePreconditions.checkNotEmpty((String)STATUS_LIST_PARAM, statusList);
        List<ChangeRequest> changeRequests = this.getFilteredChangeRequestsFromStorage(spaceName, repositoryAlias, true, ChangeRequestPredicates.matchSearchFilterAndStatusList((String)filter, ChangeRequestServiceImpl::composeSearchableElement, statusList));
        List<ChangeRequest> paginatedChangeRequests = this.paginateChangeRequests(changeRequests, page, pageSize);
        return new PaginatedChangeRequestList(this.computeFullContent(spaceName, repositoryAlias, paginatedChangeRequests), page, pageSize, Integer.valueOf(changeRequests.size()));
    }

    public ChangeRequest getChangeRequest(String spaceName, String repositoryAlias, Long changeRequestId) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)CHANGE_REQUEST_ID_PARAM, (Object)changeRequestId);
        return this.getChangeRequestById(spaceName, repositoryAlias, true, changeRequestId);
    }

    public ChangeRequestCountSummary countChangeRequests(String spaceName, String repositoryAlias) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        List<ChangeRequest> changeRequests = this.getFilteredChangeRequestsFromStorage(spaceName, repositoryAlias, false, ChangeRequestPredicates.matchAll());
        Integer total = changeRequests.size();
        long open = changeRequests.stream().filter(elem -> elem.getStatus() == ChangeRequestStatus.OPEN).count();
        return new ChangeRequestCountSummary(total, Integer.valueOf((int)open));
    }

    public List<ChangeRequestDiff> getDiff(String spaceName, String repositoryAlias, String sourceBranch, String targetBranch) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)SOURCE_BRANCH_PARAM, (Object)sourceBranch);
        PortablePreconditions.checkNotNull((String)TARGET_BRANCH_PARAM, (Object)targetBranch);
        Repository repository = this.resolveRepository(spaceName, repositoryAlias);
        return this.getDiff(repository, sourceBranch, targetBranch, null, null);
    }

    public List<ChangeRequestDiff> getDiff(String spaceName, String repositoryAlias, Long changeRequestId) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)CHANGE_REQUEST_ID_PARAM, (Object)changeRequestId);
        Repository repository = this.resolveRepository(spaceName, repositoryAlias);
        ChangeRequest changeRequest = this.getChangeRequestById(spaceName, repositoryAlias, false, changeRequestId);
        return this.getDiff(repository, changeRequest.getSourceBranch(), changeRequest.getTargetBranch(), changeRequest.getStartCommitId(), changeRequest.getEndCommitId());
    }

    public void deleteChangeRequests(String spaceName, String repositoryAlias, String associatedBranchName) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotEmpty((String)ASSOCIATED_BRANCH_NAME_PARAM, (String)associatedBranchName);
        List<ChangeRequest> changeRequestsToDelete = this.getFilteredChangeRequestsFromStorage(spaceName, repositoryAlias, false, ChangeRequestPredicates.matchSourceOrTargetBranch((String)associatedBranchName));
        if (!changeRequestsToDelete.isEmpty()) {
            changeRequestsToDelete.forEach(elem -> this.spaceConfigStorageRegistry.get(spaceName).deleteChangeRequest(repositoryAlias, Long.valueOf(elem.getId())));
            Repository repository = this.resolveRepository(spaceName, repositoryAlias);
            this.changeRequestListUpdatedEvent.fire((Object)new ChangeRequestListUpdatedEvent(repository.getIdentifier()));
        }
    }

    public void rejectChangeRequest(String spaceName, String repositoryAlias, Long changeRequestId) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)CHANGE_REQUEST_ID_PARAM, (Object)changeRequestId);
        ChangeRequest changeRequest = this.getChangeRequestById(spaceName, repositoryAlias, false, changeRequestId);
        if (changeRequest.getStatus() != ChangeRequestStatus.OPEN) {
            throw new IllegalStateException("Cannot reject a change request that is not open");
        }
        this.updateNotMergedChangeRequestStatus(spaceName, repositoryAlias, changeRequest, ChangeRequestStatus.REJECTED);
    }

    public Boolean acceptChangeRequest(String spaceName, String repositoryAlias, Long changeRequestId) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)CHANGE_REQUEST_ID_PARAM, (Object)changeRequestId);
        ChangeRequest changeRequest = this.getChangeRequestById(spaceName, repositoryAlias, false, changeRequestId);
        if (changeRequest.getStatus() != ChangeRequestStatus.OPEN) {
            throw new IllegalStateException("Cannot accept a change request that is not open");
        }
        Repository repository = this.resolveRepository(spaceName, repositoryAlias);
        return this.tryMergeChangeRequest(repository, changeRequest);
    }

    public Boolean revertChangeRequest(String spaceName, String repositoryAlias, Long changeRequestId) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)CHANGE_REQUEST_ID_PARAM, (Object)changeRequestId);
        ChangeRequest changeRequest = this.getChangeRequestById(spaceName, repositoryAlias, false, changeRequestId);
        if (changeRequest.getStatus() != ChangeRequestStatus.ACCEPTED) {
            throw new IllegalStateException("Cannot revert a change request that is not accepted");
        }
        Repository repository = this.resolveRepository(spaceName, repositoryAlias);
        return this.tryRevertChangeRequest(repository, changeRequest);
    }

    public void closeChangeRequest(String spaceName, String repositoryAlias, Long changeRequestId) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)CHANGE_REQUEST_ID_PARAM, (Object)changeRequestId);
        ChangeRequest changeRequest = this.getChangeRequestById(spaceName, repositoryAlias, false, changeRequestId);
        if (changeRequest.getStatus() != ChangeRequestStatus.OPEN) {
            throw new IllegalStateException("Cannot close a change request that is not open");
        }
        this.updateNotMergedChangeRequestStatus(spaceName, repositoryAlias, changeRequest, ChangeRequestStatus.CLOSED);
    }

    public void reopenChangeRequest(String spaceName, String repositoryAlias, Long changeRequestId) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)CHANGE_REQUEST_ID_PARAM, (Object)changeRequestId);
        ChangeRequest changeRequest = this.getChangeRequestById(spaceName, repositoryAlias, false, changeRequestId);
        if (changeRequest.getStatus() != ChangeRequestStatus.CLOSED && changeRequest.getStatus() != ChangeRequestStatus.REJECTED) {
            throw new IllegalStateException("Cannot reopen a change request that is not closed/rejected");
        }
        this.checkChangeRequestAlreadyOpen(spaceName, repositoryAlias, changeRequest.getSourceBranch(), changeRequest.getTargetBranch());
        this.updateNotMergedChangeRequestStatus(spaceName, repositoryAlias, changeRequest, ChangeRequestStatus.OPEN);
    }

    public void updateChangeRequestSummary(String spaceName, String repositoryAlias, Long changeRequestId, String updatedSummary) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)CHANGE_REQUEST_ID_PARAM, (Object)changeRequestId);
        PortablePreconditions.checkNotEmpty((String)UPDATED_SUMMARY_PARAM, (String)updatedSummary);
        Repository repository = this.resolveRepository(spaceName, repositoryAlias);
        ChangeRequest oldChangeRequest = this.getChangeRequestById(spaceName, repositoryAlias, false, changeRequestId);
        ChangeRequest updatedChangeRequest = new ChangeRequest(oldChangeRequest.getId(), oldChangeRequest.getSpaceName(), oldChangeRequest.getRepositoryAlias(), oldChangeRequest.getSourceBranch(), oldChangeRequest.getTargetBranch(), oldChangeRequest.getStatus(), oldChangeRequest.getAuthorId(), updatedSummary, oldChangeRequest.getDescription(), oldChangeRequest.getCreatedDate(), oldChangeRequest.getStartCommitId(), oldChangeRequest.getEndCommitId(), oldChangeRequest.getMergeCommitId());
        this.spaceConfigStorageRegistry.get(spaceName).saveChangeRequest(repositoryAlias, updatedChangeRequest);
        this.changeRequestUpdatedEvent.fire((Object)new ChangeRequestUpdatedEvent(repository.getIdentifier(), Long.valueOf(updatedChangeRequest.getId()), this.sessionInfo.getIdentity().getIdentifier()));
    }

    public void updateChangeRequestDescription(String spaceName, String repositoryAlias, Long changeRequestId, String updatedDescription) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)CHANGE_REQUEST_ID_PARAM, (Object)changeRequestId);
        PortablePreconditions.checkNotEmpty((String)UPDATED_DESCRIPTION_PARAM, (String)updatedDescription);
        Repository repository = this.resolveRepository(spaceName, repositoryAlias);
        ChangeRequest oldChangeRequest = this.getChangeRequestById(spaceName, repositoryAlias, false, changeRequestId);
        ChangeRequest updatedChangeRequest = new ChangeRequest(oldChangeRequest.getId(), oldChangeRequest.getSpaceName(), oldChangeRequest.getRepositoryAlias(), oldChangeRequest.getSourceBranch(), oldChangeRequest.getTargetBranch(), oldChangeRequest.getStatus(), oldChangeRequest.getAuthorId(), oldChangeRequest.getSummary(), updatedDescription, oldChangeRequest.getCreatedDate(), oldChangeRequest.getStartCommitId(), oldChangeRequest.getEndCommitId(), oldChangeRequest.getMergeCommitId());
        this.spaceConfigStorageRegistry.get(spaceName).saveChangeRequest(repositoryAlias, updatedChangeRequest);
        this.changeRequestUpdatedEvent.fire((Object)new ChangeRequestUpdatedEvent(repository.getIdentifier(), Long.valueOf(updatedChangeRequest.getId()), this.sessionInfo.getIdentity().getIdentifier()));
    }

    public PaginatedChangeRequestCommentList getComments(String spaceName, String repositoryAlias, Long changeRequestId, Integer page, Integer pageSize) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)CHANGE_REQUEST_ID_PARAM, (Object)changeRequestId);
        List<ChangeRequestComment> comments = this.spaceConfigStorageRegistry.get(spaceName).loadChangeRequestComments(repositoryAlias, changeRequestId).stream().sorted(Comparator.comparing(ChangeRequestComment::getCreatedDate).reversed()).collect(Collectors.toList());
        List<ChangeRequestComment> paginatedList = this.paginateComments(comments, page, pageSize);
        return new PaginatedChangeRequestCommentList(paginatedList, page, pageSize, Integer.valueOf(comments.size()));
    }

    public void addComment(String spaceName, String repositoryAlias, Long changeRequestId, String text) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)CHANGE_REQUEST_ID_PARAM, (Object)changeRequestId);
        PortablePreconditions.checkNotEmpty((String)TEXT_PARAM, (String)text);
        Repository repository = this.resolveRepository(spaceName, repositoryAlias);
        Long commentId = this.generateCommentId(spaceName, repositoryAlias, changeRequestId);
        ChangeRequestComment newComment = new ChangeRequestComment(commentId, this.sessionInfo.getIdentity().getIdentifier(), new Date(), text);
        this.spaceConfigStorageRegistry.get(spaceName).saveChangeRequestComment(repositoryAlias, changeRequestId, newComment);
        this.changeRequestUpdatedEvent.fire((Object)new ChangeRequestUpdatedEvent(repository.getIdentifier(), changeRequestId, this.sessionInfo.getIdentity().getIdentifier()));
    }

    public void deleteComment(String spaceName, String repositoryAlias, Long changeRequestId, Long commentId) {
        PortablePreconditions.checkNotEmpty((String)SPACE_NAME_PARAM, (String)spaceName);
        PortablePreconditions.checkNotEmpty((String)REPOSITORY_ALIAS_PARAM, (String)repositoryAlias);
        PortablePreconditions.checkNotNull((String)CHANGE_REQUEST_ID_PARAM, (Object)changeRequestId);
        PortablePreconditions.checkNotNull((String)COMMENT_ID_PARAM, (Object)commentId);
        Repository repository = this.resolveRepository(spaceName, repositoryAlias);
        this.spaceConfigStorageRegistry.get(spaceName).deleteChangeRequestComment(repositoryAlias, changeRequestId, commentId);
        this.changeRequestUpdatedEvent.fire((Object)new ChangeRequestUpdatedEvent(repository.getIdentifier(), changeRequestId, this.sessionInfo.getIdentity().getIdentifier()));
    }

    private ChangeRequest getChangeRequestById(String spaceName, String repositoryAlias, boolean withFullContent, Long changeRequestId) {
        List<ChangeRequest> changeRequests = this.getFilteredChangeRequestsFromStorage(spaceName, repositoryAlias, false, ChangeRequestPredicates.matchId((Long)changeRequestId));
        if (changeRequests.isEmpty()) {
            throw new NoSuchElementException("Unable to find the change request with id #" + changeRequestId);
        }
        return withFullContent ? this.computeFullContent(spaceName, repositoryAlias, changeRequests).get(0) : changeRequests.get(0);
    }

    private org.uberfire.backend.vfs.Path createPath(String branchPath, String filePath) {
        return PathFactory.newPath((String)filePath, (String)(branchPath + filePath));
    }

    private Repository resolveRepository(String spaceName, String repositoryAlias) {
        Repository repository = this.repositoryService.getRepositoryFromSpace(this.spaces.getSpace(spaceName), repositoryAlias);
        if (repository == null) {
            String msg = String.format("The repository %s was not found in the space %s", repositoryAlias, spaceName);
            throw new NoSuchElementException(msg);
        }
        return repository;
    }

    private List<ChangeRequest> getFilteredChangeRequestsFromStorage(String spaceName, String repositoryAlias, boolean sorted, Predicate<ChangeRequest> predicate) {
        Repository repository = this.resolveRepository(spaceName, repositoryAlias);
        List branchesUserCanRead = repository.getBranches().stream().map(Branch::getName).filter(branchName -> this.branchAccessAuthorizer.authorize(this.sessionInfo.getIdentity().getIdentifier(), repository.getSpace().getName(), repository.getIdentifier(), repository.getAlias(), (String)branchName, BranchAccessAuthorizer.AccessType.READ)).collect(Collectors.toList());
        Stream changeRequestStream = this.spaceConfigStorageRegistry.get(spaceName).loadChangeRequests(repositoryAlias).stream().filter(ChangeRequestPredicates.matchTargetBranchListAndOtherPredicate(branchesUserCanRead, predicate));
        if (sorted) {
            return changeRequestStream.sorted(Comparator.comparing(ChangeRequest::getCreatedDate).reversed()).collect(Collectors.toList());
        }
        return changeRequestStream.collect(Collectors.toList());
    }

    private List<ChangeRequest> computeFullContent(String spaceName, String repositoryAlias, List<ChangeRequest> changeRequests) {
        Repository repository = this.resolveRepository(spaceName, repositoryAlias);
        return changeRequests.stream().map(elem -> {
            int changedFilesCount = this.countChangeRequestDiffs(repository, (ChangeRequest)elem);
            int commentsCount = this.countChangeRequestComments(spaceName, repositoryAlias, elem.getId());
            boolean hasConflicts = !this.isChangeRequestConflictFree(repository, (ChangeRequest)elem);
            return new ChangeRequest(Long.valueOf(elem.getId()), elem.getSpaceName(), elem.getRepositoryAlias(), elem.getSourceBranch(), elem.getTargetBranch(), elem.getStatus(), elem.getAuthorId(), elem.getSummary(), elem.getDescription(), elem.getCreatedDate(), Integer.valueOf(changedFilesCount), Integer.valueOf(commentsCount), elem.getStartCommitId(), elem.getEndCommitId(), elem.getMergeCommitId(), Boolean.valueOf(hasConflicts));
        }).collect(Collectors.toList());
    }

    private static String composeSearchableElement(ChangeRequest element) {
        return element.toString().toLowerCase();
    }

    private List<ChangeRequest> paginateChangeRequests(List<ChangeRequest> changeRequests, Integer page, Integer pageSize) {
        if (page == 0 && pageSize == 0) {
            return changeRequests;
        }
        Map<Integer, List> map = IntStream.iterate(0, i -> i + pageSize).limit((changeRequests.size() + pageSize - 1) / pageSize).boxed().collect(Collectors.toMap(i -> i / pageSize, i -> changeRequests.subList((int)i, Integer.min(i + pageSize, changeRequests.size()))));
        ArrayList<ChangeRequest> paginatedChangeRequests = new ArrayList<ChangeRequest>();
        if (map.containsKey(page)) {
            paginatedChangeRequests.addAll(map.get(page));
        }
        return paginatedChangeRequests;
    }

    private Integer countChangeRequestComments(String spaceName, String repositoryAlias, Long changeRequestId) {
        return this.spaceConfigStorageRegistry.get(spaceName).getChangeRequestCommentIds(repositoryAlias, changeRequestId).size();
    }

    private List<ChangeRequestComment> paginateComments(List<ChangeRequestComment> comments, Integer page, Integer pageSize) {
        if (page == 0 && pageSize == 0) {
            return comments;
        }
        Map<Integer, List> map = IntStream.iterate(0, i -> i + pageSize).limit((comments.size() + pageSize - 1) / pageSize).boxed().collect(Collectors.toMap(i -> i / pageSize, i -> comments.subList((int)i, Integer.min(i + pageSize, comments.size()))));
        ArrayList<ChangeRequestComment> paginatedComments = new ArrayList<ChangeRequestComment>();
        if (map.containsKey(page)) {
            paginatedComments.addAll(map.get(page));
        }
        return paginatedComments;
    }

    private long generateChangeRequestId(String spaceName, String repositoryAlias) {
        Optional maxId = this.spaceConfigStorageRegistry.get(spaceName).getChangeRequestIds(repositoryAlias).stream().max(Long::compare);
        return maxId.orElse(0L) + 1L;
    }

    private long generateCommentId(String spaceName, String repositoryAlias, Long changeRequestId) {
        Optional maxId = this.spaceConfigStorageRegistry.get(spaceName).getChangeRequestCommentIds(repositoryAlias, changeRequestId).stream().max(Long::compare);
        return maxId.orElse(0L) + 1L;
    }

    private void updateNotMergedChangeRequestStatus(String spaceName, String repositoryAlias, ChangeRequest oldChangeRequest, ChangeRequestStatus status) {
        this.updateChangeRequestStatus(spaceName, repositoryAlias, oldChangeRequest, status, null);
    }

    private void updateChangeRequestStatus(String spaceName, String repositoryAlias, ChangeRequest oldChangeRequest, ChangeRequestStatus status, String mergeCommitId) {
        if (mergeCommitId == null && status == ChangeRequestStatus.ACCEPTED) {
            throw new IllegalStateException("Must have a merge commit id to update change request to ACCEPTED.");
        }
        Repository repository = this.resolveRepository(spaceName, repositoryAlias);
        String startCommitId = this.resolveStartCommitIdOnStatusUpdated(repository, oldChangeRequest, status);
        String endCommitId = this.resolveEndCommitIdOnStatusUpdated(repository, oldChangeRequest, status);
        ChangeRequest updatedChangeRequest = new ChangeRequest(oldChangeRequest.getId(), oldChangeRequest.getSpaceName(), oldChangeRequest.getRepositoryAlias(), oldChangeRequest.getSourceBranch(), oldChangeRequest.getTargetBranch(), status, oldChangeRequest.getAuthorId(), oldChangeRequest.getSummary(), oldChangeRequest.getDescription(), oldChangeRequest.getCreatedDate(), startCommitId, endCommitId, mergeCommitId);
        this.spaceConfigStorageRegistry.get(spaceName).saveChangeRequest(repositoryAlias, updatedChangeRequest);
        this.changeRequestStatusUpdatedEventEvent.fire((Object)new ChangeRequestStatusUpdatedEvent(repository.getIdentifier(), Long.valueOf(updatedChangeRequest.getId()), oldChangeRequest.getStatus(), status, this.sessionInfo.getIdentity().getIdentifier()));
    }

    private String resolveStartCommitIdOnStatusUpdated(Repository repository, ChangeRequest changeRequest, ChangeRequestStatus newStatus) {
        if (newStatus == ChangeRequestStatus.OPEN) {
            return this.getCommonCommitId(repository, changeRequest.getSourceBranch(), changeRequest.getTargetBranch());
        }
        return changeRequest.getStartCommitId();
    }

    private String resolveEndCommitIdOnStatusUpdated(Repository repository, ChangeRequest changeRequest, ChangeRequestStatus newStatus) {
        if (newStatus == ChangeRequestStatus.OPEN) {
            return null;
        }
        if (changeRequest.getStatus() == ChangeRequestStatus.OPEN) {
            return this.getLastCommitId(repository, changeRequest.getSourceBranch());
        }
        return changeRequest.getEndCommitId();
    }

    private List<ChangeRequestDiff> getDiff(Repository repository, String sourceBranchName, String targetBranchName, String startCommitId, String lastCommitId) {
        Branch sourceBranch = this.resolveBranch(repository, sourceBranchName);
        Branch targetBranch = this.resolveBranch(repository, targetBranchName);
        List<String> conflicts = this.getConflicts(repository, sourceBranchName, targetBranchName);
        return this.getTextualDiff(repository, sourceBranchName, targetBranchName, startCommitId, lastCommitId).stream().sorted(Comparator.comparing(TextualDiff::getChangeType)).map(textualDiff -> new ChangeRequestDiff(this.createPath(sourceBranch.getPath().toURI(), textualDiff.getOldFilePath()), this.createPath(targetBranch.getPath().toURI(), textualDiff.getNewFilePath()), ChangeType.valueOf((String)textualDiff.getChangeType()), Integer.valueOf(textualDiff.getLinesAdded()), Integer.valueOf(textualDiff.getLinesDeleted()), textualDiff.getDiffText(), Boolean.valueOf(conflicts.contains(textualDiff.getOldFilePath()) || conflicts.contains(textualDiff.getNewFilePath())))).collect(Collectors.toList());
    }

    private Branch resolveBranch(Repository repository, String branchName) {
        return (Branch)repository.getBranch(branchName).orElseThrow(() -> new IllegalStateException("The branch " + branchName + " does not exist"));
    }

    private int countChangeRequestDiffs(Repository repository, ChangeRequest changeRequest) {
        return this.getDiffEntries(repository, changeRequest.getSourceBranch(), changeRequest.getTargetBranch(), changeRequest.getStartCommitId(), changeRequest.getEndCommitId()).size();
    }

    private boolean isChangeRequestConflictFree(Repository repository, ChangeRequest changeRequest) {
        return this.getConflicts(repository, changeRequest.getSourceBranch(), changeRequest.getTargetBranch()).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryMergeChangeRequest(Repository repository, ChangeRequest changeRequest) {
        String sourceBranchName = changeRequest.getSourceBranch();
        String targetBranchName = changeRequest.getTargetBranch();
        JGitFileSystem fs = this.getFileSystemFromBranch(repository, targetBranchName);
        boolean isDone = false;
        try {
            fs.lock();
            ArrayList mergeCommitIds = new ArrayList(fs.getGit().merge(sourceBranchName, targetBranchName, true));
            if (mergeCommitIds.isEmpty()) {
                throw new NothingToMergeException();
            }
            RevCommit mergeCommit = this.getLastCommit(repository, targetBranchName);
            String mergeCommitId = mergeCommit.getName();
            List<DiffEntry> changesToNotify = this.getDiffEntries(repository, changeRequest.getSourceBranch(), changeRequest.getTargetBranch(), changeRequest.getStartCommitId(), changeRequest.getEndCommitId());
            this.notifyFileChanges(fs, targetBranchName, changesToNotify, this.getFullCommitMessage(mergeCommit));
            this.updateChangeRequestStatus(repository.getSpace().getName(), repository.getAlias(), changeRequest, ChangeRequestStatus.ACCEPTED, mergeCommitId);
            isDone = true;
        }
        catch (GitException e) {
            this.logger.debug(String.format("Cannot merge change request %s: %s", new Object[]{changeRequest.getId(), e}));
        }
        finally {
            fs.unlock();
        }
        return isDone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryRevertChangeRequest(Repository repository, ChangeRequest changeRequest) {
        boolean isDone = false;
        String sourceBranchName = changeRequest.getSourceBranch();
        String targetBranchName = changeRequest.getTargetBranch();
        JGitFileSystem fs = this.getFileSystemFromBranch(repository, targetBranchName);
        try {
            fs.lock();
            String beforeRevertCommitId = this.getLastCommitId(repository, targetBranchName);
            isDone = fs.getGit().revertMerge(sourceBranchName, targetBranchName, changeRequest.getStartCommitId(), changeRequest.getMergeCommitId());
            if (isDone) {
                RevCommit revertCommit = this.getLastCommit(repository, targetBranchName);
                List<DiffEntry> changesToNotify = this.getDiffEntries(repository, targetBranchName, targetBranchName, beforeRevertCommitId, revertCommit.getName());
                this.notifyFileChanges(fs, targetBranchName, changesToNotify, this.getFullCommitMessage(revertCommit));
            }
        }
        catch (GitException e) {
            this.logger.debug(String.format("Failed to revert change request #%s: %s.", new Object[]{changeRequest.getId(), e}));
        }
        finally {
            fs.unlock();
        }
        this.updateNotMergedChangeRequestStatus(repository.getSpace().getName(), repository.getAlias(), changeRequest, isDone ? ChangeRequestStatus.REVERTED : ChangeRequestStatus.REVERT_FAILED);
        return isDone;
    }

    private void checkChangeRequestAlreadyOpen(String spaceName, String repositoryAlias, String sourceBranchName, String targetBranchName) {
        List<ChangeRequest> changeRequests = this.getFilteredChangeRequestsFromStorage(spaceName, repositoryAlias, false, ChangeRequestPredicates.matchSourceAndTargetAndStatus((String)sourceBranchName, (String)targetBranchName, (ChangeRequestStatus)ChangeRequestStatus.OPEN));
        if (!changeRequests.isEmpty()) {
            throw new ChangeRequestAlreadyOpenException(Long.valueOf(changeRequests.get(0).getId()));
        }
    }

    private void notifyFileChanges(JGitFileSystem fs, String targetBranchName, List<DiffEntry> changesToNotify, String message) {
        String rootPath = "/";
        String host = targetBranchName + "@" + fs.getName();
        Function<String, Path> createPathFn = pathStr -> {
            PathInfo pathInfo = fs.getGit().getPathInfo(targetBranchName, pathStr);
            return !pathStr.equals("/dev/null") ? this.createJGitPathImpl(fs, "/" + pathInfo.getPath(), host, pathInfo.getObjectId(), false) : null;
        };
        List watchEvents = changesToNotify.stream().map(entry -> new JGitWatchEvent(this.sessionInfo.getId(), this.sessionInfo.getIdentity().getIdentifier(), message, entry.getChangeType().toString(), (Path)createPathFn.apply(entry.getOldPath()), (Path)createPathFn.apply(entry.getNewPath()))).collect(Collectors.toList());
        if (!watchEvents.isEmpty()) {
            JGitPathImpl root = JGitPathImpl.createRoot((JGitFileSystem)fs, (String)"/", (String)host, (boolean)false);
            fs.publishEvents((Path)root, watchEvents);
        }
    }

    private RevCommit getLastCommit(Repository repository, String branchName) {
        Git git = this.getGitFromBranch(repository, branchName);
        RevCommit lastCommit = git.getLastCommit(branchName);
        if (lastCommit != null) {
            return lastCommit;
        }
        throw new IllegalStateException("The branch " + branchName + " does not have a last commit");
    }

    private String getLastCommitId(Repository repository, String branchName) {
        return this.getLastCommit(repository, branchName).getName();
    }

    private String getCommonCommitId(Repository repository, String sourceBranchName, String targetBranchName) {
        Git git = this.getGitFromBranch(repository, sourceBranchName);
        try {
            return git.getCommonAncestorCommit(sourceBranchName, targetBranchName).getName();
        }
        catch (GitException e) {
            this.logger.error(String.format("Failed to get common commit for branches %s and %s: %s", new Object[]{sourceBranchName, targetBranchName, e}));
            throw new IllegalStateException(String.format("Branches %s and %s do not have a common ancestor commit", sourceBranchName, targetBranchName));
        }
    }

    private List<TextualDiff> getTextualDiff(Repository repository, String sourceBranchName, String targetBranchName, String startCommitId, String endCommitId) {
        Optional sourceBranch = repository.getBranch(sourceBranchName);
        Optional targetBranch = repository.getBranch(targetBranchName);
        if (sourceBranch.isPresent() && targetBranch.isPresent()) {
            Git git = this.getGitFromBranch(repository, sourceBranchName);
            return git.textualDiffRefs(targetBranchName, sourceBranchName, startCommitId, endCommitId);
        }
        return Collections.emptyList();
    }

    private List<DiffEntry> getDiffEntries(Repository repository, String sourceBranchName, String targetBranchName, String startCommitId, String endCommitId) {
        Optional sourceBranch = repository.getBranch(sourceBranchName);
        Optional targetBranch = repository.getBranch(targetBranchName);
        if (sourceBranch.isPresent() && targetBranch.isPresent()) {
            Git git = this.getGitFromBranch(repository, sourceBranchName);
            return git.listDiffs(startCommitId, endCommitId != null ? endCommitId : this.getLastCommitId(repository, sourceBranchName));
        }
        return Collections.emptyList();
    }

    private List<String> getConflicts(Repository repository, String sourceBranchName, String targetBranchName) {
        Optional sourceBranch = repository.getBranch(sourceBranchName);
        Optional targetBranch = repository.getBranch(targetBranchName);
        if (sourceBranch.isPresent() && targetBranch.isPresent()) {
            Git git = this.getGitFromBranch(repository, sourceBranchName);
            return git.conflictBranchesChecker(targetBranchName, sourceBranchName);
        }
        return Collections.emptyList();
    }

    private Git getGitFromBranch(Repository repository, String branchName) {
        return this.getFileSystemFromBranch(repository, branchName).getGit();
    }

    String getFullCommitMessage(RevCommit commit) {
        return commit.getFullMessage();
    }

    JGitFileSystem getFileSystemFromBranch(Repository repository, String branchName) {
        Branch branch = this.resolveBranch(repository, branchName);
        return (JGitFileSystem)((JGitPathImpl)Paths.convert((org.uberfire.backend.vfs.Path)branch.getPath())).getFileSystem();
    }

    JGitPathImpl createJGitPathImpl(JGitFileSystem fs, String path, String host, ObjectId objectId, boolean isRealPath) {
        return JGitPathImpl.create((JGitFileSystem)fs, (String)path, (String)host, (ObjectId)objectId, (boolean)isRealPath);
    }
}

