/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.repository.edit;

import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.client.security.ProjectController;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.structure.client.resources.i18n.CommonConstants;
import org.guvnor.structure.repositories.PublicURI;
import org.guvnor.structure.repositories.RepositoryInfo;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.RepositoryServiceEditor;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.core.client.resources.i18n.CoreConstants;
import org.uberfire.java.nio.base.version.VersionRecord;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.spaces.Space;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@WorkbenchScreen(identifier="RepositoryEditor")
public class RepositoryEditorPresenter {
    private View view;
    private Caller<RepositoryService> repositoryService;
    private Caller<WorkspaceProjectService> projectService;
    private Caller<RepositoryServiceEditor> repositoryServiceEditor;
    private Event<NotificationEvent> notification;
    private PlaceManager placeManager;
    private ProjectController projectController;
    private String alias = null;
    private Path root = null;
    private PlaceRequest place;
    private WorkspaceProjectContext context;

    public RepositoryEditorPresenter() {
    }

    @Inject
    public RepositoryEditorPresenter(View view, Caller<RepositoryService> repositoryService, Caller<WorkspaceProjectService> projectService, Caller<RepositoryServiceEditor> repositoryServiceEditor, Event<NotificationEvent> notification, PlaceManager placeManager, ProjectController projectController, WorkspaceProjectContext context) {
        this.view = view;
        this.repositoryService = repositoryService;
        this.projectService = projectService;
        this.repositoryServiceEditor = repositoryServiceEditor;
        this.notification = notification;
        this.placeManager = placeManager;
        this.projectController = projectController;
        this.context = context;
    }

    @OnStartup
    public void onStartup(PlaceRequest place) {
        this.place = place;
        this.alias = (String)place.getParameters().get("alias");
        String ouName = this.context.getActiveOrganizationalUnit().map(ou -> ou.getName()).orElseThrow(() -> new IllegalStateException("Cannot lookup repository [" + this.alias + "] without active organizational unit."));
        ((RepositoryService)this.repositoryService.call((RemoteCallback)new RemoteCallback<RepositoryInfo>(){

            public void callback(final RepositoryInfo repo) {
                ((WorkspaceProjectService)RepositoryEditorPresenter.this.projectService.call((RemoteCallback)new RemoteCallback<WorkspaceProject>(){

                    public void callback(WorkspaceProject workspaceProject) {
                        RepositoryEditorPresenter.this.root = repo.getRoot();
                        RepositoryEditorPresenter.this.view.setRepositoryInfo(repo.getAlias(), repo.getOwner(), !RepositoryEditorPresenter.this.projectController.canUpdateProject(workspaceProject), repo.getPublicURIs(), CoreConstants.INSTANCE.Empty(), repo.getInitialVersionList());
                    }
                })).resolveProjectByRepositoryAlias(new Space(repo.getOwner()), repo.getAlias());
            }
        })).getRepositoryInfo(new Space(ouName), this.alias);
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return CoreConstants.INSTANCE.RepositoryEditor() + " [" + this.alias + "]";
    }

    @WorkbenchPartView
    public UberView<RepositoryEditorPresenter> getView() {
        return this.view;
    }

    void onLoadMoreHistory(int lastIndex) {
        String ouName = this.context.getActiveOrganizationalUnit().map(ou -> ou.getName()).orElseThrow(() -> new IllegalStateException("Cannot lookup repository [" + this.alias + "] without active organizational unit."));
        ((RepositoryService)this.repositoryService.call((RemoteCallback)new RemoteCallback<List<VersionRecord>>(){

            public void callback(List<VersionRecord> versionList) {
                RepositoryEditorPresenter.this.view.addHistory(versionList);
            }
        })).getRepositoryHistory(new Space(ouName), this.alias, lastIndex);
    }

    void onRevert(VersionRecord record) {
        this.onRevert(record, null);
    }

    void onRevert(VersionRecord record, String comment) {
        ((RepositoryServiceEditor)this.repositoryServiceEditor.call((RemoteCallback)new RemoteCallback<List<VersionRecord>>(){

            public void callback(List<VersionRecord> content) {
                RepositoryEditorPresenter.this.view.reloadHistory(content);
            }
        })).revertHistory(this.alias, this.root, comment, record);
    }

    void onGitUrlCopied(String uri) {
        this.notification.fire((Object)new NotificationEvent(CommonConstants.INSTANCE.GitUriCopied(uri)));
    }

    public void onRepositoryRemovedEvent(@Observes RepositoryRemovedEvent event) {
        if (this.alias.equals(event.getRepository().getAlias())) {
            this.placeManager.closePlace(this.place);
        }
    }

    public static interface View
    extends UberView<RepositoryEditorPresenter> {
        public void setRepositoryInfo(String var1, String var2, boolean var3, List<PublicURI> var4, String var5, List<VersionRecord> var6);

        public void reloadHistory(List<VersionRecord> var1);

        public void addHistory(List<VersionRecord> var1);
    }
}

