/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.security;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.security.RepositoryAction;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.ResourceType;
import org.uberfire.security.authz.AuthorizationManager;

@ApplicationScoped
public class RepositoryController {
    public static final String REPOSITORY_TYPE = "repository";
    public static final String REPOSITORY_CREATE = "create";
    public static final String REPOSITORY_READ = "read";
    public static final String REPOSITORY_UPDATE = "update";
    public static final String REPOSITORY_DELETE = "delete";
    private AuthorizationManager authorizationManager;
    private User user;

    @Inject
    public RepositoryController(AuthorizationManager authorizationManager, User user) {
        this.authorizationManager = authorizationManager;
        this.user = user;
    }

    public boolean canCreateRepositories() {
        return this.authorizationManager.authorize((ResourceType)Repository.RESOURCE_TYPE, (ResourceAction)RepositoryAction.CREATE, this.user);
    }

    public boolean canReadRepositories() {
        return this.authorizationManager.authorize((ResourceType)Repository.RESOURCE_TYPE, RepositoryAction.READ, this.user);
    }

    public boolean canReadRepository(Repository repository) {
        return this.authorizationManager.authorize((Resource)repository, RepositoryAction.READ, this.user);
    }

    public boolean canUpdateRepository(String repoId) {
        return this.authorizationManager.authorize((Resource)new ResourceRef(repoId, (ResourceType)Repository.RESOURCE_TYPE), (ResourceAction)RepositoryAction.UPDATE, this.user);
    }

    public boolean canUpdateRepository(Repository repository) {
        return this.authorizationManager.authorize((Resource)repository, (ResourceAction)RepositoryAction.UPDATE, this.user);
    }

    public boolean canDeleteRepository(Repository repository) {
        return this.authorizationManager.authorize((Resource)repository, (ResourceAction)RepositoryAction.DELETE, this.user);
    }
}

