/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.promise;

import elemental2.promise.IThenable;
import elemental2.promise.Promise;
import org.uberfire.client.promise.Promises;

public class SyncPromises
extends Promises {
    public <T> Promise<T> create(Promise.PromiseExecutorCallbackFn<T> executor) {
        return new SyncPromise(executor);
    }

    public static enum Status {
        PENDING,
        RESOLVED,
        REJECTED;

    }

    public static class SyncPromise<T>
    extends Promise<T> {
        public Status status = Status.PENDING;
        public T value;

        private SyncPromise(Promise.PromiseExecutorCallbackFn<T> executor) {
            super(executor);
            executor.onInvoke((Promise.PromiseExecutorCallbackFn.ResolveCallbackFn)new Resolver(), (Promise.PromiseExecutorCallbackFn.RejectCallbackFn)new Rejecter());
        }

        public <V> Promise<V> then(IThenable.ThenOnFulfilledCallbackFn<? super T, ? extends V> onFulfilled) {
            try {
                if (this.status == Status.RESOLVED) {
                    return (SyncPromise)onFulfilled.onInvoke(this.value);
                }
                return new SyncPromise<T>((res, rej) -> rej.onInvoke(this.value));
            }
            catch (Exception e) {
                return new SyncPromise<T>((res, rej) -> rej.onInvoke((Object)e));
            }
        }

        public <V> Promise<V> catch_(Promise.CatchOnRejectedCallbackFn<? extends V> onRejected) {
            try {
                if (this.status == Status.REJECTED) {
                    return (SyncPromise)onRejected.onInvoke(this.value);
                }
                return new SyncPromise<T>((res, rej) -> res.onInvoke(this.value));
            }
            catch (Exception e) {
                return new SyncPromise<T>((res, rej) -> rej.onInvoke((Object)e));
            }
        }

        private class Rejecter
        implements Promise.PromiseExecutorCallbackFn.RejectCallbackFn {
            private Rejecter() {
            }

            public void onInvoke(Object error) {
                SyncPromise.this.value = error;
                SyncPromise.this.status = Status.REJECTED;
            }
        }

        private class Resolver
        implements Promise.PromiseExecutorCallbackFn.ResolveCallbackFn<T> {
            private Resolver() {
            }

            public void onInvoke(T value) {
                this.resolve(value);
            }

            public void onInvoke(IThenable<T> thenable) {
                if (thenable == null) {
                    SyncPromise.this.value = null;
                } else {
                    thenable.then(v -> {
                        SyncPromise.this.value = v;
                        return SyncPromise.resolve((Object)v);
                    });
                }
                SyncPromise.this.status = Status.RESOLVED;
            }

            public void onInvoke(Promise.PromiseExecutorCallbackFn.ResolveCallbackFn.ResolveUnionType<T> value) {
                throw new RuntimeException("Not supported");
            }

            private void resolve(T v) {
                SyncPromise.this.value = v;
                SyncPromise.this.status = Status.RESOLVED;
            }
        }
    }
}

