/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.promise;

import elemental2.promise.IThenable;
import elemental2.promise.Promise;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.promise.SyncPromises;

public class SyncPromisesTest {
    private final SyncPromises promises = new SyncPromises();

    @Test
    public void testBasicChaining() {
        Promise p = this.promises.resolve((Object)"a").then(a -> {
            Assert.assertTrue((boolean)"a".equals(a));
            return this.promises.resolve((Object)"b");
        }).then(b -> {
            Assert.assertTrue((boolean)"b".equals(b));
            return this.promises.resolve((Object)2);
        }).catch_(err -> {
            Assert.fail((String)"Catch should've not been called");
            return this.promises.resolve((Object)5);
        }).then(two -> {
            Assert.assertTrue((two == 2 ? 1 : 0) != 0);
            return this.promises.resolve((Object)3);
        });
        SyncPromises.SyncPromise sp = (SyncPromises.SyncPromise)p;
        Assert.assertTrue(((Integer)sp.value == 3 ? 1 : 0) != 0);
        Assert.assertTrue((sp.status == SyncPromises.Status.RESOLVED ? 1 : 0) != 0);
    }

    @Test
    public void testErrorHandling() {
        Promise p = this.promises.resolve((Object)"a").then(a -> {
            Assert.assertTrue((boolean)"a".equals(a));
            return this.promises.reject((Object)"b");
        }).then(b -> {
            Assert.fail((String)"This 'then' should've been jumped over");
            return this.promises.resolve((Object)2);
        }).catch_(err -> {
            Assert.assertTrue(("b" == err ? 1 : 0) != 0);
            return this.promises.resolve((Object)5);
        }).then(five -> {
            Assert.assertTrue((five == 5 ? 1 : 0) != 0);
            return this.promises.reject((Object)8L);
        });
        SyncPromises.SyncPromise sp = (SyncPromises.SyncPromise)p;
        Assert.assertTrue(((Long)sp.value == 8L ? 1 : 0) != 0);
        Assert.assertTrue((sp.status == SyncPromises.Status.REJECTED ? 1 : 0) != 0);
    }

    @Test
    public void testErrorHandlingDoubleRejection() {
        Promise p = this.promises.resolve((Object)"a").then(a -> {
            Assert.assertTrue((boolean)"a".equals(a));
            return this.promises.reject((Object)"b");
        }).catch_(err -> {
            Assert.assertTrue(("b" == err ? 1 : 0) != 0);
            return this.promises.reject((Object)Character.valueOf('4'));
        }).catch_(four -> {
            Assert.assertTrue((boolean)four.equals(Character.valueOf('4')));
            return this.promises.resolve((Object)12);
        });
        SyncPromises.SyncPromise sp = (SyncPromises.SyncPromise)p;
        Assert.assertTrue(((Integer)sp.value == 12 ? 1 : 0) != 0);
        Assert.assertTrue((sp.status == SyncPromises.Status.RESOLVED ? 1 : 0) != 0);
    }

    @Test
    public void testErrorHandlingWhenExceptionOccurs() {
        RuntimeException te = new RuntimeException("Test exception");
        Promise p = this.promises.resolve((Object)"a").then(a -> {
            throw te;
        }).then(i -> {
            Assert.fail((String)"This 'then' should've been jumped over");
            return this.promises.resolve();
        }).catch_(err -> {
            Assert.assertEquals((Object)err, (Object)te);
            return this.promises.resolve((Object)17);
        });
        SyncPromises.SyncPromise sp = (SyncPromises.SyncPromise)p;
        Assert.assertTrue(((Integer)sp.value == 17 ? 1 : 0) != 0);
        Assert.assertTrue((sp.status == SyncPromises.Status.RESOLVED ? 1 : 0) != 0);
    }

    @Test
    public void testAllWithOneRejection() {
        Promise resolved1 = this.promises.resolve((Object)1);
        Promise resolved2 = this.promises.resolve((Object)2);
        Promise rejected = this.promises.reject((Object)0);
        Arrays.asList(this.promises.all(new Promise[]{rejected, resolved1, resolved2}), this.promises.all(new Promise[]{resolved2, rejected, resolved1}), this.promises.all(new Promise[]{resolved1, resolved2, rejected})).forEach(p -> p.then(i -> {
            Assert.fail((String)"Promise should've not been resolved!");
            return this.promises.resolve();
        }).catch_(zero -> {
            Assert.assertEquals((Object)0, (Object)zero);
            return this.promises.resolve();
        }));
    }

    @Test
    public void testAllWithNoRejections() {
        Promise resolved1 = this.promises.resolve((Object)1);
        Promise resolved2 = this.promises.resolve((Object)2);
        Promise resolved3 = this.promises.resolve((Object)3);
        this.promises.all(new Promise[]{resolved1, resolved2, resolved3}).then(i -> {
            Assert.assertEquals((Object)3, (Object)i);
            return this.promises.resolve();
        }).catch_(e -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
    }

    @Test
    public void testAllMappingWithNoRejections() {
        this.promises.all(Arrays.asList(1, 2, 3, 4), arg_0 -> ((SyncPromises)this.promises).resolve(arg_0)).then(i -> {
            Assert.assertEquals((Object)4, (Object)i);
            return this.promises.resolve();
        }).catch_(e -> {
            Assert.fail((String)"Promise should've not been resolved!");
            return this.promises.resolve();
        });
    }

    @Test
    public void testAllMappingWithOneRejection() {
        this.promises.all(Arrays.asList(1, 2, 3, 4), i -> i == 3 ? this.promises.reject(i) : this.promises.resolve(i)).then(i -> {
            Assert.fail((String)"Promise should've not been resolved!");
            return this.promises.resolve();
        }).catch_(e -> {
            Assert.assertEquals((Object)3, (Object)e);
            return this.promises.resolve();
        });
    }

    @Test
    public void testReduceLazilyWithNoRejections() {
        AtomicInteger sum = new AtomicInteger(0);
        this.promises.reduceLazily(Arrays.asList(1, 2, 4, 8), i -> this.promises.resolve().then(e -> {
            Assert.assertTrue((sum.get() < i ? 1 : 0) != 0);
            sum.addAndGet((int)i);
            return this.promises.resolve(i);
        })).then(i -> {
            Assert.assertEquals((Object)8, (Object)i);
            return this.promises.resolve();
        }).catch_(e -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        }).then(ignore -> {
            Assert.assertEquals((Object)15, (Object)sum.get());
            return this.promises.resolve();
        });
    }

    @Test
    public void testReduceLazilyWithOneRejection() {
        AtomicInteger sum = new AtomicInteger(0);
        this.promises.reduceLazily(Arrays.asList(1, 2, 4, 8), i -> i == 4 ? this.promises.reject((Object)4) : this.promises.resolve().then(e -> {
            Assert.assertTrue((sum.get() < i ? 1 : 0) != 0);
            sum.addAndGet((int)i);
            return this.promises.resolve(i);
        })).then(i -> {
            Assert.fail((String)"Promise should've not been resolved!");
            return this.promises.resolve();
        }).catch_(e -> {
            Assert.assertEquals((Object)4, (Object)e);
            return this.promises.resolve();
        }).then(ignore -> {
            Assert.assertEquals((Object)3, (Object)sum.get());
            return this.promises.resolve();
        });
    }

    @Test
    public void testReduceLazilyChainingWithNoInterruptions() {
        AtomicInteger sum = new AtomicInteger(0);
        this.promises.reduceLazilyChaining(Arrays.asList(1, 2, 4, 8, 16), (chain, i) -> {
            Assert.assertTrue((sum.get() < i ? 1 : 0) != 0);
            sum.addAndGet((int)i);
            return this.promises.resolve(i);
        }).catch_(e -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        }).then(chainResult -> {
            Assert.assertEquals((Object)16, (Object)chainResult);
            Assert.assertEquals((Object)31, (Object)sum.get());
            return this.promises.resolve();
        });
    }

    @Test
    public void testReduceLazilyChainingWithInterruption() {
        AtomicInteger sum = new AtomicInteger(0);
        this.promises.reduceLazilyChaining(Arrays.asList(1, 2, 4, 8, 16), (chain, i) -> {
            if (i == 4) {
                return this.promises.reject(chain);
            }
            Assert.assertTrue((sum.get() < i ? 1 : 0) != 0);
            sum.addAndGet((int)i);
            return this.promises.resolve(i);
        }).then(invalid -> {
            Assert.fail((String)"Promise should've not been resolved!");
            return this.promises.resolve();
        }).catch_(chain -> {
            Assert.assertEquals((Object)3, (Object)sum.get());
            return (IThenable)((Supplier)chain).get();
        }).then(chainResult -> {
            Assert.assertNull((Object)chainResult);
            Assert.assertEquals((Object)27, (Object)sum.get());
            return this.promises.resolve();
        }).catch_(e -> {
            Assert.fail((String)"Promise should've been resolved!");
            return this.promises.resolve();
        });
    }

    @Test
    public void reduceWithOrIsTrueOperatorTest() {
        List<Promise> promisesToReduce = Arrays.asList(this.promises.resolve((Object)true), this.promises.resolve((Object)false));
        this.promises.reduce(this.promises.resolve((Object)false), promisesToReduce, (p1, p2) -> p1.then(resultP1 -> p2.then(resultP2 -> this.promises.resolve((Object)(resultP1 != false || resultP2 != false ? 1 : 0))))).then(resultIsTrue -> {
            Assert.assertTrue((boolean)resultIsTrue);
            return this.promises.resolve();
        });
    }

    @Test
    public void reduceWithOrIsFalseOperatorTest() {
        List<Promise> promisesToReduce = Arrays.asList(this.promises.resolve((Object)false), this.promises.resolve((Object)false));
        this.promises.reduce(this.promises.resolve((Object)false), promisesToReduce, (p1, p2) -> p1.then(resultP1 -> p2.then(resultP2 -> this.promises.resolve((Object)(resultP1 != false || resultP2 != false ? 1 : 0))))).then(resultIsTrue -> {
            Assert.assertFalse((boolean)resultIsTrue);
            return this.promises.resolve();
        });
    }

    @Test
    public void reduceWithAndIsTrueOperatorTest() {
        List<Promise> promisesToReduce = Arrays.asList(this.promises.resolve((Object)true), this.promises.resolve((Object)true));
        this.promises.reduce(this.promises.resolve((Object)true), promisesToReduce, (p1, p2) -> p1.then(resultP1 -> p2.then(resultP2 -> this.promises.resolve((Object)(resultP1 != false && resultP2 != false ? 1 : 0))))).then(resultIsTrue -> {
            Assert.assertTrue((boolean)resultIsTrue);
            return this.promises.resolve();
        });
    }

    @Test
    public void reduceWithAndIsFalseOperatorTest() {
        List<Promise> promisesToReduce = Arrays.asList(this.promises.resolve((Object)false), this.promises.resolve((Object)true));
        this.promises.reduce(this.promises.resolve((Object)true), promisesToReduce, (p1, p2) -> p1.then(resultP1 -> p2.then(resultP2 -> this.promises.resolve((Object)(resultP1 != false && resultP2 != false ? 1 : 0))))).then(resultIsTrue -> {
            Assert.assertFalse((boolean)resultIsTrue);
            return this.promises.resolve();
        });
    }
}

