/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.mocks;

import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;

@RunWith(value=MockitoJUnitRunner.class)
public class CallerMockTest {
    SampleTarget sampleTarget;
    RemoteCallback<String> successCallBack;
    ErrorCallback<String> errorCallBack;
    private CallerMock<SampleTarget> callerMock;
    private CallerSampleClient callerSample;

    @Before
    public void setup() {
        this.sampleTarget = (SampleTarget)Mockito.mock(SampleTarget.class);
        this.successCallBack = (RemoteCallback)Mockito.mock(RemoteCallback.class);
        this.errorCallBack = (ErrorCallback)Mockito.mock(ErrorCallback.class);
    }

    @Test
    public void callerSampleTest() {
        this.callerMock = new CallerMock((Object)this.sampleTarget);
        this.callerSample = new CallerSampleClient((Caller<SampleTarget>)this.callerMock);
        this.callerSample.targetCall();
        ((SampleTarget)Mockito.verify((Object)this.sampleTarget)).targetCall();
        ((RemoteCallback)Mockito.verify(this.successCallBack, (VerificationMode)Mockito.never())).callback((Object)Mockito.anyString());
        ((ErrorCallback)Mockito.verify(this.errorCallBack, (VerificationMode)Mockito.never())).error((Object)Mockito.anyString(), (Throwable)Mockito.any(SampleException.class));
    }

    @Test
    public void callerSampleCallBackSuccessTest() {
        Mockito.when((Object)this.sampleTarget.targetCall()).thenReturn((Object)"callback");
        this.callerMock = new CallerMock((Object)this.sampleTarget);
        this.callerSample = new CallerSampleClient(this.callerMock, this.successCallBack, this.errorCallBack);
        this.callerSample.targetCallWithSuccessCallBack();
        ((SampleTarget)Mockito.verify((Object)this.sampleTarget)).targetCall();
        ((RemoteCallback)Mockito.verify(this.successCallBack)).callback((Object)"callback");
        ((ErrorCallback)Mockito.verify(this.errorCallBack, (VerificationMode)Mockito.never())).error((Object)Mockito.anyString(), (Throwable)Mockito.any(SampleException.class));
    }

    @Test
    public void callerSampleCallBackErrorTest() throws SampleException {
        Mockito.when((Object)this.sampleTarget.targetCallWithCheckedException()).thenThrow(SampleException.class);
        this.callerMock = new CallerMock((Object)this.sampleTarget);
        this.callerSample = new CallerSampleClient(this.callerMock, this.successCallBack, this.errorCallBack);
        this.callerSample.targetCallWithSuccessAndErrorCallBackCheckedException();
        ((SampleTarget)Mockito.verify((Object)this.sampleTarget)).targetCallWithCheckedException();
        ((ErrorCallback)Mockito.verify(this.errorCallBack)).error((Object)((String)Mockito.any()), (Throwable)Mockito.any(SampleException.class));
        ((RemoteCallback)Mockito.verify(this.successCallBack, (VerificationMode)Mockito.never())).callback((Object)Mockito.anyString());
    }

    @Test
    public void callerSampleCallBackPrimitiveTypeTest() throws SampleException {
        Mockito.when((Object)this.sampleTarget.targetPrimitiveType()).thenThrow(SampleException.class);
        this.callerMock = new CallerMock((Object)this.sampleTarget);
        this.callerSample = new CallerSampleClient(this.callerMock, this.successCallBack, this.errorCallBack);
        this.callerSample.targetPrimitiveType();
        ((SampleTarget)Mockito.verify((Object)this.sampleTarget)).targetPrimitiveType();
        ((ErrorCallback)Mockito.verify(this.errorCallBack)).error((Object)((String)Mockito.any()), (Throwable)Mockito.any(SampleException.class));
        ((RemoteCallback)Mockito.verify(this.successCallBack, (VerificationMode)Mockito.never())).callback((Object)Mockito.anyString());
    }

    @Test
    public void callerSampleCallBackErrorbyRunTimeExceptionTest() {
        SampleTarget target = new SampleTarget(){

            @Override
            public String targetCall() {
                throw new RuntimeException();
            }

            @Override
            public String targetCallWithCheckedException() throws SampleException {
                return null;
            }

            @Override
            public long targetPrimitiveType() {
                return 0L;
            }
        };
        this.callerMock = new CallerMock((Object)target);
        this.callerSample = new CallerSampleClient(this.callerMock, this.successCallBack, this.errorCallBack);
        this.callerSample.targetCallWithSuccessAndErrorCallBack();
        ((RemoteCallback)Mockito.verify(this.successCallBack, (VerificationMode)Mockito.never())).callback((Object)Mockito.anyString());
        ((ErrorCallback)Mockito.verify(this.errorCallBack)).error((Object)((String)Mockito.any()), (Throwable)Mockito.any(RuntimeException.class));
    }

    @Test
    public void callerMockitoCallBackErrorbyRunTimeExceptionTest() {
        SampleTarget target = (SampleTarget)Mockito.mock(SampleTarget.class);
        Mockito.when((Object)target.targetCall()).thenThrow(new Throwable[]{new RuntimeException()});
        this.callerMock = new CallerMock((Object)target);
        this.callerSample = new CallerSampleClient(this.callerMock, this.successCallBack, this.errorCallBack);
        this.callerSample.targetCallWithSuccessAndErrorCallBack();
        ((RemoteCallback)Mockito.verify(this.successCallBack, (VerificationMode)Mockito.never())).callback((Object)Mockito.anyString());
        ((ErrorCallback)Mockito.verify(this.errorCallBack)).error((Object)((String)Mockito.any()), (Throwable)Mockito.any(RuntimeException.class));
    }

    private class SampleException
    extends RuntimeException {
        private SampleException() {
        }
    }

    private class CallerSampleClient {
        private RemoteCallback successCallBack;
        private ErrorCallback errorCallBack;
        private Caller<SampleTarget> caller;

        @Inject
        public CallerSampleClient(Caller<SampleTarget> caller) {
            this.caller = caller;
        }

        public CallerSampleClient(CallerMock<SampleTarget> callerMock, RemoteCallback successCallBack, ErrorCallback errorCallBack) {
            this.caller = callerMock;
            this.successCallBack = successCallBack;
            this.errorCallBack = errorCallBack;
        }

        public void targetCall() {
            ((SampleTarget)this.caller.call()).targetCall();
        }

        public void targetCallWithSuccessCallBack() {
            ((SampleTarget)this.caller.call(this.successCallBack)).targetCall();
        }

        public void targetCallWithSuccessAndErrorCallBack() {
            ((SampleTarget)this.caller.call(this.successCallBack, this.errorCallBack)).targetCall();
        }

        public void targetCallWithSuccessAndErrorCallBackCheckedException() throws SampleException {
            ((SampleTarget)this.caller.call(this.successCallBack, this.errorCallBack)).targetCallWithCheckedException();
        }

        public long targetPrimitiveType() {
            return ((SampleTarget)this.caller.call(this.successCallBack, this.errorCallBack)).targetPrimitiveType();
        }
    }

    private static interface SampleTarget {
        public String targetCall();

        public String targetCallWithCheckedException() throws SampleException;

        public long targetPrimitiveType();
    }
}

