/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.shared.experimental.ExperimentalAssetRemoved;
import org.uberfire.shared.experimental.ExperimentalEditorService;
import org.uberfire.spaces.SpacesAPI;

@Service
@ApplicationScoped
public class ExperimentalEditorServiceImpl
implements ExperimentalEditorService {
    public static final String STORAGE_PATH = "content";
    public static final String SEPARATOR = "/";
    public static final String EXTENSION = ".exp";
    private SpacesAPI spaces;
    private IOService ioService;
    private FileSystem fileSystem;
    private Event<ExperimentalAssetRemoved> assetRemovedEvent;

    ExperimentalEditorServiceImpl() {
    }

    @Inject
    public ExperimentalEditorServiceImpl(SpacesAPI spaces, @Named(value="configIO") IOService ioService, Event<ExperimentalAssetRemoved> assetRemovedEvent) {
        this.spaces = spaces;
        this.ioService = ioService;
        this.assetRemovedEvent = assetRemovedEvent;
    }

    @PostConstruct
    public void init() {
        this.initializeFileSystem();
    }

    public List<org.uberfire.backend.vfs.Path> listAll() {
        Path path = this.fileSystem.getPath(STORAGE_PATH, new String[0]);
        ArrayList<org.uberfire.backend.vfs.Path> result = new ArrayList<org.uberfire.backend.vfs.Path>();
        this.ioService.newDirectoryStream(path, entry -> entry.getFileName().toString().endsWith(EXTENSION)).forEach(assetPath -> result.add(Paths.convert((Path)assetPath)));
        return result;
    }

    public org.uberfire.backend.vfs.Path create(String assetName) {
        String path = "content/" + assetName + EXTENSION;
        Path fsPath = this.fileSystem.getPath(path, new String[0]);
        if (!this.ioService.exists(fsPath)) {
            this.ioService.write(fsPath, "", new OpenOption[0]);
            return Paths.convert((Path)fsPath);
        }
        throw new FileAlreadyExistsException(fsPath.toString());
    }

    public String load(org.uberfire.backend.vfs.Path path) {
        Path fsPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (this.ioService.exists(fsPath)) {
            return this.ioService.readAllString(fsPath);
        }
        return null;
    }

    public void save(org.uberfire.backend.vfs.Path path, String content) {
        Path fsPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        if (this.ioService.exists(fsPath)) {
            this.ioService.write(fsPath, content, new OpenOption[0]);
        }
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        Path fsPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        try {
            this.ioService.startBatch(fsPath.getFileSystem());
            this.ioService.delete(Paths.convert((org.uberfire.backend.vfs.Path)path), new DeleteOption[0]);
            this.assetRemovedEvent.fire((Object)new ExperimentalAssetRemoved(path));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.ioService.endBatch();
        }
    }

    protected void initializeFileSystem() {
        URI fileSystemURI = this.spaces.resolveFileSystemURI(SpacesAPI.Scheme.DEFAULT, SpacesAPI.DEFAULT_SPACE, "experimental");
        try {
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("init", Boolean.TRUE);
            options.put("internal", Boolean.TRUE);
            this.fileSystem = this.ioService.newFileSystem(fileSystemURI, options);
        }
        catch (FileSystemAlreadyExistsException e) {
            this.fileSystem = this.ioService.getFileSystem(fileSystemURI);
        }
    }
}

