/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.google.gwt.regexp.shared.RegExp;
import java.math.BigDecimal;
import org.uberfire.ext.widgets.common.client.common.AbstractRestrictedEntryTextBox;

public class NumericBigDecimalTextBox
extends AbstractRestrictedEntryTextBox {
    private static final RegExp VALID = RegExp.compile((String)"(^[-]?[0-9]*\\.?[0-9]*([eE][-+]?[0-9]*)?$)");

    public NumericBigDecimalTextBox() {
        super(false);
    }

    public NumericBigDecimalTextBox(boolean allowEmptyValue) {
        super(allowEmptyValue);
    }

    @Override
    public boolean isValidValue(String value, boolean isOnFocusLost) {
        boolean isValid = VALID.test(value);
        if (!isValid) {
            return isValid;
        }
        if (!isOnFocusLost && "-".equals(value)) {
            return true;
        }
        try {
            BigDecimal check = new BigDecimal(value);
        }
        catch (NumberFormatException nfe) {
            isValid = "".equals(value) && this.allowEmptyValue;
        }
        return isValid;
    }

    @Override
    protected String makeValidValue(String value) {
        return "0.0";
    }
}

