/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.ace;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.ext.widgets.common.client.ace.AceAnnotation;
import org.uberfire.ext.widgets.common.client.ace.AceAnnotationType;
import org.uberfire.ext.widgets.common.client.ace.AceCommand;
import org.uberfire.ext.widgets.common.client.ace.AceCompletionCallback;
import org.uberfire.ext.widgets.common.client.ace.AceCompletionCallbackImpl;
import org.uberfire.ext.widgets.common.client.ace.AceCompletionProvider;
import org.uberfire.ext.widgets.common.client.ace.AceEditorCallback;
import org.uberfire.ext.widgets.common.client.ace.AceEditorCursorPosition;
import org.uberfire.ext.widgets.common.client.ace.AceEditorMode;
import org.uberfire.ext.widgets.common.client.ace.AceEditorTheme;

public class AceEditor
extends Composite
implements RequiresResize,
HasText,
TakesValue<String> {
    private static int nextId = 0;
    private final String elementId;
    private JavaScriptObject editor;
    private JsArray<AceAnnotation> annotations = (JsArray)JavaScriptObject.createArray().cast();
    private Element divElement;

    public AceEditor() {
        this.elementId = "_aceGWT" + nextId;
        ++nextId;
        FlowPanel div = new FlowPanel();
        div.getElement().setId(this.elementId);
        this.initWidget((Widget)div);
        this.divElement = div.getElement();
    }

    @Deprecated
    public AceEditor(boolean unused) {
        this();
    }

    public native void startEditor();

    public native void redisplay();

    public native void destroy();

    public void setTheme(AceEditorTheme theme) {
        this.setThemeByName(theme.getName());
    }

    public native void setThemeByName(String var1);

    public void setMode(AceEditorMode mode) {
        this.setModeByName(mode.getName());
    }

    public native void setModeByName(String var1);

    public native void addOnChangeHandler(AceEditorCallback var1);

    public native void addOnCursorPositionChangeHandler(AceEditorCallback var1);

    public native void setFontSize(String var1);

    public native String getText();

    public native void setText(String var1);

    public native String getLine(int var1);

    public native void insertAtCursor(String var1);

    public native AceEditorCursorPosition getCursorPosition();

    private AceEditorCursorPosition getCursorPositionImpl(double row, double column) {
        return new AceEditorCursorPosition((int)row, (int)column);
    }

    public int getIndexFromPosition(AceEditorCursorPosition position) {
        return this.getIndexFromPositionImpl(position.toJsObject());
    }

    private native int getIndexFromPositionImpl(JavaScriptObject var1);

    public native AceEditorCursorPosition getPositionFromIndex(int var1);

    public native void setUseSoftTabs(boolean var1);

    public native void setTabSize(int var1);

    public native void gotoLine(int var1);

    public native void scrollToLine(int var1);

    public native void setHScrollBarAlwaysVisible(boolean var1);

    public native void setShowGutter(boolean var1);

    public native void setReadOnly(boolean var1);

    public native void setHighlightSelectedWord(boolean var1);

    public native void setShowPrintMargin(boolean var1);

    public void addAnnotation(int row, int column, String text, AceAnnotationType type) {
        this.annotations.push((JavaScriptObject)AceAnnotation.create(row, column, text, type.getName()));
    }

    public native void setAnnotations();

    public native void clearAnnotations();

    private void resetAnnotations() {
        this.annotations = (JsArray)JavaScriptObject.createArray().cast();
    }

    public void removeCommand(AceCommand command) {
        this.removeCommandByName(command.getName());
    }

    public native void removeCommandByName(String var1);

    public native void setUseWrapMode(boolean var1);

    public void onResize() {
        this.redisplay();
    }

    public void setValue(String value) {
        this.setText(value);
    }

    public String getValue() {
        return this.getText();
    }

    public native void setAutocompleteEnabled(boolean var1);

    public static native void removeAllExistingCompleters();

    public static native void addCompletionProvider(AceCompletionProvider var0);

    private static AceCompletionCallback wrapCompletionCallback(JavaScriptObject jsCallback) {
        return new AceCompletionCallbackImpl(jsCallback);
    }

    public native void setFocus();
}

