/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.colorpicker;

import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.ext.widgets.common.client.colorpicker.ColorUtils;
import org.uberfire.ext.widgets.common.client.colorpicker.HueChangedEvent;
import org.uberfire.ext.widgets.common.client.colorpicker.HueChangedHandler;
import org.uberfire.ext.widgets.common.client.colorpicker.HuePicker;
import org.uberfire.ext.widgets.common.client.colorpicker.SaturationLightnessPicker;
import org.uberfire.ext.widgets.common.client.colorpicker.dialog.Dialog;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;

public class ColorPickerDialog
extends Dialog {
    private SaturationLightnessPicker slPicker;
    private HuePicker huePicker;
    private String color;

    @Override
    protected Widget createDialogArea() {
        this.setText(CommonConstants.INSTANCE.ColorPickerTitle());
        HorizontalPanel panel = new HorizontalPanel();
        this.slPicker = new SaturationLightnessPicker();
        panel.add((Widget)this.slPicker);
        this.huePicker = new HuePicker();
        panel.add((Widget)this.huePicker);
        this.huePicker.addHueChangedHandler(new HueChangedHandler(){

            @Override
            public void hueChanged(HueChangedEvent event) {
                ColorPickerDialog.this.slPicker.setHue(event.getHue());
            }
        });
        return panel;
    }

    public void setColor(String color) {
        int[] rgb = ColorUtils.getRGB(color);
        int[] hsl = ColorUtils.rgb2hsl(rgb);
        this.huePicker.setHue(hsl[0]);
        this.slPicker.setColor(color);
    }

    public String getColor() {
        return this.color;
    }

    @Override
    protected void buttonClicked(Widget button) {
        if (button == this.getOkButton()) {
            this.color = this.slPicker.getColor();
        }
        this.close(button == this.getCancelButton());
    }
}

