/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.AnchorElement;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import org.uberfire.mvp.Command;

public class FileUpload
extends Composite {
    private final Command command;
    @UiField
    AnchorElement uploadButton;
    @UiField
    AnchorElement chooseButton;
    @UiField
    InputElement file;
    @UiField
    InputElement fileText;
    private boolean isDisabled = false;
    private static FileUploadBinder uiBinder = (FileUploadBinder)GWT.create(FileUploadBinder.class);

    public FileUpload() {
        this(null, false);
    }

    public FileUpload(Command command) {
        this(command, true);
    }

    public FileUpload(final Command command, boolean displayUploadButton) {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.command = command;
        this.fileText.setReadOnly(true);
        DOM.sinkEvents((com.google.gwt.dom.client.Element)((Element)this.file.cast()), (int)1024);
        DOM.setEventListener((com.google.gwt.dom.client.Element)((Element)this.file.cast()), (EventListener)new EventListener(){

            public void onBrowserEvent(Event event) {
                FileUpload.this.fileText.setValue(FileUpload.this.file.getValue());
            }
        });
        DOM.sinkEvents((com.google.gwt.dom.client.Element)((Element)this.chooseButton.cast()), (int)1);
        DOM.setEventListener((com.google.gwt.dom.client.Element)((Element)this.chooseButton.cast()), (EventListener)new EventListener(){

            public void onBrowserEvent(Event event) {
                FileUpload.this.file.click();
            }
        });
        if (displayUploadButton) {
            DOM.sinkEvents((com.google.gwt.dom.client.Element)((Element)this.uploadButton.cast()), (int)1);
            DOM.setEventListener((com.google.gwt.dom.client.Element)((Element)this.uploadButton.cast()), (EventListener)new EventListener(){

                public void onBrowserEvent(Event event) {
                    if (FileUpload.this.isDisabled) {
                        return;
                    }
                    if (command != null) {
                        command.execute();
                    }
                }
            });
        } else {
            this.uploadButton.removeFromParent();
            this.uploadButton = null;
        }
    }

    public void setName(String name) {
        this.file.setName(name);
    }

    public void upload() {
        this.command.execute();
    }

    public String getFilename() {
        return this.file.getValue();
    }

    public void setEnabled(boolean b) {
        if (this.uploadButton == null) {
            return;
        }
        if (!b) {
            this.isDisabled = true;
            this.uploadButton.addClassName("disabled");
        } else {
            this.isDisabled = false;
            this.uploadButton.removeClassName("disabled");
        }
    }

    static interface FileUploadBinder
    extends UiBinder<Widget, FileUpload> {
    }
}

