/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.github.gwtbootstrap.client.ui.ListBox;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiFactory;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ProvidesKey;
import org.uberfire.ext.services.shared.preferences.GridGlobalPreferences;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.widgets.common.client.resources.UberfireSimplePagerResources;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.ext.widgets.common.client.tables.SimpleTable;
import org.uberfire.ext.widgets.common.client.tables.UberfireSimplePager;

public class PagedTable<T>
extends SimpleTable<T> {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    private int pageSize;
    private AsyncDataProvider<T> dataProvider;
    @UiField
    public UberfireSimplePager pager;
    @UiField
    public ListBox pageSizesSelector;
    public boolean showPageSizesSelector = false;
    private boolean showFFButton = true;
    private boolean showLButton = true;

    public PagedTable() {
    }

    public PagedTable(int pageSize) {
        this.pageSize = pageSize;
        this.dataGrid.setPageSize(pageSize);
        this.pager.setDisplay((HasRows)this.dataGrid);
        this.createPageSizesListBox(5, 20, 5);
    }

    public PagedTable(int pageSize, ProvidesKey<T> providesKey) {
        super(providesKey);
        this.pageSize = pageSize;
        this.dataGrid.setPageSize(pageSize);
        this.pager.setDisplay((HasRows)this.dataGrid);
        this.createPageSizesListBox(5, 20, 5);
    }

    public PagedTable(int pageSize, ProvidesKey<T> providesKey, GridGlobalPreferences gridGlobalPreferences) {
        super(providesKey, gridGlobalPreferences);
        this.pageSizesSelector.setVisible(false);
        this.pageSize = pageSize;
        this.dataGrid.setPageSize(pageSize);
        this.pager.setDisplay((HasRows)this.dataGrid);
        this.createPageSizesListBox(5, 20, 5);
    }

    public PagedTable(int pageSize, ProvidesKey<T> providesKey, GridGlobalPreferences gridGlobalPreferences, boolean showPageSizesSelector) {
        super(providesKey, gridGlobalPreferences);
        this.showPageSizesSelector = showPageSizesSelector;
        this.pageSize = pageSize;
        this.dataGrid.setPageSize(pageSize);
        this.pager.setDisplay((HasRows)this.dataGrid);
        this.createPageSizesListBox(5, 20, 5);
    }

    @Override
    protected Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    public void setDataProvider(AsyncDataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
        this.dataProvider.addDataDisplay((HasData)this.dataGrid);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageStart() {
        return this.pager.getPageStart();
    }

    public final void loadPageSizePreferences() {
        this.pageSize = this.getPageSizeStored();
        this.dataGrid.setPageSize(this.pageSize);
        this.pager.setPageSize(this.pageSize);
        this.dataGrid.setHeight(this.pageSize * 41 + 42 + "px");
        this.pageSizesSelector.setVisible(this.showPageSizesSelector);
    }

    public void createPageSizesListBox(int minPageSize, int maxPageSize, int incPageSize) {
        this.pageSizesSelector.clear();
        for (int i = minPageSize; i <= maxPageSize; i += incPageSize) {
            this.pageSizesSelector.addItem(String.valueOf(i) + " " + CommonConstants.INSTANCE.Items(), String.valueOf(i));
            if (i != this.pageSize) continue;
            this.pageSizesSelector.setSelectedValue(String.valueOf(i));
        }
        this.pageSizesSelector.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                PagedTable.this.storePageSizeInGridPreferences(Integer.parseInt(PagedTable.this.pageSizesSelector.getValue()));
                PagedTable.this.loadPageSizePreferences();
            }
        });
    }

    private void storePageSizeInGridPreferences(int pageSize) {
        GridPreferencesStore gridPreferencesStore = super.getGridPreferencesStore();
        if (gridPreferencesStore != null) {
            gridPreferencesStore.setPageSizePreferences(pageSize);
            super.saveGridPreferences();
        }
    }

    private int getPageSizeStored() {
        GridPreferencesStore gridPreferencesStore = super.getGridPreferencesStore();
        if (gridPreferencesStore != null) {
            return gridPreferencesStore.getPageSizePreferences();
        }
        return this.pageSize;
    }

    private void resetPageSize() {
        GridPreferencesStore gridPreferencesStore = super.getGridPreferencesStore();
        if (gridPreferencesStore != null) {
            gridPreferencesStore.resetPageSizePreferences();
            this.storePageSizeInGridPreferences(gridPreferencesStore.getGlobalPreferences().getPageSize());
            this.loadPageSizePreferences();
        }
    }

    public void setShowLastPagerButton(boolean showLastPagerButton) {
        this.showLButton = showLastPagerButton;
    }

    public void setShowFastFordwardPagerButton(boolean showFastFordwardPagerButton) {
        this.showFFButton = showFastFordwardPagerButton;
    }

    @UiFactory
    public UberfireSimplePager makeUberfireSimplePager() {
        return new UberfireSimplePager(UberfireSimplePager.TextLocation.CENTER, UberfireSimplePagerResources.INSTANCE, this.showFFButton, 100, this.showLButton);
    }

    static interface Binder
    extends UiBinder<Widget, PagedTable> {
    }
}

