/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;

public class FormStyleLayout
extends Composite
implements HasWidgets {
    private FlexTable layout = new FlexTable();
    private FlexTable.FlexCellFormatter formatter = this.layout.getFlexCellFormatter();
    private int numInLayout = 0;

    public FormStyleLayout(ImageResource image, String title) {
        this.addHeader(image, title);
        this.initWidget((Widget)this.layout);
    }

    public FormStyleLayout(Image image, String title) {
        this.addHeader(image, title);
        this.initWidget((Widget)this.layout);
    }

    public FormStyleLayout() {
        this.initWidget((Widget)this.layout);
    }

    public void clear() {
        this.numInLayout = 0;
        this.layout.clear();
    }

    public int addAttribute(String lbl, IsWidget editor) {
        int row = this.numInLayout;
        HTML label = new HTML("<div class='form-field'>" + lbl + "</div>");
        this.layout.setWidget(this.numInLayout, 0, (Widget)label);
        this.formatter.setAlignment(this.numInLayout, 0, HasHorizontalAlignment.ALIGN_RIGHT, HasVerticalAlignment.ALIGN_MIDDLE);
        this.layout.setWidget(this.numInLayout, 1, editor);
        this.formatter.setAlignment(this.numInLayout, 1, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_MIDDLE);
        ++this.numInLayout;
        return row;
    }

    public int addAttribute(String lbl, Widget editor, boolean isVisible) {
        int rowIndex = this.addAttribute(lbl, (IsWidget)editor);
        this.setAttributeVisibility(rowIndex, isVisible);
        return rowIndex;
    }

    public int addRow(Widget w) {
        int row = this.numInLayout;
        this.layout.setWidget(this.numInLayout, 0, w);
        this.formatter.setColSpan(this.numInLayout, 0, 2);
        ++this.numInLayout;
        return row;
    }

    public void setAttributeVisibility(int row, boolean isVisible) {
        this.layout.getWidget(row, 0).setVisible(isVisible);
        this.layout.getWidget(row, 1).setVisible(isVisible);
    }

    protected void addHeader(ImageResource image, String title) {
        HTML name = new HTML("<div class='form-field'><b>" + title + "</b></div>");
        name.setStyleName("resource-name-Label");
        this.doHeader(image, (Widget)name);
    }

    protected void addHeader(Image image, String title) {
        HTML name = new HTML("<div class='form-field'><b>" + title + "</b></div>");
        name.setStyleName("resource-name-Label");
        this.doHeader(image, (Widget)name);
    }

    private void doHeader(ImageResource imageResource, Widget title) {
        Image image = imageResource == null ? new Image() : new Image(imageResource);
        this.layout.setWidget(0, 0, (Widget)image);
        this.formatter.setAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_MIDDLE);
        this.layout.setWidget(0, 1, title);
        ++this.numInLayout;
    }

    private void doHeader(Image image, Widget title) {
        if (image.getAltText() == null) {
            image.setAltText("");
        }
        this.layout.setWidget(0, 0, (Widget)image);
        this.formatter.setAlignment(0, 0, HasHorizontalAlignment.ALIGN_LEFT, HasVerticalAlignment.ALIGN_MIDDLE);
        this.layout.setWidget(0, 1, title);
        ++this.numInLayout;
    }

    protected void addHeader(ImageResource image, String title, Widget titleIcon) {
        HTML name = new HTML("<div class='form-field'><b>" + title + "</b></div>");
        name.setStyleName("resource-name-Label");
        HorizontalPanel horiz = new HorizontalPanel();
        horiz.add((Widget)name);
        horiz.add(titleIcon);
        this.doHeader(image, (Widget)horiz);
    }

    public void setFlexTableWidget(int row, int col, Widget widget) {
        this.layout.setWidget(row, col, widget);
    }

    public int getNumAttributes() {
        return this.numInLayout;
    }

    public void add(Widget w) {
        throw new UnsupportedOperationException("Use one of the addHeader(), addAttribute() or addRow() methods.");
    }

    public Iterator<Widget> iterator() {
        return this.layout.iterator();
    }

    public boolean remove(Widget w) {
        throw new UnsupportedOperationException();
    }
}

