/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.github.gwtbootstrap.client.ui.Button;
import com.github.gwtbootstrap.client.ui.CheckBox;
import com.github.gwtbootstrap.client.ui.DataGrid;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.github.gwtbootstrap.client.ui.resources.ButtonSize;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.uberfire.ext.services.shared.preferences.GridColumnPreference;
import org.uberfire.ext.services.shared.preferences.GridPreferencesStore;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;
import org.uberfire.ext.widgets.common.client.tables.ColumnChangedHandler;
import org.uberfire.ext.widgets.common.client.tables.ColumnMeta;

public class ColumnPicker<T> {
    private final DataGrid<T> dataGrid;
    private final List<ColumnMeta<T>> columnMetaList = new ArrayList<ColumnMeta<T>>();
    private final PopupPanel popup = new PopupPanel(true);
    private GridPreferencesStore gridPreferences;
    private List<ColumnChangedHandler> columnChangedHandler = new ArrayList<ColumnChangedHandler>();

    public ColumnPicker(DataGrid<T> dataGrid, GridPreferencesStore gridPreferences) {
        this.dataGrid = dataGrid;
        this.gridPreferences = gridPreferences;
    }

    public ColumnPicker(DataGrid<T> dataGrid) {
        this.dataGrid = dataGrid;
    }

    public void addColumnChangedHandler(ColumnChangedHandler handler) {
        this.columnChangedHandler.add(handler);
    }

    public void addColumns(List<ColumnMeta<T>> columnMetas) {
        this.columnMetaList.addAll(columnMetas);
        this.sortAndAddColumns(columnMetas);
        this.adjustColumnWidths();
    }

    public Collection<ColumnMeta<T>> getColumnMetaList() {
        return this.columnMetaList;
    }

    public void removeColumn(ColumnMeta<T> columnMeta) {
        this.columnMetaList.remove(columnMeta);
        int count = this.dataGrid.getColumnCount();
        for (int i = 0; i < count; ++i) {
            this.dataGrid.removeColumn(0);
        }
        this.sortAndAddColumns(this.columnMetaList);
        this.adjustColumnWidths();
    }

    protected void sortAndAddColumns(List<ColumnMeta<T>> columnMetas) {
        for (ColumnMeta<T> meta : columnMetas) {
            this.checkColumnMeta(meta);
        }
        Collections.sort(columnMetas);
        for (ColumnMeta<T> meta : columnMetas) {
            this.addColumn(meta);
        }
    }

    protected void checkColumnMeta(ColumnMeta<T> columnMeta) {
        if (this.gridPreferences != null) {
            List columnPreferences = this.gridPreferences.getColumnPreferences();
            if (!columnPreferences.isEmpty()) {
                boolean found = false;
                for (int i = 0; i < this.gridPreferences.getColumnPreferences().size() && !found; ++i) {
                    GridColumnPreference gcp = (GridColumnPreference)this.gridPreferences.getColumnPreferences().get(i);
                    if (!gcp.getName().equals(columnMeta.getHeader().getValue())) continue;
                    columnMeta.setVisible(true);
                    if (gcp.getWidth() != null) {
                        this.dataGrid.setColumnWidth(columnMeta.getColumn(), gcp.getWidth());
                    } else {
                        this.dataGrid.setColumnWidth(columnMeta.getColumn(), 100.0, Style.Unit.PCT);
                    }
                    columnMeta.setPosition(gcp.getPosition());
                    found = true;
                }
                if (!found) {
                    columnMeta.setPosition(-1);
                    columnMeta.setVisible(false);
                }
            } else if (this.gridPreferences.getGlobalPreferences() != null) {
                int position = this.gridPreferences.getGlobalPreferences().getInitialColumns().indexOf(columnMeta.getHeader().getValue());
                if (position != -1) {
                    columnMeta.setVisible(true);
                    columnMeta.setPosition(position);
                } else {
                    columnMeta.setPosition(-1);
                    columnMeta.setVisible(false);
                }
            }
        }
    }

    public void addColumn(ColumnMeta<T> columnMeta) {
        if (columnMeta == null) {
            return;
        }
        if (!this.columnMetaList.contains(columnMeta)) {
            this.columnMetaList.add(columnMeta);
        }
        if (columnMeta.isVisible()) {
            this.dataGrid.addColumn(columnMeta.getColumn(), columnMeta.getHeader());
        }
    }

    public void setGridPreferencesStore(GridPreferencesStore gridPreferences) {
        this.gridPreferences = gridPreferences;
    }

    public Button createToggleButton() {
        final Button button = new Button();
        button.setToggle(true);
        button.setIcon(IconType.LIST_UL);
        button.setTitle(CommonConstants.INSTANCE.ColumnPickerButtonTooltip());
        this.popup.getElement().getStyle().setZIndex(Integer.MAX_VALUE);
        this.popup.addAutoHidePartner((Element)button.getElement());
        this.popup.addCloseHandler((CloseHandler)new CloseHandler<PopupPanel>(){

            public void onClose(CloseEvent<PopupPanel> popupPanelCloseEvent) {
                if (popupPanelCloseEvent.isAutoClosed()) {
                    button.setActive(false);
                }
            }
        });
        button.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!button.isActive()) {
                    ColumnPicker.this.showColumnPickerPopup(button.getAbsoluteLeft() + button.getOffsetWidth(), button.getAbsoluteTop() + button.getOffsetHeight());
                } else {
                    ColumnPicker.this.popup.hide(false);
                }
            }
        });
        return button;
    }

    private void showColumnPickerPopup(final int left, final int top) {
        VerticalPanel popupContent = new VerticalPanel();
        for (final ColumnMeta<T> columnMeta : this.columnMetaList) {
            CheckBox checkBox = new CheckBox((String)columnMeta.getHeader().getValue());
            checkBox.setValue(Boolean.valueOf(columnMeta.isVisible()));
            checkBox.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> booleanValueChangeEvent) {
                    boolean visible = (Boolean)booleanValueChangeEvent.getValue();
                    if (visible) {
                        ColumnPicker.this.dataGrid.insertColumn(ColumnPicker.this.getVisibleColumnIndex(columnMeta), columnMeta.getColumn(), columnMeta.getHeader());
                    } else {
                        ColumnPicker.this.dataGrid.removeColumn(columnMeta.getColumn());
                    }
                    columnMeta.setVisible(visible);
                    ColumnPicker.this.adjustColumnWidths();
                }
            });
            if (this.gridPreferences != null && this.gridPreferences.getGlobalPreferences().getBannedColumns().contains(columnMeta.getHeader().getValue())) continue;
            popupContent.add((Widget)checkBox);
        }
        if (this.gridPreferences != null) {
            Button resetButton = new Button("Reset");
            resetButton.setSize(ButtonSize.MINI);
            resetButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    ColumnPicker.this.resetTableColumns(left, top);
                }
            });
            popupContent.add((Widget)resetButton);
        }
        this.popup.setWidget((Widget)popupContent);
        this.popup.show();
        int finalLeft = left - this.popup.getOffsetWidth();
        this.popup.setPopupPosition(finalLeft, top);
    }

    protected void resetTableColumns(int left, int top) {
        this.gridPreferences.resetGridColumnPreferences();
        int count = this.dataGrid.getColumnCount();
        for (int i = 0; i < count; ++i) {
            this.dataGrid.removeColumn(0);
        }
        for (ColumnMeta<T> columnMeta : this.columnMetaList) {
            int position = this.gridPreferences.getGlobalPreferences().getInitialColumns().indexOf(columnMeta.getHeader().getValue());
            columnMeta.setPosition(position);
            columnMeta.setVisible(position > -1);
        }
        this.sortAndAddColumns(new ArrayList<ColumnMeta<T>>(this.columnMetaList));
        this.adjustColumnWidths();
        this.showColumnPickerPopup(left, top);
    }

    public List<GridColumnPreference> getColumnsState() {
        ArrayList<GridColumnPreference> state = new ArrayList<GridColumnPreference>();
        for (ColumnMeta<T> cm : this.columnMetaList) {
            if (!cm.isVisible()) continue;
            state.add(new GridColumnPreference((String)cm.getHeader().getValue(), Integer.valueOf(this.dataGrid.getColumnIndex(cm.getColumn())), this.dataGrid.getColumnWidth(cm.getColumn())));
        }
        return state;
    }

    private int getVisibleColumnIndex(ColumnMeta<T> columnMeta) {
        int index = 0;
        for (ColumnMeta<T> cm : this.columnMetaList) {
            if (cm.equals(columnMeta)) {
                return index;
            }
            if (!cm.isVisible()) continue;
            ++index;
        }
        return index;
    }

    public void adjustColumnWidths() {
        for (ColumnChangedHandler handler : this.columnChangedHandler) {
            handler.afterColumnChanged();
        }
        List<GridColumnPreference> preferences = this.getColumnsState();
        if (preferences.isEmpty()) {
            return;
        }
        if (preferences.size() == 1) {
            this.dataGrid.setColumnWidth(this.dataGrid.getColumn(0), 100.0, Style.Unit.PCT);
            return;
        }
        int fixedColumnsWidth = 0;
        HashMap<String, String> fixedWidths = new HashMap<String, String>();
        ArrayList<String> columnsToCalculate = new ArrayList<String>();
        for (GridColumnPreference preference : preferences) {
            if (preference.getWidth() != null && preference.getWidth().endsWith(Style.Unit.PX.getType())) {
                fixedWidths.put(preference.getName(), preference.getWidth());
                fixedColumnsWidth += Integer.decode(preference.getWidth().substring(0, preference.getWidth().indexOf(Style.Unit.PX.getType()))).intValue();
                continue;
            }
            columnsToCalculate.add(preference.getName());
        }
        if (columnsToCalculate.size() > 0) {
            double columnPCT = 100 / columnsToCalculate.size();
            if (this.dataGrid.getOffsetWidth() != 0) {
                int availabelColumnSpace = this.dataGrid.getOffsetWidth() - fixedColumnsWidth;
                double availablePCT = availabelColumnSpace * 100 / this.dataGrid.getOffsetWidth();
                columnPCT = columnPCT * availablePCT / 100.0;
            }
            for (ColumnMeta<T> cm : this.columnMetaList) {
                if (!cm.isVisible()) continue;
                if (columnsToCalculate.contains(cm.getHeader().getValue())) {
                    this.dataGrid.setColumnWidth(cm.getColumn(), columnPCT, Style.Unit.PCT);
                    continue;
                }
                this.dataGrid.setColumnWidth(cm.getColumn(), (String)fixedWidths.get(cm.getHeader().getValue()));
            }
        }
    }

    protected void columnMoved(int visibleFromIndex, int visibleBeforeIndex) {
        int visibleColumnFromIndex = 0;
        ColumnMeta<T> columnMetaToMove = null;
        for (int i = 0; i < this.columnMetaList.size(); ++i) {
            ColumnMeta<T> columnMeta = this.columnMetaList.get(i);
            if (!columnMeta.isVisible()) continue;
            if (visibleFromIndex == visibleColumnFromIndex) {
                columnMetaToMove = columnMeta;
                break;
            }
            ++visibleColumnFromIndex;
        }
        if (columnMetaToMove == null) {
            return;
        }
        this.columnMetaList.remove(columnMetaToMove);
        boolean columnInserted = false;
        int visibleColumnBeforeIndex = 0;
        for (int i = 0; i < this.columnMetaList.size(); ++i) {
            ColumnMeta<T> columnMeta = this.columnMetaList.get(i);
            if (!columnMeta.isVisible()) continue;
            if (visibleBeforeIndex == visibleColumnBeforeIndex) {
                this.columnMetaList.add(i, columnMetaToMove);
                columnInserted = true;
                break;
            }
            ++visibleColumnBeforeIndex;
        }
        if (!columnInserted) {
            this.columnMetaList.add(columnMetaToMove);
        }
    }
}

