/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.google.gwt.regexp.shared.RegExp;
import java.math.BigInteger;
import org.uberfire.ext.widgets.common.client.common.AbstractRestrictedEntryTextBox;

public class NumericBigIntegerTextBox
extends AbstractRestrictedEntryTextBox {
    private static final RegExp VALID = RegExp.compile((String)"(^[-]?\\d*$)");

    public NumericBigIntegerTextBox() {
        super(false);
    }

    public NumericBigIntegerTextBox(boolean allowEmptyValue) {
        super(allowEmptyValue);
    }

    @Override
    public boolean isValidValue(String value, boolean isOnFocusLost) {
        boolean isValid = VALID.test(value);
        if (!isValid) {
            return isValid;
        }
        if (!isOnFocusLost && "-".equals(value)) {
            return true;
        }
        try {
            BigInteger check = new BigInteger(value);
        }
        catch (NumberFormatException nfe) {
            isValid = "".equals(value) && this.allowEmptyValue;
        }
        return isValid;
    }

    @Override
    protected String makeValidValue(String value) {
        return "0";
    }
}

