/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.colorpicker.dialog;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import org.uberfire.ext.widgets.common.client.colorpicker.dialog.DialogClosedEvent;
import org.uberfire.ext.widgets.common.client.colorpicker.dialog.DialogClosedHandler;
import org.uberfire.ext.widgets.common.client.resources.i18n.CommonConstants;

public abstract class Dialog
extends DialogBox {
    private ClickHandler buttonClickHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            Dialog.this.buttonClicked((Widget)event.getSource());
        }
    };
    private Widget dialogArea;
    private Button okButton;
    private Button cancelButton;

    public Dialog() {
        VerticalPanel panel = new VerticalPanel();
        this.dialogArea = this.createDialogArea();
        panel.add(this.dialogArea);
        panel.add(this.createButtonBar());
        this.setWidget((Widget)panel);
    }

    public HandlerRegistration addDialogClosedHandler(DialogClosedHandler handler) {
        return this.addHandler(handler, DialogClosedEvent.getType());
    }

    protected void close(boolean canceled) {
        this.hide();
        this.fireDialogClosed(canceled);
    }

    private void fireDialogClosed(boolean canceled) {
        this.fireEvent(new DialogClosedEvent(canceled));
    }

    protected Widget createButtonBar() {
        FlowPanel buttonsPanel = new FlowPanel();
        buttonsPanel.setStyleName("DialogButtons");
        List<? extends Widget> buttons = this.createButtonsForButtonBar();
        for (Widget widget : buttons) {
            buttonsPanel.add(widget);
        }
        return buttonsPanel;
    }

    protected List<? extends Widget> createButtonsForButtonBar() {
        this.okButton = this.createButton(CommonConstants.INSTANCE.OK());
        this.cancelButton = this.createButton(CommonConstants.INSTANCE.Cancel());
        return Arrays.asList(this.okButton, this.cancelButton);
    }

    protected Button createButton(String text) {
        return new Button(text, this.buttonClickHandler);
    }

    protected abstract Widget createDialogArea();

    protected Widget getDialogArea() {
        return this.dialogArea;
    }

    protected abstract void buttonClicked(Widget var1);

    protected Button getOkButton() {
        return this.okButton;
    }

    protected Button getCancelButton() {
        return this.cancelButton;
    }
}

