/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwt.user.client.ui.Widget;

public abstract class Page {
    private final String label;
    private final PageView view;

    public Page(IsWidget widget) {
        this(widget, "");
    }

    public Page(IsWidget widget, String label) {
        this.view = new PageView(this, widget);
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public abstract void onFocus();

    public abstract void onLostFocus();

    PageView getView() {
        return this.view;
    }

    public class PageView
    extends SimpleLayoutPanel
    implements RequiresResize {
        private final Page presenter;
        private final ScrollPanel sp = new ScrollPanel();

        public PageView(Page presenter, IsWidget widget) {
            this.presenter = presenter;
            this.sp.setWidget(widget);
            this.setWidget((Widget)this.sp);
        }

        public void onResize() {
            Widget parent = this.getParent();
            if (parent != null) {
                int width = parent.getOffsetWidth();
                int height = parent.getOffsetHeight();
                this.sp.setPixelSize(width, height);
            }
            super.onResize();
        }

        void onFocus() {
            this.presenter.onFocus();
        }

        public void onLostFocus() {
            this.presenter.onLostFocus();
        }

        public ScrollPanel getSp() {
            return this.sp;
        }
    }
}

