/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.tables;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Inject;
import org.gwtbootstrap3.client.shared.event.TabShowEvent;
import org.gwtbootstrap3.client.shared.event.TabShowHandler;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.NavTabs;
import org.gwtbootstrap3.client.ui.TabContent;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TabPane;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.common.client.api.Caller;
import org.uberfire.ext.services.shared.preferences.MultiGridPreferencesStore;
import org.uberfire.ext.services.shared.preferences.UserPreference;
import org.uberfire.ext.services.shared.preferences.UserPreferencesService;
import org.uberfire.ext.widgets.common.client.tables.DataGridFilter;
import org.uberfire.ext.widgets.common.client.tables.PagedTable;
import org.uberfire.ext.widgets.common.client.tables.popup.NewTabFilterPopup;
import org.uberfire.mvp.Command;

public class FilterPagedTable<T>
extends Composite {
    @UiField
    NavTabs navTabs;
    @UiField
    TabContent tabContent;
    private HashMap<String, DataGridFilter> dataGridFilterHashMap = new HashMap();
    protected MultiGridPreferencesStore multiGridPreferencesStore;
    public Command refreshGridCommand;
    @Inject
    private Caller<UserPreferencesService> preferencesService;
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);

    public FilterPagedTable() {
    }

    public FilterPagedTable(MultiGridPreferencesStore gridsPreferences) {
        this.multiGridPreferencesStore = gridsPreferences;
    }

    public void removeTab(String gridKey) {
        int index = this.getGridIndex(gridKey);
        if (index != -1) {
            this.dataGridFilterHashMap.remove(gridKey);
            this.removeTab(index);
            this.multiGridPreferencesStore.removeTab(gridKey);
            this.multiGridPreferencesStore.setSelectedGrid("");
            if (this.navTabs.getWidgetCount() > 1) {
                this.selectTab(index == 0 ? 0 : index - 1);
            }
            ((UserPreferencesService)this.preferencesService.call()).saveUserPreferences((UserPreference)this.multiGridPreferencesStore);
        }
    }

    public String getValidKeyForAdditionalListGrid(String baseName) {
        int i = this.dataGridFilterHashMap.size();
        while (this.dataGridFilterHashMap.get(baseName + i) != null) {
            ++i;
        }
        return baseName + i;
    }

    public void createNewTab(PagedTable<T> pagedTable, String key, Button button, Command filterCommand) {
        this.multiGridPreferencesStore.setSelectedGrid(key);
        ((UserPreferencesService)this.preferencesService.call()).saveUserPreferences((UserPreference)this.multiGridPreferencesStore);
        if (this.navTabs.getWidgetCount() > 0) {
            this.removeTab(this.navTabs.getWidgetCount() - 1);
        }
        this.addTab(pagedTable, key, filterCommand);
        this.addAddTableButton(button);
        this.selectTab(this.dataGridFilterHashMap.size() - 1);
    }

    public void addTab(PagedTable<T> grid, final String key, Command filterCommand) {
        this.dataGridFilterHashMap.put(key, new DataGridFilter(key, filterCommand));
        String gridHeader = this.multiGridPreferencesStore.getGridSettingParam(key, NewTabFilterPopup.FILTER_TAB_NAME_PARAM);
        String gridTitle = this.multiGridPreferencesStore.getGridSettingParam(key, NewTabFilterPopup.FILTER_TAB_DESC_PARAM);
        grid.addTableTitle(gridTitle);
        Button close = null;
        if (!"base".equals(key)) {
            close = new Button();
            close.setType(ButtonType.LINK);
            close.setIcon(IconType.TIMES);
            close.setSize(ButtonSize.EXTRA_SMALL);
            close.setTitle("close " + gridHeader);
            close.getElement().getStyle().setVerticalAlign(Style.VerticalAlign.TEXT_TOP);
            close.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    FilterPagedTable.this.removeTab(key);
                }
            });
        }
        this.addContentTab(gridHeader, (Widget)close, (Widget)grid, key);
        this.selectTab(this.dataGridFilterHashMap.size() - 1);
    }

    public void addAddTableButton(Button addTableButton) {
        this.addContentTab(null, (Widget)addTableButton, (Widget)new HTML("Default"), null);
    }

    public Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi((Object)this);
    }

    public MultiGridPreferencesStore getMultiGridPreferencesStore() {
        return this.multiGridPreferencesStore;
    }

    public void setMultiGridPreferencesStore(MultiGridPreferencesStore multiGridPreferencesStore) {
        this.multiGridPreferencesStore = multiGridPreferencesStore;
    }

    public void setPreferencesService(Caller<UserPreferencesService> preferencesService) {
        this.preferencesService = preferencesService;
    }

    private int getGridIndex(String key) {
        if (key == null) {
            return -1;
        }
        ArrayList tabsId = this.multiGridPreferencesStore.getGridsId();
        for (int i = 0; i < tabsId.size(); ++i) {
            if (!key.equals(tabsId.get(i))) continue;
            return i;
        }
        return -1;
    }

    public void setSelectedTab() {
        int selectedTab = this.getGridIndex(this.getMultiGridPreferencesStore().getSelectedGrid());
        if (selectedTab != -1) {
            this.selectTab(selectedTab);
        } else {
            this.selectTab(0);
        }
    }

    public void saveTabSettings(String key, HashMap<String, Object> params) {
        this.multiGridPreferencesStore.setGridSettings(key, params);
        ((UserPreferencesService)this.preferencesService.call()).saveUserPreferences((UserPreference)this.multiGridPreferencesStore);
    }

    public void saveNewTabSettings(String key, HashMap<String, Object> params) {
        this.multiGridPreferencesStore.addNewTab(key, params);
        ((UserPreferencesService)this.preferencesService.call()).saveUserPreferences((UserPreference)this.multiGridPreferencesStore);
    }

    public void saveNewRefreshInterval(int newValue) {
        this.multiGridPreferencesStore.setRefreshInterval(newValue);
        ((UserPreferencesService)this.preferencesService.call()).saveUserPreferences((UserPreference)this.multiGridPreferencesStore);
    }

    public int getRefreshInterval() {
        return this.multiGridPreferencesStore.getRefreshInterval();
    }

    public void setRefreshGridCommand(Command refreshGridCommand) {
        this.refreshGridCommand = refreshGridCommand;
    }

    private void selectTab(int index) {
        TabListItem widget = (TabListItem)this.navTabs.getWidget(index);
        if (widget != null) {
            widget.showTab();
        }
    }

    public void removeTab(int index) {
        if (index < 0) {
            return;
        }
        if (index < this.navTabs.getWidgetCount()) {
            this.navTabs.remove(index);
        }
        if (index < this.tabContent.getWidgetCount()) {
            this.tabContent.remove(index);
        }
    }

    private void addContentTab(String title, Widget titleWidget, Widget content, final String key) {
        TabListItem tabListItem = new TabListItem();
        tabListItem.addShowHandler(new TabShowHandler(){

            public void onShow(TabShowEvent event) {
                if (key != null) {
                    FilterPagedTable.this.multiGridPreferencesStore.setSelectedGrid(key);
                    ((UserPreferencesService)FilterPagedTable.this.preferencesService.call()).saveUserPreferences((UserPreference)FilterPagedTable.this.multiGridPreferencesStore);
                    ((DataGridFilter)FilterPagedTable.this.dataGridFilterHashMap.get(key)).getFilterCommand().execute();
                }
            }
        });
        TabPane tabPane = new TabPane();
        tabPane.add(content);
        tabListItem.setDataTargetWidget((Widget)tabPane);
        if (title != null) {
            tabListItem.setText(title);
        }
        if (titleWidget != null) {
            ((Anchor)tabListItem.getWidget(0)).add(titleWidget);
        }
        this.navTabs.add((Widget)tabListItem);
        this.tabContent.add((Widget)tabPane);
    }

    static interface Binder
    extends UiBinder<Widget, FilterPagedTable> {
    }
}

