/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.Icon;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.html.Span;
import org.uberfire.ext.widgets.common.client.resources.CommonCss;
import org.uberfire.ext.widgets.common.client.resources.CommonResources;

public class FileInputButton
extends Composite
implements HasValueChangeHandlers<JsArray<UploadFile>> {
    protected static final CommonCss css = CommonResources.INSTANCE.CSS();
    private Span wrapper = new Span();
    private Span textSpan;
    private FileUpload upload;
    private Icon icon;

    public FileInputButton() {
        this.wrapper.addStyleName("btn");
        this.upload = new FileUpload();
        this.upload.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                FileInputButton.this.fireChanged();
            }
        });
        this.wrapper.add((Widget)this.upload);
        this.wrapper.addStyleName("btn-file");
        this.initWidget((Widget)this.wrapper);
    }

    public void setMultiple(boolean multiple) {
        if (multiple) {
            this.upload.getElement().setPropertyBoolean("multiple", true);
        }
    }

    public void setType(ButtonType additionalStyle) {
        if (additionalStyle != null) {
            this.addStyleName(additionalStyle.getCssName());
        }
    }

    public void addStyleName(String additionalStyle) {
        if (additionalStyle != null) {
            this.wrapper.addStyleName(additionalStyle);
        }
    }

    public void setText(String text) {
        if (this.textSpan == null) {
            this.textSpan = new Span(text);
            this.wrapper.add((Widget)this.textSpan);
        } else {
            this.textSpan.setText(text);
        }
    }

    public String getText() {
        if (this.textSpan != null) {
            return this.textSpan.getText();
        }
        return "";
    }

    public void setIcon(IconType type) {
        if (this.icon == null) {
            this.icon = new Icon(type);
            this.wrapper.add((Widget)this.icon);
        } else {
            this.icon.setType(type);
        }
    }

    private void fireChanged() {
        ValueChangeEvent.fire((HasValueChangeHandlers)this, this.getFiles((Element)this.upload.getElement()));
    }

    private native JsArray<UploadFile> getFiles(Element var1);

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<JsArray<UploadFile>> handler) {
        return super.addHandler(handler, ValueChangeEvent.getType());
    }

    public static class UploadFile
    extends JavaScriptObject {
        protected UploadFile() {
        }

        public final native int getSize();

        public final native String getName();

        public final native String getType();
    }
}

