/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.widgets.common.client.common;

import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.ArrayList;
import java.util.List;

public class DatePickerFormatUtilities {
    private static final String DEFAULT = "dd-M-yyyy";
    private static List<Mapping> mappings = new ArrayList<Mapping>(){
        {
            this.add(new Mapping("yyyy", "yyyy"));
            this.add(new Mapping("yy", "yy"));
            this.add(new Mapping("MMMM", "MM"));
            this.add(new Mapping("MMM", "M"));
            this.add(new Mapping("MM", "mm"));
            this.add(new Mapping("M", "m"));
            this.add(new Mapping("dd", "dd"));
            this.add(new Mapping("d", "d"));
            this.add(new Mapping("HH", "hh"));
            this.add(new Mapping("H", "h"));
            this.add(new Mapping("hh", "HH"));
            this.add(new Mapping("h", "H"));
            this.add(new Mapping("mm", "ii"));
            this.add(new Mapping("m", "i"));
            this.add(new Mapping("ss", "ss"));
            this.add(new Mapping("s", "s"));
            this.add(new Mapping("G", null));
            this.add(new Mapping("L", null));
            this.add(new Mapping("S", null));
            this.add(new Mapping("E", null));
            this.add(new Mapping("c", null));
            this.add(new Mapping("a", "p"));
            this.add(new Mapping("k", null));
            this.add(new Mapping("K", null));
            this.add(new Mapping("z", null));
            this.add(new Mapping("Z", null));
            this.add(new Mapping("v", null));
        }
    };

    public static String convertToBS3DateFormat(String gwtDateFormat) {
        if (!DatePickerFormatUtilities.isValidGWTDateFormat(gwtDateFormat)) {
            return DEFAULT;
        }
        StringBuilder src = new StringBuilder(gwtDateFormat);
        StringBuilder tgt = new StringBuilder();
        for (int idx = 0; idx < gwtDateFormat.length(); ++idx) {
            boolean mapped = false;
            for (Mapping mapping : mappings) {
                if (src.indexOf(mapping.src) != 0) continue;
                if (mapping.tgt != null) {
                    tgt.append(mapping.tgt);
                }
                src.delete(0, mapping.src.length());
                idx = idx + mapping.src.length() - 1;
                mapped = true;
                break;
            }
            if (mapped) continue;
            tgt.append(src.charAt(0));
            src.deleteCharAt(0);
        }
        return tgt.toString();
    }

    private static boolean isValidGWTDateFormat(String gwtDateFormat) {
        try {
            DateTimeFormat.getFormat((String)gwtDateFormat);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        return true;
    }

    private static class Mapping {
        private final String src;
        private final String tgt;

        Mapping(String src, String tgt) {
            this.src = src;
            this.tgt = tgt;
        }
    }
}

